/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.jdbc.component;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.suncode.plugin.datasource.jdbc.common.JdbcDatasourcesUtils;
import com.suncode.plugin.datasource.jdbc.component.QueryParameter;
import com.suncode.plugin.datasource.jdbc.component.enums.WayOfGenerateKeys;
import com.suncode.plugin.datasource.jdbc.connection.ConnectionWrapper;
import com.suncode.plugin.datasource.jdbc.connection.DataSourceConnectionFactory;
import com.suncode.plugin.datasource.jdbc.db.ConnectionService;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.datasource.AbstractDataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceParameter;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.util.PaginatedList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class JdbcDataSource
extends AbstractDataSourceInstance {
    private static final Logger log = LoggerFactory.getLogger(JdbcDataSource.class);
    private final DataSourceConnectionFactory dataSourceConnectionFactory;
    private final String connectionId;
    private final String query;
    private final String countQuery;
    private final List<QueryParameter> queryParametersWithTypes;
    private final List<String> rawQueryParameters;
    private final List<String> rawCountQueryParameters;
    private final Map<String, DataSourceParameter> inputParameters;
    private final Set<DataSourceParameter> outputParameters;
    private final ConnectionService connectionService;
    private final String splitCharacter;

    public JdbcDataSource(Parameters parameters, DataSourceConnectionFactory dataSourceConnectionFactory, ConnectionService connectionService) {
        String queryFromParameter = (String)parameters.get("query", String.class);
        String countQueryFromParameter = (String)parameters.get("countQuery", String.class);
        if (StringUtils.isBlank((CharSequence)countQueryFromParameter)) {
            countQueryFromParameter = "";
        }
        this.dataSourceConnectionFactory = dataSourceConnectionFactory;
        this.connectionService = connectionService;
        this.connectionId = (String)parameters.get("connection", String.class);
        this.queryParametersWithTypes = JdbcDatasourcesUtils.getQueryParametersWithTypes((String[])parameters.get("queryParametersId", String[].class), (String[])parameters.get("queryParametersType", String[].class), (String[])parameters.get("queryParametersParamType", String[].class));
        this.rawQueryParameters = JdbcDatasourcesUtils.readParametersFromQuery(queryFromParameter);
        this.rawCountQueryParameters = JdbcDatasourcesUtils.readParametersFromQuery(countQueryFromParameter);
        this.query = JdbcDatasourcesUtils.getQueryWithFormattedParameters(queryFromParameter, this.rawQueryParameters, this.queryParametersWithTypes);
        this.countQuery = JdbcDatasourcesUtils.getQueryWithFormattedParameters(countQueryFromParameter, this.rawCountQueryParameters, this.queryParametersWithTypes);
        this.inputParameters = JdbcDatasourcesUtils.buildParameters(parameters, Arrays.asList(this.rawQueryParameters, this.rawCountQueryParameters));
        this.outputParameters = this.buildOutputParameters((String[])parameters.get("queryResultColumnsId", String[].class), (String[])parameters.get("queryResultColumnsName", String[].class));
        this.splitCharacter = (String)parameters.get("splitCharacter", String.class);
    }

    private Set<DataSourceParameter> buildOutputParameters(String[] ids, String[] names) {
        Assert.isTrue((ids.length == names.length ? 1 : 0) != 0, (String)"Output parameters length mismatch!");
        return IntStream.range(0, ids.length).mapToObj(i -> new DataSourceParameter(ids[i], names[i])).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    /*
     * Exception decompiling
     */
    public CountedResult<Map<String, Object>> execute(Map<String, String> parameters, Map<String, String> filters, Pagination pagination) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String applyFiltersToQuery(String queryString, Map<String, String> filters) {
        if (StringUtils.isBlank((CharSequence)queryString)) {
            return queryString;
        }
        String replacement = "1=1";
        for (Map.Entry<String, String> entryset : filters.entrySet()) {
            String escapedValue = entryset.getValue().replace("\\", "\\\\").replace("%", "\\%").replace("_", "\\_");
            replacement = replacement.concat(" AND ").concat("CAST(" + entryset.getKey() + " AS VARCHAR)").concat(" LIKE '%" + escapedValue + "%'");
        }
        return queryString.replace("{filters}", replacement);
    }

    private PreparedStatement getPreparedStatement(String query, ConnectionWrapper connectiondto, String connectionId) throws SQLException {
        Connection connection = connectiondto.getConnection();
        if (connectiondto.getIsInternalDatasourceConnection().booleanValue()) {
            WayOfGenerateKeys wayOfGenerateKeys = this.connectionService.getWayOfGenerateKeys(connectionId);
            if (wayOfGenerateKeys == null) {
                WayOfGenerateKeys wayOfGenerateKeys2 = wayOfGenerateKeys = this.connectionService.hasDisableAutoGeneratedKeys(connectionId) != false ? WayOfGenerateKeys.NO_GENERATED_KEYS : WayOfGenerateKeys.RETURN_GENERATED_KEYS;
            }
            if (wayOfGenerateKeys.equals((Object)WayOfGenerateKeys.NO_ARGUMENT)) {
                return connection.prepareStatement(query);
            }
            if (wayOfGenerateKeys.equals((Object)WayOfGenerateKeys.NO_GENERATED_KEYS)) {
                return connection.prepareStatement(query, 2);
            }
        }
        return connection.prepareStatement(query, 1);
    }

    private Pagination ensurePagination(Pagination pagination) {
        if (pagination == null) {
            return Pagination.create((Sorter)new Sorter("1"), (Integer)0, (Integer)Integer.MAX_VALUE);
        }
        if (pagination.getLimit() <= 0) {
            pagination.setLimit(Integer.valueOf(Integer.MAX_VALUE));
        }
        return pagination;
    }

    private String getQueryWithPredefinedParameters(String query, Pagination pagination, Map<String, String> filters) {
        if (pagination != null) {
            query = this.applyPaginationToQuery(query, pagination);
        }
        if (!filters.isEmpty()) {
            query = this.applyFiltersToQuery(query, filters);
        }
        return this.applyLoggedUserParam(query);
    }

    private String applyPaginationToQuery(String query, Pagination pagination) {
        return query.replace("{orderProperty}", pagination.getSorter().getProperty()).replace("{orderDirection}", pagination.getSorter().getDirection().name()).replace("{start}", pagination.getStart().toString()).replace("{limit}", pagination.getLimit().toString());
    }

    private String applyLoggedUserParam(String query) {
        String loggedUser = "''";
        if (UserContext.isActive()) {
            loggedUser = "'" + UserContext.current().getUser().getUserName() + "'";
        }
        return query.replace("{loggedUser}", loggedUser);
    }

    private List<Map<String, Object>> applyPaginationToResultIfNeeded(List<Map<String, Object>> result, Pagination pagination) {
        if (result.size() > pagination.getLimit()) {
            PaginatedList paginated = new PaginatedList(result, pagination.getLimit());
            return paginated.getRange(pagination.getStart());
        }
        return result;
    }

    private String applyArrayParametersToQuery(String query, Map<String, String> data) {
        return this.queryParametersWithTypes.stream().filter(param -> param.getDataType().endsWith("_array")).reduce(query, (acc, param) -> {
            String paramValue = (String)data.get(param.getId());
            if (paramValue == null) {
                paramValue = "";
            }
            CharSequence[] escapedValues = (String[])Arrays.stream(paramValue.split(this.splitCharacter, -1)).map(value -> {
                String escapedValue = StringEscapeUtils.escapeSql((String)value);
                if (param.getDataType().equalsIgnoreCase("string_array") || param.getDataType().equalsIgnoreCase("date_array")) {
                    escapedValue = "'" + escapedValue + "'";
                }
                return escapedValue;
            }).toArray(String[]::new);
            String escapedParamValue = String.join((CharSequence)",", escapedValues);
            return acc.replace("{" + param.getId() + "}", escapedParamValue);
        }, String::concat);
    }

    private List<Map<String, Object>> resultSetToListOfMap(ResultSet rs) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int columns = md.getColumnCount();
        ArrayList list = Lists.newArrayList();
        while (rs.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>(columns);
            for (int i = 1; i <= columns; ++i) {
                row.put(md.getColumnLabel(i), JdbcDatasourcesUtils.extractResultSetValue(rs, i));
            }
            list.add(row);
        }
        this.logQueryResult(list);
        return list;
    }

    public Set<DataSourceParameter> getInputParameters() {
        return Sets.newLinkedHashSet(this.inputParameters.values());
    }

    public Set<DataSourceParameter> getOutputParameters() {
        return this.outputParameters;
    }

    private void logQueries(String query, String countQuery, Map<String, String> values) {
        log.debug("Query to invoke: {}", (Object)query);
        log.debug("Parameters for query: {}", (Object)String.join((CharSequence)", ", this.getValuesForQuery(this.rawQueryParameters, values)));
        log.debug("Count query to invoke: {}", (Object)countQuery);
        log.debug("Parameters for query: {}", (Object)String.join((CharSequence)", ", this.getValuesForQuery(this.rawCountQueryParameters, values)));
    }

    private void logQueryResult(List<Map<String, Object>> result) {
        result.forEach(map -> log.info("Query result: {}", map));
    }

    private List<String> getValuesForQuery(List<String> rawParameters, Map<String, String> allValues) {
        return rawParameters.stream().map(allValues::get).collect(Collectors.toList());
    }

    private static /* synthetic */ boolean lambda$execute$5(int rowsCount) {
        return rowsCount > 0;
    }

    private /* synthetic */ void lambda$execute$4(PreparedStatement statement, Map parametersWithSplintedValues, int i) {
        try {
            JdbcDatasourcesUtils.setStatementParameters(statement, this.rawQueryParameters, parametersWithSplintedValues.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, splattedValue -> ((String[])splattedValue.getValue())[i])), this.inputParameters);
            statement.addBatch();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ boolean lambda$execute$2(int length, String[] value) {
        return value.length == length;
    }

    private /* synthetic */ String[] lambda$execute$1(Map.Entry parameter) {
        return ((String)parameter.getValue()).split(Pattern.quote(this.splitCharacter), -1);
    }
}

