/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.jdbc.common;

import com.google.common.collect.Maps;
import com.suncode.plugin.datasource.jdbc.component.QueryParameter;
import com.suncode.plugin.datasource.jdbc.enums.ParamType;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.datasource.DataSourceParameter;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class JdbcDatasourcesUtils {
    private static final String JDBC_SQL_SERVER_URL_PREFIX = "jdbc:sqlserver://";
    private static final String ENCRYPT_FALSE_URL_PARAMETER = ";encrypt=false";

    public static List<QueryParameter> getQueryParametersWithTypes(String[] ids, String[] dataTypes, String[] paramTypes) {
        int size = ids.length;
        if (paramTypes.length == 0) {
            return IntStream.range(0, size).mapToObj(i -> new QueryParameter(ids[i], dataTypes[i], ParamType.QUERY_PARAM)).collect(Collectors.toList());
        }
        return IntStream.range(0, size).mapToObj(i -> new QueryParameter(ids[i], dataTypes[i], paramTypes[i] != null ? ParamType.valueOf(paramTypes[i]) : ParamType.QUERY_PARAM)).collect(Collectors.toList());
    }

    public static List<String> readParametersFromQuery(String query) {
        ArrayList<String> rawParameters = new ArrayList<String>();
        Matcher matcher = Pattern.compile("\\{([^}]+)\\}").matcher(query);
        while (matcher.find()) {
            String value = matcher.group(1);
            if (!StringUtils.isNotBlank((CharSequence)value) || JdbcDatasourcesUtils.isPredefinedParameter(value) || value.trim().contains(" ")) continue;
            rawParameters.add(value.trim());
        }
        return rawParameters;
    }

    @Deprecated
    public static String getQueryWithFormattedParameters(String query, List<String> rawParameters) {
        for (String rawParameter : rawParameters) {
            query = query.replace("{" + rawParameter + "}", "?");
        }
        return query;
    }

    public static String getQueryWithFormattedParameters(String query, List<String> rawParameters, List<QueryParameter> queryParameters) {
        Iterator<String> it = rawParameters.iterator();
        while (it.hasNext()) {
            String rawParameter = it.next();
            QueryParameter queryParameter = queryParameters.stream().filter(param -> param.getId().equalsIgnoreCase(rawParameter)).findFirst().orElseThrow(() -> new IllegalArgumentException("Query parameters list is different than list of input parameters"));
            if (queryParameter.getParamType() != ParamType.QUERY_PARAM) continue;
            if (queryParameter.getDataType().endsWith("_array")) {
                it.remove();
                continue;
            }
            query = query.replace("{" + rawParameter + "}", "?");
        }
        return query;
    }

    public static void setStatementParameters(PreparedStatement statement, List<String> rawParameters, Map<String, String> values, Map<String, DataSourceParameter> parameters) {
        IntStream.range(0, rawParameters.size()).forEach(index -> {
            String parameterId = (String)rawParameters.get(index);
            try {
                String type = ((DataSourceParameter)parameters.get(parameterId)).getType();
                JdbcDatasourcesUtils.setStatementParameter(statement, type, index + 1, (String)values.get(parameterId));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void setStatementParameter(PreparedStatement statement, String type, int index, String value) throws SQLException {
        int sqlType = JdbcDatasourcesUtils.resolveSqlType(type);
        if (StringUtils.isBlank((CharSequence)value) && sqlType != 12) {
            statement.setNull(index, sqlType);
        } else {
            switch (sqlType) {
                case 4: {
                    statement.setInt(index, Integer.parseInt(value));
                    break;
                }
                case 6: {
                    statement.setFloat(index, Float.parseFloat(value));
                    break;
                }
                case 8: {
                    statement.setDouble(index, Double.parseDouble(value));
                    break;
                }
                case 91: {
                    statement.setDate(index, Date.valueOf(value));
                    break;
                }
                case 93: {
                    statement.setTimestamp(index, Timestamp.valueOf(value));
                    break;
                }
                default: {
                    statement.setString(index, value != null ? value : "");
                }
            }
        }
    }

    private static int resolveSqlType(String type) {
        switch (type) {
            case "integer": {
                return 4;
            }
            case "float": {
                return 6;
            }
            case "double": {
                return 8;
            }
            case "date": {
                return 91;
            }
            case "timestamp": {
                return 93;
            }
        }
        return 12;
    }

    public static Map<String, DataSourceParameter> buildParameters(Parameters parameters, List<List<String>> rawParameters) {
        String[] ids = (String[])parameters.get("queryParametersId");
        String[] names = (String[])parameters.get("queryParametersName");
        String[] types = (String[])parameters.get("queryParametersType");
        LinkedHashMap queryPrameters = Maps.newLinkedHashMap();
        for (int i = 0; i < ids.length; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)ids[i])) continue;
            String name = StringUtils.isBlank((CharSequence)names[i]) ? ids[i] : names[i];
            queryPrameters.put(ids[i], new DataSourceParameter(ids[i], name, types[i]));
        }
        for (List<String> rawParamsList : rawParameters) {
            JdbcDatasourcesUtils.buildNotDefinedParameters(queryPrameters, rawParamsList);
        }
        return queryPrameters;
    }

    private static void buildNotDefinedParameters(Map<String, DataSourceParameter> definedPrameters, List<String> rawParameters) {
        rawParameters.forEach(rawParameter -> {
            if (definedPrameters.get(rawParameter) == null) {
                definedPrameters.put((String)rawParameter, new DataSourceParameter(rawParameter, rawParameter, "string"));
            }
        });
    }

    private static boolean isPredefinedParameter(String parameterId) {
        switch (parameterId) {
            case "start": 
            case "limit": 
            case "orderProperty": 
            case "orderDirection": 
            case "filters": 
            case "loggedUser": {
                return true;
            }
        }
        return false;
    }

    public static Map<String, String> prepareValuesMap(Map<String, Object> data) {
        HashMap<String, String> values = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            values.put(entry.getKey(), entry.getValue().toString());
        }
        return values;
    }

    public static void logQueries(Logger log, String query, Map<String, String> values, List<String> rawQueryParameters) {
        log.debug("Query to invoke: {}", (Object)query);
        if (log.isDebugEnabled()) {
            String value = String.join((CharSequence)", ", JdbcDatasourcesUtils.getValuesForQuery(rawQueryParameters, values));
            log.debug("Parameters for query: {}", (Object)value);
        }
    }

    private static List<String> getValuesForQuery(List<String> rawParameters, Map<String, String> allValues) {
        return rawParameters.stream().map(allValues::get).collect(Collectors.toList());
    }

    public static String resolveSqlServerConnectionUrl(String url) {
        if (JdbcDatasourcesUtils.isMssqlUrlWithoutEncryptFalseParameter(url)) {
            return url + ENCRYPT_FALSE_URL_PARAMETER;
        }
        return url;
    }

    private static boolean isMssqlUrlWithoutEncryptFalseParameter(String url) {
        return url.startsWith(JDBC_SQL_SERVER_URL_PREFIX) && !url.contains(ENCRYPT_FALSE_URL_PARAMETER);
    }

    public static Object extractResultSetValue(ResultSet rs, int columnIndex) throws SQLException {
        Object value = rs.getObject(columnIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            return JdbcDatasourcesUtils.readClobAsString(clob);
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readClobAsString(Clob clob) throws SQLException {
        try (Reader reader = clob.getCharacterStream();){
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
        catch (Exception e) {
            throw new SQLException("Error reading CLOB value", e);
        }
    }

    private JdbcDatasourcesUtils() {
    }
}

