SuncodeFormService.addOnReadyEvent(setAccountingPersonOnReady);

function setAccountingPersonOnReady()
{
    var ais = ServiceFactory.getActivityInfoService();
    var activityDefId = ais.getActivityDefId();
    var processDefId = ais.getProcessDefId();

    if(processDefId === 'dokumenty_k' && activityDefId === 'opis_ksiegowy' )
    {
        setAccountingPerson();
        if(!isHistory)
            setFieldIfProcessReopened();
    }


}


function setAccountingPerson()
{

    var vs = ServiceFactory.getVariableService();
    var currentUserName = Suncode.getCurrentUser();

    vs.setValue('uzytkownik', currentUserName);

    var accountant = vs.getValue('inna_osoba_ksiegujaca');

    if(isEmptyValue( accountant ))
    {
        vs.setValue('inna_osoba_ksiegujaca', getUserDataByLogin(currentUserName, 'fullName'));
        vs.setValue('ksiegujacy_login', currentUserName);
    }

}


function getUserDataByLogin(login, dataType)
{
    var requestObj = new Object();
    requestObj['userName'] = login;

    var response = executeClientServl('GET', 'api/custom/servlet/getUserData', requestObj);

    return response[dataType];
}

function isEmptyValue(value)
{
    if(value == '' || value == null || value == undefined)
        return true;
    return false;
}

function setFieldIfProcessReopened(){
    var fs = ServiceFactory.getFormService();
    if(checkIfProcessReopened()=='TRUE'){
        var vs = ServiceFactory.getVariableService();
        vs.setValue('numer_wlasny',"");
        vs.setValue('id_systemu_egeria',"");
        fs.showButton('anuluj_ksiegowanie');
        alert('UWAGA! Proces został ponownie otwarty. Zawartość pól o nazwie <Numer księgowy> oraz <ID systemu Egeria> została usunięta');
    }
    else {
        fs.hideButton('anuluj_ksiegowanie');
    }
}

function checkIfProcessReopened(){

    var servletName = "api/custom/servlet/ReopenProcessStatus";
    var activityInfoService = ServiceFactory.getActivityInfoService();
    var processId = activityInfoService.getProcessId();

    var jSonParam = new Object();
    jSonParam['processId'] = processId;

    var response = checkIfReopened(servletName, JSON.stringify(jSonParam));
    return JSON.parse(response.responseText);
}

function checkIfReopened(servletName, param) {
    return jQuery.ajax({
        type : "POST",
        url : servletName,
        data : ({
            jSon : param
        }),
        async : false
    });
}