SuncodeFormService.addOnReadyEvent(invoiceTypeAdditionalFunctionsOnReady);

function invoiceTypeAdditionalFunctionsOnReady()
{
    var ais = ServiceFactory.getActivityInfoService();

    var processId = ais.getProcessId();
    var activityId = ais.getActivityId();

    if(processId.indexOf('dokumenty_k') > -1 && activityId.indexOf('opis_merytoryczny') > -1)
    {
        var vs = ServiceFactory.getVariableService();

        vs.addEvent('kategoria_dokumentu', 'change', showOrHideAdditionalFunctions);

        showOrHideAdditionalFunctions();

    }
}

function showOrHideAdditionalFunctions()
{
    var fs = ServiceFactory.getFormService();

    var vs = ServiceFactory.getVariableService();

    var docCategory = vs.getValue('kategoria_dokumentu');

    if(docCategory == 'Faktury spedycyjne')
    {
        SuncodeFormService.suspendLayouts();
        try
        {
            fs.showButton('pobierz_dane_z_ese');
            vs.show('identyfikator_ese');
        }
        finally
        {
            SuncodeFormService.resumeLayouts();
        }
    }
    else
    {
        SuncodeFormService.suspendLayouts();
        try
        {
            fs.hideButton('pobierz_dane_z_ese');
            vs.hide('identyfikator_ese');
        }
        finally
        {
            SuncodeFormService.resumeLayouts();
        }
    }
}

function getESEData()
{
    var vs = ServiceFactory.getVariableService();

    var eseId = vs.getValue('identyfikator_ese');
    var companyId = vs.getValue('identyfikator_firmy');

    if(!isFieldEmpty(eseId))
    {
        var requestObj = new Object();
        requestObj['ese_id'] = eseId;
        requestObj['company_id'] = companyId;

        executeESEResponseData('GET', 'api/custom/servlet/getESEData', requestObj, 'Trwa pobieranie danych z ESE...');
    }
    else
    {
        Ext4.MessageBox.show({
            title:'Pusta wartość!',
            msg: 'Najpierw proszę uzupełnić pole <b>Identyfikator ESE</b>.',
            buttons: Ext4.MessageBox.OK,
            fn: function (btn, text)
            {
                if (btn == 'ok') vs.markError('identyfikator_ese', 'Pole jest puste!');
            },
            icon: Ext4.Msg.WARNING
        });

    }
}

function compareClientCodeAndOtherNmb( headerData )
{
    var isDataCorrect = true;

    var vs = ServiceFactory.getVariableService();

    var msg = '';

    var currentCode = vs.getValue('kod_klienta');

    var currentOtherNmb = vs.getValue('numer_obcy');


    var eseCode = headerData.kod_klienta

    var eseOtherNmb = headerData.numer_obcy;

    if( currentCode != eseCode )
    {
        msg += '<b><u>Kod klienta</u></b> pobrany z ESE (<b>'+eseCode+'</b>) różni się od wprowadzonego na formularzu (<b>'+currentCode+'</b>).<br>';
    }

    if( currentOtherNmb != eseOtherNmb )
    {
        msg += '<b><u>Numer Obcy</u></b> pobrany z ESE (<b>'+eseOtherNmb+'</b>) różni się od wprowadzonego na formularzu (<b>'+currentOtherNmb+'</b>).';
    }

    if(msg != '')
    {
        setEseGetterMessage(msg);
        isDataCorrect = false;
    }

    return isDataCorrect;
}

function setEseGetterMessage(msgText)
{
    Ext4.MessageBox.show({
        title:'Różny kod klienta lub numer obcy.',
        msg: msgText,
        buttons: Ext4.MessageBox.OK,
        fn: null,
        icon: Ext4.Msg.WARNING
    });
}

function clearTableData()
{
    var vss = ServiceFactory.getVariableSetService();

    var grid = vss.get('tabela_dekretacji')

    vss.clear(grid);
}

function insertHeaderData(headerData)
{
    var vs = ServiceFactory.getVariableService();

    //vs.setValue('numer_obcy', headerData.numer_obcy);
    vs.setValue('kategoria_dokumentu', headerData.kategoria_dokumentu);
    //vs.setValue('kod_klienta', headerData.kod_klienta);
    //vs.setValue('nazwa_klienta', headerData.nazwa_klienta);
    //vs.setValue('nip_klienta', removeSignFromString(headerData.nip_klienta, '-', ''));
    //vs.setValue('adres_klienta', headerData.adres_klienta);
    //vs.setValue('identyfikator_adresu', headerData.identyfikator_adresu);
    //vs.setValue('kraj_klienta', headerData.kraj_klienta);
    vs.setValue('data_wystawienia', cutDate(headerData.data_wystawienia));
    vs.setValue('data_wplywu', cutDate(headerData.data_wplywu));
    vs.setValue('data_sprzedazy', cutDate(headerData.data_sprzedazy));
    //vs.setValue('miesiac_ksiegowania', headerData.miesiac_ksiegowania);
    vs.setValue('miesiac_ksiegowania', getBookingDate(headerData.data_ksiegowania));
    vs.setValue('rodzaj_dokumentu', headerData.rodzaj_dokumentu);
    vs.setValue('data_obowiazku_vat', cutDate(headerData.data_obowiazku_vat));
    vs.setValue('termin_zaplaty', cutDate(headerData.termin_zaplaty));
    vs.setValue('kwota_netto', parseFloat(headerData.kwota_netto));
    vs.setValue('waluta', headerData.waluta);
    vs.setValue('kurs_waluty', parseFloat(headerData.kurs_waluty));
    vs.setValue('forma_platnosci', headerData.sposob);
    vs.setValue('zaplacono', (headerData.zaplacono == 1) ? true : false);
}

function insertRowData(rowData)
{
    var vss = ServiceFactory.getVariableSetService();

    var grid = vss.get('tabela_dekretacji')

    var record =
        {
            typ_pozycji: rowData.tpoz_symbol,
            sekcja_rejestru: rowData.sekcja_rejestru,
            nr_zlecenia: rowData.nr_zlecenia,
            opis_pozycji: rowData.opis_pozycji,
            mpk: rowData.mpk,
            wartosc_podstawowa_zlec: rowData.wartosc_podstawowa_zlecenia,
            oplaty_dodatkowe: rowData.oplaty_dodatkowe,
            kwota_netto_pozycji: rowData.wartosc_netto_pozycji,
            stawka_vat: rowData.stawka_vat,
            //nr_pojazdu: rowData.nr_pojazdu,
            kwota_vat: rowData.wartosc_vat_pln,
            nr_teczki: rowData.teczka,
            procent: '',
            nr_pojazdu: '',
            rodzaj_paliwa: '',
            ilosc_paliwa: '',
            nr_zamowienia_iso: '',
            kwota_vat: '',
            kwota_netto_pozycji_w_p: '',
            kwota_brutto_pozycji_w: '',
            data_obowiazku_vat_pozy: '',
            harmonogram_od: '',
            harmonogram_liczba_rat: '',
            stawka_vat_dla_faktury: ''
        }

    vss.addRow(grid, false, record);
}


function cutDate(convertedDate)
{
    var ws = ' ';

    var wsIndex = convertedDate.indexOf(ws);

    return convertedDate.substring(0, wsIndex);
}

function getBookingDate( bookingDate )
{
    var newBookingDate = '';

    if(!isFieldEmpty(bookingDate))
    {
        var sDate = bookingDate.substring(0, 10);

        var array= sDate.split('-');

        var date = new Date( array[0], array[1], array[2]);

        if(date != null)
            newBookingDate = date.getMonth() + '.' + date.getFullYear();
    }

    return newBookingDate;
}

function removeSignFromString(text, sign, rSign)
{
    var resultText = text.split(sign).join(rSign);

    return resultText;
}

function executeESEResponseData(requestMethod, requestUri, requestObj, maskText){
    if( requestObj == null )
    {
        requestObj = new Object();
    }

    Ext4.getBody().mask(maskText);
    Ext4.Ajax.request({
        url: requestUri,
        params: requestObj,
        async: true,
        method: requestMethod,
        success: function(response){
            try{
                var eseData = '';
                var respText = response.responseText;

                if(!isFieldEmpty(respText))
                {
                    eseData = Ext.util.JSON.decode(respText);
                }

                if(!isFieldEmpty(eseData))
                {
                    //dane do naglowka
                    var header = eseData[0];

                    var isDataCorrect = compareClientCodeAndOtherNmb(header);

                    if( isDataCorrect != false )
                    {
                        insertHeaderData(header);

                        //dane do tabeli dynamicznej
                        clearTableData();
                        for( var index = 0; index < eseData.length; index++ )
                        {
                            var row = eseData[index];
                            insertRowData(row);
                        }
                    }
                    Ext4.getBody().unmask();
                }
                else
                {
                    Ext4.getBody().unmask();
                    Ext4.MessageBox.show({
                        title:'Brak danych!',
                        msg: 'Podany <b>Identyfikator ESE</b> jest nieprawidłowy lub nie został zarejestrowany.',
                        buttons: Ext4.MessageBox.OK,
                        fn: function (btn, text)
                        {
                            if (btn == 'ok') vs.markError('identyfikator_ese', 'Nieprawidłowy identyfikator!');
                        },
                        icon: Ext4.Msg.ERROR
                    });
                }

            }
            catch(e){
                Ext4.getBody().unmask();
                Ext4.Msg.alert('Błąd!','Wystapił problem podczas dekodowania odebranych danych: ' + e);
            }
        },failure: function(){
            Ext4.getBody().unmask();
            Ext4.Msg.alert('Uwaga','Nie powiodło się wywołanie ' + requestUri);
        }
    });
}