SuncodeFormService.addOnReadyEvent(setExchangeRateOnReady);

function setExchangeRateOnReady(){
    var vs = ServiceFactory.getVariableService()
    var currentRate = vs.getValue('kurs_waluty');
    if(isFieldEmpty(currentRate) || parseFloat(currentRate) == 0 ) setExchangeRate();
    variableService.addEvent('waluta', 'change', setExchangeRate);
    variableService.addEvent('data_sprzedazy', 'blur', setExchangeRate);
    variableService.addEvent('data_wystawienia', 'blur', setExchangeRate);
}


function setExchangeRate(){
    var rate;
    var servletName = "api/custom/servlet/getExchangeRate";
    var jSonParam = new Object();

    var currency = getFormElement('waluta').value;
    var isInternalDoc = getFormElement('faktura_wewnetrzna').value;
    jSonParam['currency'] = currency;

    if(isInternalDoc){
        jSonParam['date'] = getFormElement('data_sprzedazy').value;
    }else{
        jSonParam['date'] = getFormElement('data_wystawienia').value;
    }

    if(currency == 'PLN'){
        rate = 1;
    }else{
        var response = sendDataWithCurrency(servletName, JSON.stringify(jSonParam));

        if (response.responseText == null || response.responseText == '' ){
            rate = 0;
        }else{
            rate = response.responseText;
            rate = rate.replace(/"/g,'');
            rate = parseFloat(rate);
        }
    }
    setFormElement('kurs_waluty', rate);
}


function sendDataWithCurrency(servletName, param) {
    return jQuery.ajax({
        type : "POST",
        url : servletName,
        data : ({
            jSon : param
        }),
        async : false
    });
}