function confirmationOfBankTransferDocument(){

    var docClassId_Zalaczniki = 13;

    var ms = ServiceFactory.getMessageService();

    var docVerifyConfig = {verifyMode:'activity', showMessage:false, conditions:[{documentClassId:docClassId_Zalaczniki, documentCount:1, conditionType:'<='}]};

    var docConfig = {showIndexes:false, checkRights:false, documentClassIdList:[docClassId_Zalaczniki], refreshAfterAdd:true, callback:function(file)
        {
            var formService = ServiceFactory.getFormService();
            formService.save();
        }
    }

    if(!CUF.DocumentService.verifyDocuments(docVerifyConfig)){
        ms.showFailure('Podłącz dokument będący potwierdzeniem przelewu.', {hideAfter: 5000});
        CUF.DocumentService.showAddDocumentsFromDiscForm(docConfig);
    }else return true;

    return false;

}


function attachedDocumentsVeryfier() {

    var docClassId_Faktury = 12;
    var docClassId_Zalaczniki = 13;
    var docClassId_Kosztowe_CMR= 44;

    var servletName = "api/custom/servlet/DocumentsCounter";
    var activityInfoService = ServiceFactory.getActivityInfoService();
    var processId = activityInfoService.getProcessId();

    var jSonParam = new Object();
    jSonParam['processId'] = processId;
    jSonParam['classId'] = docClassId_Faktury.toString();

    var response = docCounter(servletName, JSON.stringify(jSonParam));

    if (response.responseText == null || response.responseText == '')
        return;

    var isAddingBlocked = JSON.parse(response.responseText);

    if (isAddingBlocked.indexOf('true') > -1) {
        var ms = ServiceFactory.getMessageService();
        ms.showFailure('Skan faktury jest już podłączony do procesu');

        var docConfig = {
            showIndexes:false,
            checkRights:false,
            documentClassIdList:[docClassId_Zalaczniki],
            refreshAfterAdd:true,
            callback:function(file) {
                var formService = ServiceFactory.getFormService();
                formService.save();
            }
        }
        CUF.DocumentService.showAddDocumentsFromDiscForm(docConfig);
    }else{
        var docConfig = {
            showIndexes:false,
            checkRights:false,
            documentClassIdList:[docClassId_Faktury,docClassId_Zalaczniki,docClassId_Kosztowe_CMR],
            refreshAfterAdd:true,
            callback:function(file) {
                var formService = ServiceFactory.getFormService();
                formService.save();
            }
        }
        CUF.DocumentService.showAddDocumentsFromDiscForm(docConfig);
    }

}

function docCounter(servletName, param) {
    return jQuery.ajax({
        type : "POST",
        url : servletName,
        data : ({
            jSon : param
        }),
        async : false
    });
}
