SuncodeFormService.addOnReadyEvent(decreeManagerExtOnReady);

function decreeManagerExtOnReady(){
    var activityInfoService = ServiceFactory.getActivityInfoService();
    var processDefId = activityInfoService.getProcessDefId();
    if( processDefId == 'dokumenty_k' ){
        setDecreeColumns();
        variableService.addEvent('kategoria_dokumentu','blur',setDecreeColumns);
    }
}

var allDecreeColumnsIds = ['typ_pozycji','nr_zlecenia','opis_pozycji',
    'mpk','procent','wartosc_podstawowa_zlec',
    'oplaty_dodatkowe','kwota_netto_pozycji','stawka_vat',
    'nr_pojazdu','nr_teczki','rodzaj_paliwa',
    'ilosc_paliwa','nr_zamowienia_iso','harmonogram_od',
    'harmonogram_liczba_rat','stawka_vat_dla_faktury'];

function setDecreeColumns(){
    SuncodeFormService.suspendLayouts();
    try{
        var columnsToHide = getColumnsToHide();
        var variableSetService = ServiceFactory.getVariableSetService();
        var decreeGrid = variableSetService.get('tabela_dekretacji');
        showAllDecreeColumns(decreeGrid);
        cleanTableColumnToHide(decreeGrid, columnsToHide);
        hideDecreeColumns(decreeGrid, columnsToHide);
    }
    finally {
        SuncodeFormService.resumeLayouts();
    }
}

function getColumnsToHide(){
    var requestObj = new Object();
    requestObj['documentCategory'] = variableService.getValue('kategoria_dokumentu');
    requestObj['labelId'] = variableService.getValue('identyfikator_z_etykiet');
    var columnToHide = executeClientServl('GET', 'api/custom/servlet/getColumnList', requestObj);
    return columnToHide;
}

function isLabelIdStartingFromEKT(){
    var result = false;
    var labelId = variableService.getValue('identyfikator_z_etykiet');
    if( labelId.indexOf('EKT') == 0 )
        return true;
    return result;
}

function cleanTableColumnToHide(decreeGrid, columnsToHide){
    var decreeStore = decreeGrid.getStore();
    for( var i = 0 ; i < decreeStore.getCount() ; i++ ){
        var record = decreeStore.getAt(i);
        for( var j = 0 ; j < columnsToHide.length ; j++ ){
            var columnToHide = columnsToHide[j];
            record.set(columnToHide,'');
        }
    }
}

function showAllDecreeColumns(decreeGrid){
    var variableSetService = ServiceFactory.getVariableSetService();
    for( var i = 0 ; i < allDecreeColumnsIds.length ; i++ ){
        variableSetService.showColumn(decreeGrid, allDecreeColumnsIds[i]);
    }
}

function hideDecreeColumns(decreeGrid, columnsToHide){
    var variableSetService = ServiceFactory.getVariableSetService();
    for( var i = 0 ; i < columnsToHide.length ; i++ ){
        variableSetService.hideColumn(decreeGrid, columnsToHide[i]);
    }
}

function executeClientServl(requestMethod, requestUri, requestObj){
    if( requestObj == null ){
        requestObj = new Object();
    }
    var responseObj = "";
    Ext4.Ajax.request({
        url: requestUri,
        params: requestObj,
        async: false,
        method: requestMethod,
        success: function(response){
            try{
                var respText = response.responseText;
                responseObj = Ext.util.JSON.decode(respText);
                try{
                    responseObj = Ext.util.JSON.decode(responseObj);
                }
                catch(e){}
            }
            catch(e){
                console.log(e);
            }
        },failure: function(){
            Ext4.Msg.alert('Uwaga','Nie powiodło się wywołanie ' + requestUri);
        }
    });
    return responseObj;
}