SuncodeFormService.addOnReadyEvent(costDocumentsDateChecker);

function costDocumentsDateChecker() {
    var as = ServiceFactory.getActivityInfoService();
    var vs = ServiceFactory.getVariableService();
    if (as.getProcessDefId('dokumenty_k') && as.getActivityDefId() == "rejestracja_dokumentu_k")
    {
        vs.addEvent('data_wystawienia', 'blur', checkDateServlet);
        vs.addEvent('data_wplywu', 'blur', checkDateServlet);
    }
    else if (as.getProcessDefId('dokumenty_k') && as.getActivityDefId() == "konsultacja")
    {
        checkDateServlet();
    }

}

function checkDateServlet() {
    var vs = ServiceFactory.getVariableService();
    var messageService = ServiceFactory.getMessageService();
    var jSonParam = new Object();
    var sDateOfReceipt = vs.getValue('data_wplywu');
    var sIssuanceDate = vs.getValue('data_wystawienia');

    jSonParam['dataWplywu'] = sDateOfReceipt;
    jSonParam['dataWystawienia'] = sIssuanceDate;

    var servletName = "api/custom/servlet/CheckDate";

    var response = sendDataWithDates(servletName, JSON.stringify(jSonParam));

    if (response.responseText == null || response.responseText == '')
        return;

    var responsObj = JSON.parse(response.responseText);
    if (responsObj == 'DATE_INVALID') {
        messageService.showFailure("Sprawdź daty - różnica między datą wpływu a datą wystawienia jest większa niż 3 miesiące");
        disableButtons();
        showAllowsProcessingVariable();
        return false;
    } else if (responsObj == 'DATE_VALID') {
        enableButtons();
        hideAllowsProcessingVariable();
        return true;
    }
    return false;
}
function sendDataWithDates(servletName, param) {
    return jQuery.ajax({
        type : "POST",
        url : servletName,
        data : ({
            jSon : param
        }),
        async : false
    });
}

function enableButtons(){
    var vs = ServiceFactory.getVariableService();
    vs.setValue('blokada_przyciskow', 'NIE');
}

function disableButtons(){
    var vs = ServiceFactory.getVariableService();
    vs.setValue('blokada_przyciskow', 'TAK');
}

function showAllowsProcessingVariable()
{
    var vs = ServiceFactory.getVariableService();
    vs.show('dopuszczony_do_obiegu');
}

function hideAllowsProcessingVariable()
{
    var vs = ServiceFactory.getVariableService();
    vs.hide('dopuszczony_do_obiegu');
}