// GetElementWithNextTabIndex
//
// Description: returns the element with the next highest tab index or
//    the first tabindex if passed the highest element (it wraps)
//
// Arguments :
//    elCurrent               : element with current tab index
//
// Dependencies : none
//
function GetElementWithNextTabIndex ( elCurrent )
{

    var numIndex = 0;
    var numTabIndex = 0;

    // get index of this control
    var arrElements = elCurrent.form.elements;
    for ( var i = 0; i < arrElements.length; i++ )
    {

        if ( arrElements[i] == elCurrent )
        {
            numIndex = i;
            break;
        }

    }

    numTabIndex = elCurrent.tabIndex;

    // if control has tabindex
    if ( numTabIndex != 0 )
    {

        // find next highest tabindex
        var numNextTabIndex = 99999999;
        var numNextIndex = -1;
        var numFirstTabIndex = numTabIndex;
        var numFirstIndex = numIndex;
        for ( var k = 0; k < arrElements.length; k++ )
        {

            // if not the target element and it isn't disabled and it isn't hidden
            if ( k != numIndex && arrElements[k].disabled == false && arrElements[k].type != 'hidden' )
            {

                // if it has a greater tab index than the target element and is less than the previous candidate tab index
                if ( arrElements[k].tabIndex >= numTabIndex && arrElements[k].tabIndex < numNextTabIndex )
                {

                    // update candidate tab index value & save element index
                    numNextTabIndex = arrElements[k].tabIndex;
                    numNextIndex = k;

                }
                // if it has a lower tab index than the target element and is less than the previous minimum tab index
                else if ( arrElements[k].tabIndex < numTabIndex && arrElements[k].tabIndex < numFirstTabIndex )
                {

                    // update first tab index value & save element index
                    numFirstTabIndex = arrElements[k].tabIndex;
                    numFirstIndex = k;

                }

            }

        }

        // if we found one higher
        if ( numNextIndex > -1 )
        {

            return arrElements[numNextIndex];

        }
        // if we didn't find one higher but found a different first one
        else if ( numFirstIndex != numIndex )
        {

            return arrElements[numFirstIndex];

        }

    }
    // if no tab index
    else
    {

        // find next highest by natural order
        for ( var j = numIndex + 1; j < arrElements.length; j++ )
        {

            // if we found one
            if ( arrElements[j].tabIndex == 0 && arrElements[j].disabled == false && arrElements[j].type != 'hidden' )
            {

                return arrElements[j];

            }

        }

        // we didn't find next by natural order so find first
        for ( var f = 0; f < numIndex; f++ )
        {

            // if we found one
            if ( arrElements[f].tabIndex == 0 && arrElements[f].disabled == false && arrElements[f].type != 'hidden' )
            {

                return arrElements[f];

            }

        }


    }

}
//
// GetElementWithNextTabIndex
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
// FocusElementWithNextTabIndex
//
// Description: focuses the element with the next highest tab index or
//    the first tabindex if passed the highest element (it wraps)
//    does this in a try catch with the catch recursively calling
//    so we keep trying focus till there is something we can focus
//
// Arguments :
//    elCurrent               : element with current tab index
//
// Dependencies :
//    GetElementWithNextTabIndex
//
function FocusElementWithNextTabIndex ( elCurrent )
{

    var elNext = GetElementWithNextTabIndex(elCurrent);

    try
    {

        // focus next element
        elNext.focus();

    }
    catch ( objException )
    {

        // recursive call
        FocusElementWithNextTabIndex(elNext);

    }

}
//
// FocusElementWithNextTabIndex
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
// frmRequest_KeyPress
//
// Description: event handler for request form key press event
//    cancels returns on form elements that would prematurely submit the form
//
// Arguments :
//    e - the event object
//
// Dependencies : none
//
function frmRequest_KeyPress( e )
{

    var numCharCode;
    var elTarget = null;
    var strType = '';
    var arrElements = null;
    var numIndex = 0;
    var numTabIndex = 0;
    var elName = '';
    var elCurrent = null;

    // get event if not passed
    if (!e) var e = window.event;

    // get character code of key pressed
    if (e.keyCode) numCharCode = e.keyCode;
    else if (e.which) numCharCode = e.which;

    // if the enter key (optimization as we only process enter key)
    //alert(numCharCode);
    if ( numCharCode == 13 )
    {

        // get target
        if (e.target) elTarget = e.target;
        else if (e.srcElement) elTarget = e.srcElement;

        elName = elTarget.nodeName.toUpperCase();
        if ( elName == 'INPUT' )
            if ( elTarget.getAttribute('type') )
                elName = elTarget.getAttribute('type').toUpperCase();


        // jeśli jest to pole tekstowe to sprawdzamy czy jest to liczba


        if (elName=='TEXT')
        {
            objType = document.getElementById('subType_'+elTarget.id);
            if ((objType)&&(objType.value=='AMOUNT'))
            {
                obvalue = elTarget.value;
                idxValue = obvalue.fulltrim();
                idxValue = idxValue.replace(",",".");
                idxValue = formatAmountString(idxValue);
                elTarget.value = idxValue;
            }
        }

        // based on type
        switch ( elName )
        {
            case 'CHECKBOX' :
            case 'RADIO' :
            case 'TEXT' :
            case 'SELECT' :

                // focus element with next tab index
                FocusElementWithNextTabIndex(elTarget);

                // if we got this far we couldn't find the next item to tab to - but cancel anyway
                // cancel event to prevent form submission
                return false;

                break;

        }
        switch ( elName )
        {
            case 'TEXTAREA' :
                return true;

                break;

        }

        return false;
    }
    // F2 - wstawiamy aktualną datę
    if ( numCharCode == 113 )
    {
        if (e.target) elTarget = e.target;
        else if (e.srcElement) elTarget = e.srcElement;

        d=new Date();
        var curr_date = d.getDate() + '';
        if (curr_date.length==1)
            curr_date = '0'+curr_date;
        var curr_month = d.getMonth()+1 + '';
        if (curr_month.length==1)
            curr_month = '0'+curr_month;
        var curr_year = d.getFullYear();
        elTarget.value = curr_year+'-'+curr_month+'-'+curr_date;
    }
    // F3 - czyścimy pole
    if ( numCharCode == 114 )
    {
        if (e.target) elTarget = e.target;
        else if (e.srcElement) elTarget = e.srcElement;

        elTarget.value = '';
    }

    // zamiana , na .
    if ( numCharCode == 110 )
    {
        if (e.target) elTarget = e.target;
        else if (e.srcElement) elTarget = e.srcElement;
        elTarget.value = elTarget.value + '.';
        return false;
    }
    // zamiana . na ,

    // process default action
    return true;
}