/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.lgldocuments.scripts;

import com.plusmpm.enhydra.shark.transaction.WfActivityTransaction;
import com.plusmpm.util.documents.DocumentEvent;
import com.plusmpm.util.documents.handlers.DocumentEventHandler;
import com.suncode.plugin.jasfbgclient.accountsreceivable.tools.ClientTools;
import com.suncode.plugin.jasfbgclient.documents.util.extensions.DocTools;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.util.ServiceFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class ArchiveAdditionalLGLDocument
implements DocumentEventHandler {
    private static final Logger log = Logger.getLogger(ArchiveAdditionalLGLDocument.class);
    private static final String ATTACHMENTS_CLASS_NAME = "Dokumenty dodatkowe LGL";
    private final DocumentService documentService = ServiceFactory.getDocumentService();

    public ArchiveAdditionalLGLDocument(String id) {
    }

    public void handleEvent(WfActivityTransaction st, DocumentEvent documentEvent) throws Exception {
        long fileId = documentEvent.getDocument().getLFileId();
        boolean sendNotification = true;
        String reason = "ARCHIWIZACJA_BRAK_DANYCH";
        log.debug((Object)("fileId: " + fileId));
        DocumentClassService docClassService = ServiceFactory.getDocumentClassService();
        WfDocument document = this.documentService.getDocument(Long.valueOf(fileId));
        DocumentClass documentClass = docClassService.getDocumentClass(ATTACHMENTS_CLASS_NAME, new String[0]);
        long idIndex = ClientTools.findIndexIdByCriteria("ID Transportu", documentClass);
        long companyIndex = ClientTools.findIndexIdByCriteria("Firma", documentClass);
        long contractorIndex = ClientTools.findIndexIdByCriteria("Kod kontrahenta", documentClass);
        long id = (Long)document.getIndexValue(Long.valueOf(idIndex));
        String company = (String)document.getIndexValue(Long.valueOf(companyIndex));
        int companyId = ClientTools.getCompanyId(company);
        long contractor = (Long)document.getIndexValue(Long.valueOf(contractorIndex));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String currentDate = sdf.format(new Date());
        if (companyId >= 0) {
            log.debug((Object)"Sprawdzam, czy istnieje dokument g\u0142\u00f3wny");
            HashMap<String, Object> indexes = new HashMap<String, Object>();
            indexes.put("ID Transportu", id);
            indexes.put("Firma", company);
            if (ClientTools.isDocumentInArchive(indexes, "Dokumenty g\u0142\u00f3wne LGL")) {
                log.debug((Object)"Dokument g\u0142\u00f3wny istnieje. Pobieram dane dokumentu dodatkowego");
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("id", String.valueOf(id));
                parameters.put("CompanyId", String.valueOf(companyId));
                parameters.put("code", String.valueOf(contractor));
                parameters.put("Class", String.valueOf(documentClass.getId()));
                try {
                    JSONObject documentJson = ClientTools.getResponseFromWS(SystemProperties.getString((String)"LGL_DOK_DODATKOWY_WS_URL"), parameters);
                    if (documentJson != null) {
                        log.debug((Object)"Dane dokumentu zosta\u0142y pobrane");
                        Map<String, Object> wsData = ArchiveAdditionalLGLDocument.translateDocument(documentJson);
                        Set<Map.Entry<String, Object>> entrySet = wsData.entrySet();
                        for (Map.Entry<String, Object> oneResult : entrySet) {
                            document.setIndexValue(oneResult.getKey(), oneResult.getValue());
                        }
                        document.setIndexValue("Data archiwizacji", (Object)currentDate);
                        this.documentService.updateDocument(document);
                        sendNotification = false;
                    }
                }
                catch (Exception e) {
                    log.debug((Object)("B\u0142\u0105d pobierania danych:" + e.getMessage()), (Throwable)e);
                }
            } else {
                log.debug((Object)"Brak dokumentu g\u0142\u00f3wnego");
                reason = "ARCHIWIZACJA_BRAK_DOK_GLOWNEGO";
            }
        } else {
            log.debug((Object)"Brak Id Transportu lub Firmy");
        }
        if (sendNotification) {
            log.debug((Object)("Nie pobrano danych dokumentu o id: " + id + " i Firmie: " + company + ". Dokument zostanie usuni\u0119ty z Archiwum."));
            long orgUnitIndex = ClientTools.findIndexIdByCriteria("Punkt skanowania", documentClass);
            String orgUnit = (String)document.getIndexValue(Long.valueOf(orgUnitIndex));
            HashMap<String, String> newIndexes = new HashMap<String, String>();
            newIndexes.put("id_transportu", String.valueOf(id));
            newIndexes.put("firma", company);
            newIndexes.put("klasa", ATTACHMENTS_CLASS_NAME);
            newIndexes.put("data_archiwizacji", currentDate);
            DocTools.wyslijPowiadomienie("LGL", fileId, orgUnit, reason, newIndexes, ATTACHMENTS_CLASS_NAME);
            this.documentService.deleteDocument(document);
        }
    }

    private static Map<String, Object> translateDocument(JSONObject document) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Numer transportu", document.getString("TransportNumber"));
        map.put("Data za\u0142adunku", ClientTools.changeDateToString(ClientTools.changeStringToDate(document.getString("LoadingDate"), "yyyy-MM-dd'T'HH:mm:ss"), "yyyy-MM-dd"));
        map.put("Data roz\u0142adunku", ClientTools.changeDateToString(ClientTools.changeStringToDate(document.getString("UnloadingDate"), "yyyy-MM-dd'T'HH:mm:ss"), "yyyy-MM-dd"));
        map.put("Plac\u00f3wka", document.getString("Branch"));
        map.put("Numer faktury", document.getString("InvoiceNumber"));
        map.put("Nazwa kontrahenta", document.getString("CustomerName"));
        map.put("NIP", document.getString("CustomerTaxId"));
        return map;
    }
}

