/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.documents.util.extensions;

import com.plusmpm.util.virtualtables.Record;
import com.plusmpm.util.virtualtables.VColumn;
import com.plusmpm.util.virtualtables.VRecord;
import com.suncode.plugin.jasfbgclient.documents.util.extensions.EmailTemplate;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class P0063Tools {
    private static Logger log = Logger.getLogger(P0063Tools.class);
    private static SQLFinder finder = FinderFactory.getSQLFinder();

    public static String getCodeSuffixForDocumentType(String activity_type, String document_type) {
        String answer = "";
        if (VColumn.exists((String)"tab_typy_dokumentow", (String)"kol_typ_czynnosci") && VColumn.exists((String)"tab_typy_dokumentow", (String)"kol_typ_dokumentu") && VColumn.exists((String)"tab_typy_dokumentow", (String)"kol_sufix")) {
            ArrayList alRec = VRecord.getRecordsWhere((String)"tab_typy_dokumentow", (String)"kol_typ_czynnosci", (String)activity_type);
            for (int i = 0; i < alRec.size(); ++i) {
                try {
                    Record rec = (Record)alRec.get(i);
                    String value = (String)rec.getValue("kol_typ_dokumentu");
                    log.trace((Object)("Dla danych " + activity_type + " pobrano wartosc " + value));
                    if (value == null || value.compareTo(document_type) != 0) continue;
                    log.trace((Object)("Warto\u015b\u0107 '" + value + "' zgodna z por\u00f3wnywan\u0105: " + document_type));
                    String code_value = (String)rec.getValue("kol_sufix");
                    if (code_value == null) continue;
                    answer = code_value;
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"B\u0142\u0105d podczas odczytywania warto\u015bci konfiguracyjnych.");
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return answer;
    }

    public static String getDocumentTypeForCodeSuffix(String activity_type, String document_type_code) {
        String answer = "";
        if (VColumn.exists((String)"tab_typy_dokumentow", (String)"kol_typ_czynnosci") && VColumn.exists((String)"tab_typy_dokumentow", (String)"kol_typ_dokumentu") && VColumn.exists((String)"tab_typy_dokumentow", (String)"kol_sufix")) {
            ArrayList alRec = VRecord.getRecordsWhere((String)"tab_typy_dokumentow", (String)"kol_typ_czynnosci", (String)activity_type);
            for (int i = 0; i < alRec.size(); ++i) {
                try {
                    Record rec = (Record)alRec.get(i);
                    String value = (String)rec.getValue("kol_sufix");
                    if (value == null) {
                        value = "";
                    }
                    log.trace((Object)("Dla danych " + activity_type + " pobrano wartosc " + value));
                    if (value.compareTo(document_type_code) != 0) continue;
                    log.trace((Object)("Warto\u015b\u0107 '" + value + "' zgodna z por\u00f3wnywan\u0105: " + document_type_code));
                    String code_value = (String)rec.getValue("kol_typ_dokumentu");
                    if (code_value == null) continue;
                    answer = code_value;
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"B\u0142\u0105d podczas odczytywania warto\u015bci konfiguracyjnych.");
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return answer;
    }

    public static boolean checkIfDocumentExistInArchive(String typ_czynnosci, String numer_ewidencyjny) {
        boolean answer = false;
        String className = "";
        long indexId = 0L;
        DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
        DocumentFinder documentFinder = FinderFactory.getDocumentFinder();
        if (typ_czynnosci.compareTo("Dokumenty WYW\u00d3Z") == 0) {
            className = "Dokumenty celne eksportowe";
            indexId = 4L;
        } else if (typ_czynnosci.compareTo("Dokumenty TRANZYT") == 0) {
            className = "Dokumenty celne tranzytowe";
            indexId = 20L;
        } else if (typ_czynnosci.compareTo("Dokumenty PRZYW\u00d3Z") == 0) {
            className = "Dokumenty celne importowe";
            indexId = 12L;
        } else if (typ_czynnosci.compareTo("Dokumenty INNE") == 0) {
            className = "Dokumenty celne inne";
            indexId = 31L;
        }
        DocumentClass documentClass = documentClassService.getDocumentClass(className, new String[0]);
        long documentClassId = documentClass.getId();
        HashMap<Long, String> idx = new HashMap<Long, String>();
        idx.put(indexId, numer_ewidencyjny);
        ArrayList sorters = new ArrayList();
        CountedResult result = documentFinder.findByIndexes(Long.valueOf(documentClassId), idx, sorters, Integer.valueOf(0), Integer.valueOf(0), new String[0]);
        long total = result.getTotal();
        if (total > 0L) {
            answer = true;
        }
        return answer;
    }

    public static String getEmailAdresForDepartment(String department) {
        String answer = "";
        if (VColumn.exists((String)"tab_placowki", (String)"kol_placowka") && VColumn.exists((String)"tab_placowki", (String)"kol_adres_email")) {
            ArrayList alRec = VRecord.getRecordsWhere((String)"tab_placowki", (String)"kol_placowka", (String)department);
            for (int i = 0; i < alRec.size(); ++i) {
                try {
                    Record rec = (Record)alRec.get(i);
                    String value = (String)rec.getValue("kol_adres_email");
                    if (value == null) continue;
                    answer = value;
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"B\u0142\u0105d podczas odczytywania warto\u015bci konfiguracyjnych.");
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return answer;
    }

    public static EmailTemplate getEmailTemplate(String typ_grupy_dokumentow, String reason) {
        EmailTemplate emailTemplate = null;
        if (VColumn.exists((String)"tab_szablony_powiadomien", (String)"kol_przyczyna") && VColumn.exists((String)"tab_szablony_powiadomien", (String)"kol_temat") && VColumn.exists((String)"tab_szablony_powiadomien", (String)"kol_szablon") && VColumn.exists((String)"tab_szablony_powiadomien", (String)"kol_typ") && VColumn.exists((String)"tab_szablony_powiadomien", (String)"kol_wysylac")) {
            HashMap<String, String> conditions = new HashMap<String, String>();
            conditions.put("kol_typ", typ_grupy_dokumentow);
            conditions.put("kol_przyczyna", reason);
            List alRec = VRecord.getRecordsWhere((String)"tab_szablony_powiadomien", conditions);
            if (alRec != null && alRec.size() > 0) {
                String czy_wlaczyc = (String)((Record)alRec.get(0)).getValue("kol_wysylac");
                if (czy_wlaczyc != null && czy_wlaczyc.equalsIgnoreCase("Tak")) {
                    String subject = (String)((Record)alRec.get(0)).getValue("kol_temat");
                    String template_path = (String)((Record)alRec.get(0)).getValue("kol_szablon");
                    emailTemplate = new EmailTemplate();
                    emailTemplate.setEmailSubject(subject);
                    String template = P0063Tools.readTemplateFromDisk(template_path);
                    emailTemplate.setEmailTemplate(template);
                    emailTemplate.setEmailTemplatePath(template_path);
                } else {
                    log.debug((Object)("Powiadomienie wylaczone dla: " + reason + ", typu: " + typ_grupy_dokumentow));
                }
            } else {
                log.info((Object)("Brak tytu\u0142u lub tre\u015bci maila dla przyczyny '" + reason + "', mail nie zostanie wys\u0142any."));
            }
        } else {
            log.error((Object)"Nie poprawna struktura tabeli zewnetrznej.");
        }
        return emailTemplate;
    }

    private static String readTemplateFromDisk(String sTemplatePath) {
        log.debug((Object)"************ readTemplate **************");
        Object sTemplate = "";
        try {
            FileInputStream fis = new FileInputStream(sTemplatePath);
            BufferedInputStream bis = new BufferedInputStream(fis);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)bis, "UTF8"));
            String sLine = null;
            while ((sLine = br.readLine()) != null) {
                sLine = sLine.trim();
                sTemplate = (String)sTemplate + sLine + "\n";
            }
            fis.close();
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Nie znaleziono pliku o podanej \u015bcie\u017cce " + sTemplatePath));
            log.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
        catch (IOException e) {
            log.error((Object)("Nie mozna bylo odczytac pliku z podanej \u015bcie\u017cki " + sTemplatePath));
            log.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
        log.debug((Object)"************ readTemplate finished **************");
        return sTemplate;
    }

    public static void addCommentAsAdmin(String sComment, String sActivityId, String sProcessId) {
        if (sComment != null && !sComment.trim().isEmpty()) {
            CommentService commentService = ServiceFactory.getCommentService();
            Date date = new Date();
            Comment comment = new Comment();
            comment.setActivityId(sActivityId);
            comment.setComment(sComment);
            comment.setProcessId(sProcessId);
            comment.setTimestamp(Long.valueOf(date.getTime()));
            comment.setUserId("admin");
            commentService.createComment(comment);
        }
    }
}

