/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.costdocuments.validators;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.suncode.plugin.jasfbgclient.costdocuments.validators.ClientCompareObject;
import com.suncode.pwfl.form.util.object.ValidationErrors;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClientTableValidator {
    public static Logger log = Logger.getLogger(ClientTableValidator.class);
    private Map<String, String> mProcessMap;
    private List<Map<String, String>> processValues;
    private boolean bMayBeEmpty;
    private String sTableId;
    private List<String> aColumnIds;
    private String sErrorMsg;
    private ClientCompareObject compareObject;

    public ClientTableValidator(Map<String, String> mProcessMap, boolean bMayBeEmpty, String sTableId, List<String> aColumnIds, String sErrorMsg) {
        this.processValues = ClientTableValidator.convertFromMapStringToListOfMaps(mProcessMap, aColumnIds);
        this.mProcessMap = mProcessMap;
        this.bMayBeEmpty = bMayBeEmpty;
        this.sTableId = sTableId;
        this.aColumnIds = aColumnIds;
        this.sErrorMsg = sErrorMsg;
        this.compareObject = null;
    }

    public void setClientCompareObject(ClientCompareObject clientCompareObject) {
        this.compareObject = clientCompareObject;
        String sCompareObjectId = this.compareObject.getCompareFieldId();
        if (!this.aColumnIds.contains(sCompareObjectId)) {
            this.aColumnIds.add(sCompareObjectId);
            this.processValues = ClientTableValidator.convertFromMapStringToListOfMaps(this.mProcessMap, this.aColumnIds);
        }
    }

    public void validate(ValidationErrors validationErrors) {
        if (!this.bMayBeEmpty) {
            this.checkIsEmpty(validationErrors);
        }
        this.checkFieldsAreSupplement(validationErrors);
    }

    private void checkFieldsAreSupplement(ValidationErrors validationErrors) {
        int rowNum = 0;
        for (Map<String, String> record : this.processValues) {
            boolean validateRecord = this.checkValidateRecord(record);
            if (validateRecord) {
                this.validateFields(validationErrors, record, rowNum);
            }
            ++rowNum;
        }
    }

    private boolean checkValidateRecord(Map<String, String> record) {
        boolean result = false;
        if (this.compareObject != null) {
            String sValueToCompare = record.get(this.compareObject.getCompareFieldId());
            boolean compareResult = this.compareObject.compareWith(sValueToCompare);
            if (compareResult) {
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    private void validateFields(ValidationErrors validationErrors, Map<String, String> record, int rowNum) {
        for (String columnId : this.aColumnIds) {
            String sRecordValue = record.get(columnId);
            if (!sRecordValue.trim().isEmpty()) continue;
            validationErrors.addVariableSetFieldError(this.sTableId, rowNum, columnId, this.sErrorMsg);
        }
    }

    private void checkIsEmpty(ValidationErrors validationErrors) {
        boolean isEmpty = true;
        for (String columnId : this.aColumnIds) {
            String sValue = this.mProcessMap.get(columnId);
            if (sValue.isEmpty()) continue;
            isEmpty = false;
            break;
        }
        if (isEmpty && !validationErrors.hasErrors()) {
            validationErrors.addGlobalError("Tabela musi zawiera\u0107 przynajmniej jeden wiersz");
        }
    }

    public static List<Map<String, String>> convertFromMapStringToListOfMaps(Map<String, String> contextMap, List<String> columnIds) {
        String[] aColumnIds = new String[columnIds.size()];
        for (int i = 0; i < columnIds.size(); ++i) {
            aColumnIds[i] = columnIds.get(i);
        }
        return ClientTableValidator.convertFromMapStringToListOfMaps(contextMap, aColumnIds);
    }

    public static List<Map<String, String>> convertFromMapStringToListOfMaps(Map<String, String> contextMap, String ... args) {
        Map<String, Object> objectMap = ClientTableValidator.parseToMapObjectValues(contextMap);
        List result = DynamicTableFunctions.convertFromMapToListOfMaps(objectMap, (String[])args);
        return result;
    }

    public static Map<String, Object> parseToMapObjectValues(Map<String, String> toParse) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String id : toParse.keySet()) {
            result.put(id, toParse.get(id));
        }
        return result;
    }
}

