/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.costdocuments.validators;

import com.suncode.plugin.jasfbgclient.category.Categories;
import com.suncode.plugin.jasfbgclient.costdocuments.booking.BookInOracle;
import com.suncode.plugin.jasfbgclient.costdocuments.setters.OracleResponse;
import com.suncode.plugin.jasfbgclient.costdocuments.setters.OracleResponseService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

@Validator
public class BookingValidator {
    public static Logger log = Logger.getLogger(BookingValidator.class);

    @Define
    public void definition(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("jas-fbg-client.booking-validator")).name("Walidacja ksi\u0119gowania JAS-FBG Client")).description("Walidacja ksi\u0119gowania JAS-FBG Client")).icon((Icon)SilkIconPack.APPLICATION_FORM)).category(new Category[]{Categories.JASFBG})).create();
    }

    public void validate(ActivityContextMap activityContextMap, ValidationErrors validationErrors) {
        if (validationErrors.areEmpty()) {
            try {
                Map<String, Object> variables = activityContextMap.getVariables().entrySet().stream().filter(entry -> entry.getValue() != null && ((Variable)entry.getValue()).getValueAsBasicType() != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Variable)entry.getValue()).getValueAsBasicType()));
                BookInOracle bookInOracle = new BookInOracle();
                bookInOracle.bookByProcessContextMap(variables);
                String invoiceOracleNo = bookInOracle.getInvoiceOracleNo();
                String reserveOracleNo = bookInOracle.getReserveOracleNo();
                String formInvoiceOraclId = bookInOracle.getFormInvoiceOraclId();
                String formReserveOraclId = bookInOracle.getFormReserveOraclId();
                String processId = activityContextMap.getProcessId();
                OracleResponse oracleResponse = new OracleResponse(processId, invoiceOracleNo, reserveOracleNo, formInvoiceOraclId, formReserveOraclId);
                OracleResponseService.addOracleResponse(oracleResponse);
            }
            catch (Exception ex) {
                log.debug((Object)ex.getMessage(), (Throwable)ex);
                validationErrors.add("Nie powiod\u0142o si\u0119 ksi\u0119gowanie: " + ex.getMessage());
            }
        }
    }
}

