/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.costdocuments.servlets;

import com.plusmpm.CUF.util.DataChoosers.ExecuteQueryDataChooser;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.suncode.plugin.jasfbgclient.costdocuments.services.CategoryService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/custom/servlet"})
public class DefaultTypeSectionGetter {
    private static Logger log = Logger.getLogger(DefaultTypeSectionGetter.class);
    private static final String DEFAULT_TYPE_QUERY = "SELECT rodzaj_dokumentu FROM pm_cust_kategoria_rodzaj_sekcja where kategoria_dokumentu like '%s' and trim(default_type) like '1'";
    private static final String DEFAULT_SECTION_QUERY = "SELECT sekcja_rejestru FROM pm_cust_kategoria_rodzaj_sekcja where kategoria_dokumentu like '%s' and rodzaj_dokumentu like '%s'  and trim(default_type) like '1'";

    @RequestMapping(value={"getDefaultType"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getDefaultType(@RequestParam String documentCategory) {
        String fieldId = "rodzaj_dokumentu";
        String documentCategorySymbol = CategoryService.getCategorySymbolByCategoryName(documentCategory);
        String query = String.format(DEFAULT_TYPE_QUERY, documentCategorySymbol);
        String nameForQuery = "v_rodzaje_dokumentow";
        HashMap<String, String> mCriteria = new HashMap<String, String>();
        mCriteria.put("kategoria_dokumentu", documentCategorySymbol);
        Map<String, String> result = this.getDefault(fieldId, query, nameForQuery, mCriteria);
        return result;
    }

    @RequestMapping(value={"getDefaultSection"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getDefaultSection(@RequestParam String documentCategory, @RequestParam String documentType) {
        String documentCategorySymbol = CategoryService.getCategorySymbolByCategoryName(documentCategory);
        String fieldId = "sekcja_rejestru";
        String query = String.format(DEFAULT_SECTION_QUERY, documentCategorySymbol, documentType);
        String nameForQuery = "v_sekcje_rejestrow";
        HashMap<String, String> mCriteria = new HashMap<String, String>();
        mCriteria.put("kategoria_dokumentu", documentCategorySymbol);
        mCriteria.put("rodzaj_dokumentu", documentType);
        Map<String, String> result = this.getDefault(fieldId, query, nameForQuery, mCriteria);
        return result;
    }

    private Map<String, String> getDefault(String fieldId, String query, String nameForQuery, Map<String, String> mCriteria) {
        String result = "";
        String dcResult = this.getDefaultFromDataChooser(fieldId, nameForQuery, mCriteria);
        result = !dcResult.isEmpty() ? dcResult : this.getDefaultByDefaultSign(fieldId, query);
        HashMap<String, String> mapResult = new HashMap<String, String>();
        mapResult.put("result", result);
        return mapResult;
    }

    private String getDefaultFromDataChooser(String fieldId, String nameForQquery, Map<String, String> mCriteria) {
        String result = "";
        List dcResult = new ArrayList();
        ExecuteQueryDataChooser qdc = new ExecuteQueryDataChooser();
        HashMap<String, String> mCustomKeys = new HashMap<String, String>();
        mCustomKeys.put("NameForQuery", nameForQquery);
        dcResult = qdc.getDataChooserResult(0, 2, "", "", mCriteria, mCustomKeys);
        log.debug((Object)("dcResult: " + String.valueOf(dcResult)));
        int size = qdc.getDataChooserResultSize(mCriteria, mCustomKeys);
        if (size == 1) {
            result = (String)((Map)dcResult.get(0)).get(fieldId);
        }
        return result;
    }

    private String getDefaultByDefaultSign(String fieldId, String query) {
        String result = "";
        log.debug((Object)("query: " + query));
        List<Map<String, Object>> queryResult = this.selectQuery(query);
        log.debug((Object)("queryResult: " + String.valueOf(queryResult)));
        if (queryResult != null && queryResult.size() > 0) {
            result = (String)queryResult.get(0).get(fieldId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> selectQuery(String query) {
        Session session = null;
        List<Map<String, Object>> result = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            result = new ArrayList<Map<String, Object>>();
            NativeQuery qQuery = session.createSQLQuery(query);
            qQuery.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP);
            List<Map<String, Object>> list = result = qQuery.list();
            return list;
        }
        catch (Exception exception) {
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        return result;
    }
}

