/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.costdocuments.servlets;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/custom/servlet"})
public class DateChecker {
    public static Logger log = Logger.getLogger(DateChecker.class);

    @RequestMapping(value={"CheckDate"}, method={RequestMethod.POST})
    @ResponseBody
    public String checkDate(@RequestParam String jSon) {
        log.debug((Object)"Sprawdzanie r\u00f3\u017cnicy dat.");
        String sResponse = "";
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map data = (Map)mapper.readValue(jSon, Map.class);
            DateTime dateOfReceipt = new DateTime(data.get("dataWplywu"));
            DateTime issuanceDate = new DateTime(data.get("dataWystawienia"));
            dateOfReceipt.plusDays(1);
            issuanceDate.plusDays(1);
            Period period = new Period((ReadableInstant)dateOfReceipt, (ReadableInstant)issuanceDate, PeriodType.months().withDaysRemoved());
            int monthDiff = Math.abs(period.getMonths()) + 1;
            log.debug((Object)("R\u00f3\u017cnica miesi\u0119cy: " + monthDiff));
            sResponse = monthDiff > 3 ? "DATE_INVALID" : "DATE_VALID";
            log.debug((Object)("Odpowiedz DateChecker: " + sResponse));
            return sResponse;
        }
        catch (Exception ex) {
            log.error((Object)"B\u0142\u0105d podczas por\u00f3wnywania dat");
            log.error((Object)ex.getMessage());
            return "";
        }
    }
}

