/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.costdocuments.plannedtasks;

import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.plugin.jasfbgclient.costdocuments.model.Currency;
import com.suncode.plugin.jasfbgclient.costdocuments.services.CurrencyService;
import com.suncode.plugin.jasfbgclient.costdocuments.util.DBTools;
import com.suncode.pwfl.util.SpringContext;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCurrencyFromExternalDB
extends AbstractAdvancedTask {
    private static final Logger log = LoggerFactory.getLogger(GetCurrencyFromExternalDB.class);
    private volatile double progress = 0.0;

    @AdvancedTask(name="Pobieranie i zapis danych dotycz\u0105cych walut z systemu EGERIA", description="Pobieranie danych dotycz\u0105cych walut z systemu EGERIA i zapis do wewn\u0119trznej bazy danych w celu p\u00f3\u017aniejszego pobrania dla nich kurs\u00f3w", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void getExchangeRates(@TaskParam(name="Nazwa tabeli", description="Nazwa tabeli, z kt\u00f3rej maj\u0105 zostac pobrane dane. Nazwy tabel zapisane s\u0105 w tabeli pm_querydatachooser") String queryName) {
        log.info("getExchangeRatesFromEGERIA(name={} ", (Object)queryName);
        this.getExchangeRatesFromEGERIA(queryName);
    }

    private void getExchangeRatesFromEGERIA(String queryName) {
        try {
            taskLog.info((Object)"Pr\u00f3ba pobrania walut z zewn\u0119trznej bazy danych");
            List<Map<String, String>> externalDBData = DBTools.GetDataFromDB(queryName, null);
            taskLog.info((Object)"Waluty pobrano pomy\u015blnie");
            if (externalDBData != null && !externalDBData.isEmpty()) {
                int maxValue = externalDBData.size();
                int minValue = 0;
                CurrencyService cs = (CurrencyService)SpringContext.getBean((String)"currencyService");
                taskLog.info((Object)"Rozpocz\u0119cie aktualizacji walut w tabeli pm_cust_currency_names");
                for (Map<String, String> currencyData : externalDBData) {
                    String symbol = currencyData.get("wal_symbol");
                    String fullName = currencyData.get("wal_pelna_nazwa");
                    Currency currency = new Currency();
                    currency.setCurrency(symbol);
                    currency.setFullName(fullName);
                    if (cs.get(currency.getCurrency(), currency.getFullName()) == null) {
                        log.debug("saving: {}", (Object)currency.getCurrency());
                        cs.save(currency);
                        taskLog.info((Object)("Zapisano: " + currency.toString()));
                    } else {
                        log.debug("updating: {}", (Object)currency.getCurrency());
                        cs.update(currency);
                        taskLog.info((Object)("Zaktualizowano: " + currency.toString()));
                    }
                    this.progress = (double)(++minValue) / (double)maxValue;
                }
            }
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage(), (Throwable)e);
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public Double getProgress() {
        return this.progress;
    }
}

