/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.costdocuments.booking;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClientProcedureGenerator {
    private ProcedurName procedurName;
    private Map<String, Object> pwData;
    private int numberOfParameters;
    private StringBuilder parameterPart;
    private StringBuilder parameterPartAsCallable;
    private static Logger log = Logger.getLogger(ClientProcedureGenerator.class);
    private Map<Integer, Object> callableParameters;
    private static final SimpleDateFormat MPM_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public ClientProcedureGenerator(ProcedurName procedurName, Map<String, Object> pwData) {
        this.procedurName = procedurName;
        this.pwData = pwData;
        this.parameterPart = new StringBuilder();
        this.parameterPartAsCallable = new StringBuilder();
        this.callableParameters = new HashMap<Integer, Object>();
        this.numberOfParameters = 0;
    }

    public void addByIdAsString(String name, String sId) {
        Object oValue = this.pwData.get(sId);
        if (oValue == null) {
            log.error((Object)("Nie istnieje pole i od: " + sId));
        } else {
            String sValue = oValue.toString();
            this.addToCallableParameterMapIfNotExist(name, sValue);
            this.addValue(name, sValue, "'");
        }
    }

    public void addByIdAsDate(String name, String sId) {
        Object oValue = this.pwData.get(sId);
        if (oValue == null) {
            log.error((Object)("Nie istnieje pole i od: " + sId));
        } else {
            String sValue = oValue.toString();
            java.sql.Date date = this.convertToDate(sValue);
            this.addToCallableParameterMapIfNotExist(name, date);
            this.addDateValue(name, sValue);
        }
    }

    private java.sql.Date convertToDate(String sDate) {
        log.debug((Object)("parseDate: " + sDate));
        Date date = null;
        try {
            date = MPM_DATE_FORMAT.parse(sDate);
        }
        catch (Exception ex) {
            log.error((Object)"parseFail");
            date = new Date();
        }
        java.sql.Date result = new java.sql.Date(date.getTime());
        return result;
    }

    public void addByIdAsNo(String name, String sId) {
        Object oValue = this.pwData.get(sId);
        try {
            if (oValue == null) {
                throw new Exception("brak zmiennej " + name);
            }
            double dValue = 0.0;
            if (oValue instanceof String) {
                String sValue = (String)oValue;
                dValue = Double.valueOf(sValue);
            } else {
                dValue = (Double)oValue;
            }
            this.addToCallableParameterMapIfNotExist(name, dValue);
            this.addValue(name, String.valueOf(dValue), "");
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage());
            this.addNullValue(name);
        }
    }

    public void addValueAsLong(String name, Long value) {
        this.addToCallableParameterMapIfNotExist(name, value);
        if (value == null) {
            this.addNullValue(name);
        } else {
            this.addValue(name, value.toString(), "");
        }
    }

    public void addByIdAsLong(String name, String sId) {
        Object oValue = this.pwData.get(sId);
        try {
            if (oValue == null) {
                throw new Exception("brak zmiennej" + name);
            }
            Long lValue = 0L;
            if (oValue instanceof String) {
                String sValue = (String)oValue;
                lValue = new Long(sValue);
            } else {
                lValue = (Long)oValue;
            }
            this.addToCallableParameterMapIfNotExist(name, lValue);
            this.addValue(name, lValue.toString(), "");
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            this.addNullValue(name);
        }
    }

    public void addCurrentDateValue(String name) {
        Date currentDate = new Date();
        java.sql.Date sqlDate = new java.sql.Date(currentDate.getTime());
        String sCurrentaDate = MPM_DATE_FORMAT.format(currentDate);
        this.addToCallableParameterMapIfNotExist(name, sqlDate);
        this.addDateValue(name, sCurrentaDate);
    }

    public void addDateValue(String name, String value) {
        java.sql.Date date = this.convertToDate((String)value);
        java.sql.Date sqlDate = new java.sql.Date(date.getTime());
        this.addToCallableParameterMapIfNotExist(name, sqlDate);
        value = "TO_DATE('" + (String)value + "', 'yyyy-mm-dd')";
        this.addValue(name, (String)value, "");
    }

    public void addNullValue(String name) {
        this.addValue(name, "NULL", "");
    }

    public void addValue(String name, String value, String quotes) {
        String callableName = ":" + name;
        this.addToCallableParameterMapIfNotExist(name, value);
        if (this.parameterPart.length() != 0) {
            this.parameterPart.append(",");
            this.parameterPartAsCallable.append(",");
        }
        if (name == null) {
            this.parameterPart.append(quotes + value + quotes);
            this.parameterPartAsCallable.append(callableName);
        } else {
            this.parameterPart.append(name + " => " + quotes + value + quotes + "\n");
            this.parameterPartAsCallable.append(name + " => ? \n");
        }
        ++this.numberOfParameters;
    }

    private void addToCallableParameterMapIfNotExist(String name, Object value) {
        Integer paramNo = this.numberOfParameters + 2;
        Object valueInMap = this.callableParameters.get(paramNo);
        if (valueInMap == null) {
            this.callableParameters.put(paramNo, value);
        }
    }

    public void logProcedure() {
        log.debug((Object)("Procedure: " + this.createCompleteCallingProcedure(this.parameterPart)));
        log.debug((Object)("NoOfParameters: " + this.numberOfParameters));
    }

    public String getProcedure() {
        return this.createCompleteCallingProcedure(this.parameterPart);
    }

    private String createCompleteCallingProcedure(StringBuilder paramter) {
        return "{ " + this.procedurName.name + "(" + paramter.toString() + ") }";
    }

    public CallableStatement createCallableStatment(Connection connect) throws Exception {
        this.logCallableProcedure();
        CallableStatement cs = connect.prepareCall(this.createCompleteCallingProcedure(this.parameterPartAsCallable));
        for (Integer id : this.callableParameters.keySet()) {
            Object value = this.callableParameters.get(id);
            log.debug((Object)(id.toString() + ": " + String.valueOf(value) + " " + value.getClass().getName()));
            if (value == null) continue;
            this.setCallableParametr(cs, value, id);
        }
        return cs;
    }

    private void setCallableParametr(CallableStatement cs, Object value, Integer id) throws Exception {
        if (value instanceof String) {
            String sValue = (String)value;
            cs.setString(id, sValue);
            if (sValue.equalsIgnoreCase("NULL")) {
                cs.setNull(id, 0);
            }
        } else if (value instanceof java.sql.Date) {
            cs.setDate(id, (java.sql.Date)value);
        } else if (value instanceof Double) {
            cs.setDouble(id, (double)((Double)value));
        } else if (value instanceof Long) {
            cs.setLong(id, (long)((Long)value));
        }
    }

    private void logCallableProcedure() {
        log.debug((Object)("CallableProcedure: " + this.createCompleteCallingProcedure(this.parameterPartAsCallable)));
    }

    public static enum ProcedurName {
        WST_DOKUMENT("? = call EGERIA_API_DOKUMENT.DOKUMENT_WSTAW"),
        WST_POZYCJE("? = call EGERIA_API_DOKUMENT.POZYCJA_WSTAW");

        private String name;

        private ProcedurName(String name) {
            this.name = name;
        }
    }
}

