/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.accountsreceivable.tools;

import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassIndexFinder;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.search.hibernate.SimpleHibernateFilter;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFilter;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.search.sql.SimpleSQLFilter;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.json.JSONObject;

public class ClientTools {
    private static final Logger log = Logger.getLogger(ClientTools.class);

    public static String[] getUserOrgUnits(String userName) {
        log.debug((Object)("Wyszukuj\u0119 jednostk\u0119 organizacyjn\u0105 u\u017cytkownika: " + userName));
        String[] orgUnits = null;
        User user = ClientTools.getUserByName(userName);
        if (user != null) {
            Set userPositions = user.getPositions();
            orgUnits = new String[userPositions.size()];
            int i = 0;
            for (Position position : userPositions) {
                orgUnits[i] = position.getOrganizationalUnit().getSymbol();
                ++i;
            }
        }
        return orgUnits;
    }

    private static User getUserByName(String userName) {
        User user = null;
        UserFinder userFinder = FinderFactory.getUserFinder();
        ArrayList<SimpleHibernateFilter> filters = new ArrayList<SimpleHibernateFilter>();
        SimpleHibernateFilter filter = new SimpleHibernateFilter("userName", (Object)userName);
        filters.add(filter);
        CountedResult foundUser = userFinder.findByFilters(filters, null, 0, 0);
        if (foundUser.getData().size() > 0) {
            user = (User)foundUser.getData().get(0);
        } else {
            log.error((Object)("*** Nie uda\u0142o si\u0119 pobra\u0107 u\u017cytkownika o loginie: " + userName));
        }
        return user;
    }

    public static String getOrgUnitFromDB(String scanPoint) {
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery("select oddzial from pm_jas_punkt_skanowania where kod_ps=:kod_ps");
        builder.setParameter("kod_ps", (Object)scanPoint);
        builder.addScalar("oddzial", (Type)StandardBasicTypes.STRING);
        String orgSymbole = "";
        SQLFinder finder = FinderFactory.getSQLFinder();
        List orgUnit = finder.find(builder);
        if (!orgUnit.isEmpty()) {
            orgSymbole = String.valueOf(((Map)orgUnit.get(0)).get("oddzial"));
        }
        return orgSymbole;
    }

    public static boolean isOrgUnitInSystem(String orgUnit) {
        boolean isInSystem = false;
        OrganizationalUnitFinder orgUnitFinder = FinderFactory.getOrganizationalUnitFinder();
        OrganizationalUnit foundOrgUnit = orgUnitFinder.findBySymbol(orgUnit, new String[0]);
        if (foundOrgUnit != null) {
            isInSystem = true;
        }
        return isInSystem;
    }

    public static Date changeStringToDate(String sDate, String sDateFormat) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat(sDateFormat);
        Date date = dateFormat.parse(sDate);
        return date;
    }

    public static String changeDateToString(Date dDate, String sDataFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(sDataFormat);
        String sDate = sdf.format(dDate);
        return sDate;
    }

    public static int getCompanyId(String company) {
        log.debug((Object)("Pobranie id firmy: " + company));
        SQLFinder finder = FinderFactory.getSQLFinder();
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery("select id from pm_jas_firma");
        builder.addScalar("id", (Type)StandardBasicTypes.INTEGER);
        builder.addFilter((SQLFilter)new SimpleSQLFilter("kod_firmy", (Object)company, FilterOperator.EQ));
        int companyId = -1;
        Map mSpolka = null;
        List data = finder.find(builder);
        if (data != null && !data.isEmpty()) {
            mSpolka = (Map)data.get(0);
            log.debug((Object)("Znaleziono firm\u0119 o id: " + String.valueOf(mSpolka.get("id"))));
            companyId = (Integer)mSpolka.get("id");
        }
        return companyId;
    }

    public static Long findIndexIdByCriteria(String indexName, DocumentClass documentClass) {
        DocumentClassIndexFinder dcif = FinderFactory.getDocumentClassIndexFinder();
        DetachedCriteria dc = DetachedCriteria.forClass(DocumentClassIndex.class);
        SimpleExpression cIndexName = Restrictions.eq((String)"name", (Object)indexName);
        SimpleExpression cIndexClassId = Restrictions.eq((String)"documentClass", (Object)documentClass);
        dc.add((Criterion)Restrictions.and((Criterion)cIndexName, (Criterion)cIndexClassId));
        DocumentClassIndex indexData = (DocumentClassIndex)dcif.findByCriteria(dc).get(0);
        return indexData.getId();
    }

    public static JSONObject getResponseFromWS(String sUrl, Map<String, String> parameters) throws Exception {
        try (BufferedReader reader = null;){
            StringBuilder authData = new StringBuilder();
            authData.append(SystemProperties.getString((String)"WS_USER"));
            authData.append(SystemProperties.getString((String)"WS_PASS"));
            byte[] authEncBytes = Base64.encodeBase64((byte[])authData.toString().getBytes());
            String authStringEnc = new String(authEncBytes);
            StringBuilder wsUrl = new StringBuilder();
            wsUrl.append(sUrl);
            wsUrl.append("?");
            Set<Map.Entry<String, String>> entrySet = parameters.entrySet();
            int i = 0;
            for (Map.Entry<String, String> entry : entrySet) {
                wsUrl.append(i > 0 ? "&" : "");
                wsUrl.append(entry.getKey());
                wsUrl.append("=");
                wsUrl.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                ++i;
            }
            log.debug((Object)("wsUrl: " + String.valueOf(wsUrl)));
            URL url = new URL(wsUrl.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("charset", "UTF-8");
            connection.setRequestProperty("Authorization", "Basic " + authStringEnc);
            int responseCode = connection.getResponseCode();
            StringBuilder response = new StringBuilder();
            log.debug((Object)("responseCode: " + responseCode));
            if (responseCode < 400) {
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String line = "";
                while ((line = reader.readLine()) != null) {
                    log.debug((Object)("line: " + line));
                    response.append(line);
                }
            } else {
                throw new Exception("Dane nie zosta\u0142y pobrane");
            }
            log.debug((Object)response.toString());
            JSONObject jsonResult = null;
            if (response.toString().compareToIgnoreCase("null") != 0) {
                jsonResult = new JSONObject(response.toString());
            } else {
                log.debug((Object)"Dokument nie zosta\u0142 odnaleziony");
            }
            JSONObject jSONObject = jsonResult;
            return jSONObject;
        }
    }

    public static boolean isDocumentInArchive(Map<String, Object> indexes, String className) {
        CountedResult<WfDocument> result = ClientTools.getDocumentsFromArchive(indexes, className);
        long total = result.getTotal();
        return (int)total > 0;
    }

    public static CountedResult<WfDocument> getDocumentsFromArchive(Map<String, Object> indexes, String className) {
        DocumentClassService docClassService = ServiceFactory.getDocumentClassService();
        DocumentClass docClass = docClassService.getDocumentClass(className, new String[0]);
        DocumentFinder documentFinder = FinderFactory.getDocumentFinder();
        HashMap<Long, Object> idx = new HashMap<Long, Object>();
        Set<Map.Entry<String, Object>> entrySet = indexes.entrySet();
        for (Map.Entry<String, Object> oneResult : entrySet) {
            long lIndex = ClientTools.findIndexIdByCriteria(oneResult.getKey(), docClass);
            idx.put(lIndex, oneResult.getValue());
        }
        ArrayList<Sorter> sorters = new ArrayList<Sorter>();
        sorters.add(new Sorter("1", SortDirection.DESC));
        CountedResult result = documentFinder.findByIndexes(docClass.getId(), idx, sorters, Integer.valueOf(0), Integer.valueOf(5), new String[0]);
        return result;
    }

    public static boolean checkDuplicate(Map<String, Object> indexes, String className, long file_id) throws Exception {
        CountedResult<WfDocument> result = ClientTools.getDocumentsFromArchive(indexes, className);
        boolean isDuplicate = false;
        if (result != null) {
            for (WfDocument document : result.getData()) {
                if (document.getFile().getId() == file_id) continue;
                isDuplicate = true;
                break;
            }
        }
        return isDuplicate;
    }
}

