/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.accountsreceivable.scripts;

import com.plusmpm.enhydra.shark.transaction.WfActivityTransaction;
import com.plusmpm.util.documents.DocumentEvent;
import com.plusmpm.util.documents.handlers.DocumentEventHandler;
import com.suncode.plugin.jasfbgclient.accountsreceivable.tools.ClientTools;
import com.suncode.plugin.jasfbgclient.documents.util.extensions.DocTools;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessFinder;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AddAttachmentToProcesses
implements DocumentEventHandler {
    private static final Logger log = Logger.getLogger(AddAttachmentToProcesses.class);
    private static final String PROCESS_DEF_ID = "arch_nalezn";
    private static final String ATTACHMENTS_CLASS_NAME = "Za\u0142\u0105czniki nale\u017cno\u015bci";
    private final DocumentService documentService = ServiceFactory.getDocumentService();

    public AddAttachmentToProcesses(String processId) {
    }

    public void handleEvent(WfActivityTransaction st, DocumentEvent documentEvent) throws Exception {
        long fileId = documentEvent.getDocument().getLFileId();
        DocumentClassService docClassService = ServiceFactory.getDocumentClassService();
        WfDocument document = this.documentService.getDocument(Long.valueOf(fileId));
        DocumentClass documentClass = docClassService.getDocumentClass(ATTACHMENTS_CLASS_NAME, new String[0]);
        long docNumberIndex = ClientTools.findIndexIdByCriteria("Numer dokumentu", documentClass);
        long companyIndex = ClientTools.findIndexIdByCriteria("Firma", documentClass);
        long orgUnitIndex = ClientTools.findIndexIdByCriteria("Punkt skanowania", documentClass);
        String docNumber = (String)document.getIndexValue(Long.valueOf(docNumberIndex));
        docNumber = docNumber.replace("@", "/");
        String company = (String)document.getIndexValue(Long.valueOf(companyIndex));
        String orgUnit = (String)document.getIndexValue(Long.valueOf(orgUnitIndex));
        log.debug((Object)("Wyszukuj\u0119 proces o numerze dokumentu: " + docNumber + " i Firma: " + company));
        HashMap<String, Object> idxValues = new HashMap<String, Object>();
        idxValues.put("numer_dokumentu", docNumber);
        idxValues.put("firma", company);
        String processId = AddAttachmentToProcesses.getSearchedProcessId(idxValues);
        if (StringUtils.isNotBlank((CharSequence)processId)) {
            log.debug((Object)"Pod\u0142\u0105czam dokumentu do procesu");
            this.documentService.attachDocumentToProcess(document, "admin", processId, null);
            log.debug((Object)("Dodano za\u0142\u0105cznik " + document.getFile().getFileName() + "do procesu o id: " + processId + ". Synchronizuj\u0119 indeksy"));
            this.synchronizeIndexes(processId, document);
        } else {
            log.debug((Object)("Nie odnaleziono procesu o numerze dokumentu: " + docNumber + " i Firmie: " + company + ". Dokument zostanie usuni\u0119ty z Archiwum."));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String currentDate = sdf.format(new Date());
            HashMap<String, String> newIndexes = new HashMap<String, String>();
            newIndexes.put("numer_dokumentu", docNumber);
            newIndexes.put("firma", company);
            newIndexes.put("klasa", ATTACHMENTS_CLASS_NAME);
            newIndexes.put("data_archiwizacji", currentDate);
            DocTools.wyslijPowiadomienie("ZALACZNIKI_NALEZNOSCI", fileId, orgUnit, "ARCHIWIZACJA_BRAK_DOK_GLOWNEGO", newIndexes, ATTACHMENTS_CLASS_NAME);
            this.documentService.deleteDocument(document);
        }
    }

    private boolean synchronizeIndexes(String processId, WfDocument document) {
        ProcessService processService = ServiceFactory.getProcessService();
        Map mProcessContext = processService.getProcessContext(processId);
        boolean idxSynchronized = false;
        try {
            log.debug((Object)"Synchronizuj\u0119 indeksy");
            document.setIndexValue("Data archiwizacji", (Object)ClientTools.changeStringToDate((String)mProcessContext.get("data_archiwizacji"), "yyyy-MM-dd"));
            document.setIndexValue("Data wystawienia", (Object)ClientTools.changeStringToDate((String)mProcessContext.get("data_wystawienia"), "yyyy-MM-dd"));
            document.setIndexValue("Dokument elektroniczny", (Object)((String)mProcessContext.get("dokument_elektroniczny")));
            document.setIndexValue("Firma", (Object)((String)mProcessContext.get("firma")));
            document.setIndexValue("Forma p\u0142atno\u015bci", (Object)((String)mProcessContext.get("forma_platnosci")));
            document.setIndexValue("Kod klienta", (Object)((String)mProcessContext.get("kod_klienta")));
            document.setIndexValue("Kwota netto", (Object)((Double)mProcessContext.get("kwota_netto")));
            document.setIndexValue("NIP", (Object)((String)mProcessContext.get("nip")));
            document.setIndexValue("Nazwa", (Object)((String)mProcessContext.get("nazwa")));
            document.setIndexValue("Numer Obcy", (Object)((String)mProcessContext.get("numer_obcy")));
            document.setIndexValue("Numer dokumentu", (Object)((String)mProcessContext.get("numer_dokumentu")));
            document.setIndexValue("Osoba weryfikuj\u0105ca", (Object)((String)mProcessContext.get("osoba_weryfikujaca")));
            document.setIndexValue("Osoba wystawiaj\u0105ca", (Object)((String)mProcessContext.get("osoba_wystawiajaca")));
            document.setIndexValue("Podatek", (Object)((Double)mProcessContext.get("podatek")));
            document.setIndexValue("Punkt skanowania", (Object)((String)mProcessContext.get("punkt_skanowania")));
            document.setIndexValue("Plac\u00f3wka", (Object)((String)mProcessContext.get("placowka")));
            document.setIndexValue("Status", (Object)((String)mProcessContext.get("status")));
            document.setIndexValue("Waluta", (Object)((String)mProcessContext.get("waluta")));
            this.documentService.updateDocument(document);
            idxSynchronized = true;
            log.debug((Object)"Indeksy zosta\u0142y zsynchronizowane");
        }
        catch (Exception e) {
            log.debug((Object)("Wyst\u0105pi\u0142 b\u0142\u0105d podczas synchronizacji: " + e.getMessage()), (Throwable)e);
        }
        return idxSynchronized;
    }

    private static String getSearchedProcessId(Map<String, Object> indexes) {
        ProcessFinder processFinder = FinderFactory.getProcessFinder();
        String processId = "";
        List processes = processFinder.findByIndexes(PROCESS_DEF_ID, indexes, new String[0]);
        Date createdTieme = null;
        for (Process process : processes) {
            if (createdTieme == null) {
                createdTieme = process.getCreatedTime();
                processId = process.getProcessId();
                continue;
            }
            if (!createdTieme.before(process.getCreatedTime())) continue;
            createdTieme = process.getCreatedTime();
            processId = process.getProcessId();
        }
        return processId;
    }
}

