/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.accountsreceivable.applications;

import com.suncode.plugin.jasfbgclient.accountsreceivable.tools.ClientTools;
import com.suncode.plugin.jasfbgclient.category.Categories;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

@Application
@ComponentsFormScript(value="scripts/dynamic-form-pwe/get-accounts-receivable-data-form.js")
public class GetAccountsReceivableData {
    private static final Logger log = Logger.getLogger(GetAccountsReceivableData.class);
    private static final String PROCESS_DEF_ID = "arch_nalezn";

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("jas-fbg-client.get-accounts-receivable-data")).name("Pobieranie danych nale\u017cno\u015bci JAS-FBG Client")).description("Pobieranie danych nale\u017cno\u015bci JAS-FBG Client")).icon((Icon)SilkIconPack.APPLICATION)).category(new Category[]{Categories.JASFBG})).parameter().id("actionParameter").name("Akcja").type((Type)Types.VARIABLE).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(ApplicationContext applicationContext, @Param Variable actionParameter) throws Exception {
        log.debug((Object)"***** GetAccountsReceivableData application *****");
        String status = "Oczekuje na weryfikacj\u0119";
        String processId = applicationContext.getProcessId();
        String activityId = applicationContext.getActivityId();
        String actionMessage = "przeslij_do_weryfikacji";
        log.debug((Object)("ProcessId: " + processId + ", activityId: " + activityId));
        ProcessService processService = ServiceFactory.getProcessService();
        Map<String, String> mProcessContext = new HashMap<String, String>();
        ActivityService activityService = ServiceFactory.getActivityService();
        HashMap<String, Object> mActivityContext = new HashMap<String, Object>();
        try {
            mProcessContext = processService.getProcessContext(processId);
            String documentNumber = (String)mProcessContext.get("numer_dokumentu");
            String company = (String)mProcessContext.get("firma");
            String activityDefId = activityService.getActivity(processId, activityId, new String[]{PROCESS_DEF_ID}).getActivityDefinitionId();
            if (activityDefId.compareToIgnoreCase("usupelnienie_danych") == 0) {
                mProcessContext.put("numer_dokumentu", documentNumber);
                mActivityContext.put("numer_dokumentu", documentNumber);
            }
            int companyId = ClientTools.getCompanyId(company);
            if (StringUtils.isNotBlank((CharSequence)documentNumber) && companyId >= 0) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("DocumentNumber", documentNumber);
                parameters.put("CompanyId", String.valueOf(companyId));
                parameters.put("documentClass", "class");
                JSONObject documentJson = ClientTools.getResponseFromWS(SystemProperties.getString((String)"NALEZNOSCI_WS_URL"), parameters);
                if (documentJson != null) {
                    log.debug((Object)"Dane dokumentu zosta\u0142y pobrane");
                    Map<String, Object> wsData = GetAccountsReceivableData.translateDocument(documentJson);
                    mProcessContext.putAll(wsData);
                    mActivityContext.putAll(wsData);
                    actionMessage = "zakoncz";
                    status = "Faktura zarchiwizowana";
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)"Dane dokumentu nie zosta\u0142y pobrane");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            mProcessContext.put("status", status);
            mActivityContext.put("status", status);
            actionParameter.setValue((Object)actionMessage);
            processService.setProcessContext(processId, mProcessContext);
            activityService.setActivityContext(processId, activityId, mActivityContext);
        }
    }

    private static Map<String, Object> translateDocument(JSONObject document) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("data_wystawienia", ClientTools.changeDateToString(ClientTools.changeStringToDate(document.getString("DocumentDate"), "yyyy-MM-dd'T'HH:mm:ss"), "yyyy-MM-dd"));
            map.put("dokument_elektroniczny", document.getBoolean("IsElectronic") ? "Tak" : "Nie");
            map.put("forma_platnosci", document.getString("PaymentMethod"));
            map.put("kod_klienta", document.getString("CustomerCode"));
            map.put("kwota_netto", document.getDouble("AmountNet"));
            map.put("nip", document.getString("CustomerTaxId"));
            map.put("nazwa", document.getString("CustomerFullName"));
            map.put("placowka", document.getString("Branch"));
            map.put("osoba_wystawiajaca", document.getString("Person"));
            map.put("podatek", document.getDouble("Tax"));
            map.put("waluta", document.getString("Currency"));
            map.put("numer_obcy", document.getString("ForeignNumber"));
        }
        catch (Exception e) {
            log.error((Object)("B\u0142\u0105d pobierania danych: " + e.getMessage()), (Throwable)e);
        }
        return map;
    }
}

