/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.P0063.services;

import com.suncode.plugin.jasfbgclient.P0063.services.ArchiveService;
import com.suncode.plugin.jasfbgclient.P0063.services.MrnDocumentData;
import com.suncode.plugin.jasfbgclient.P0063.services.WfDocumentResponse;
import com.suncode.plugin.jasfbgclient.P0063.services.WfResponse;
import com.suncode.plugin.jasfbgclient.documents.util.extensions.config.Configuration;
import com.suncode.plugin.jasfbgclient.documents.util.extensions.config.DodanieDoArchiwumConfig;
import com.suncode.plugin.jasfbgclient.documents.util.extensions.config.GrupaDokumentow;
import com.suncode.plugin.jasfbgclient.documents.util.extensions.config.KlasaDokumentow;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.util.IOUtils;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class ArchiveServiceImpl
implements ArchiveService {
    private Logger log = Logger.getLogger(ArchiveServiceImpl.class);
    private DodanieDoArchiwumConfig _config = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MrnDocumentData> findDocumentsByMrnNumber(String mrnNumber) {
        ArrayList<MrnDocumentData> listOfDocuments = new ArrayList<MrnDocumentData>();
        if (mrnNumber != null && mrnNumber.length() > 0 && mrnNumber.indexOf("'") < 0) {
            this.log.trace((Object)("Searching archive for MRN: " + mrnNumber));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            SQLFinder finder = FinderFactory.getSQLFinder();
            try {
                SQLBuilder builder = new SQLBuilder();
                String selectQuery = "SELECT * FROM (SELECT 1 as classId, 'Dokumenty celne eksportowe' as className,* FROM pm_idx0001 WHERE idx0004='@mrnNumber@' UNION SELECT 2 as classId, 'Dokumenty celne importowe' as className,* FROM pm_idx0002 WHERE idx00012='@mrnNumber@' UNION SELECT 3 as classId, 'Dokumenty celne tranzytowe' as className,* FROM pm_idx0003 WHERE idx00020='@mrnNumber@' UNION SELECT 5 as classId, 'Dokumenty celne inne' as className,* FROM pm_idx0005 WHERE idx00031='@mrnNumber@') as t1 LEFT JOIN pm_files ON t1.fileid = pm_files.id WHERE idx00025='Aktywny' ORDER BY classId";
                selectQuery = selectQuery.replace("@mrnNumber@", mrnNumber);
                builder.setQuery(selectQuery);
                builder.addScalar("fileid", (Type)StandardBasicTypes.STRING);
                builder.addScalar("classname", (Type)StandardBasicTypes.STRING);
                builder.addScalar("org_name", (Type)StandardBasicTypes.STRING);
                builder.addScalar("idx0001", (Type)StandardBasicTypes.STRING);
                builder.addScalar("idx0002", (Type)StandardBasicTypes.STRING);
                builder.addScalar("idx0003", (Type)StandardBasicTypes.STRING);
                builder.addScalar("idx0004", (Type)StandardBasicTypes.STRING);
                builder.addScalar("idx0005", (Type)StandardBasicTypes.STRING);
                builder.addScalar("idx0006", (Type)StandardBasicTypes.STRING);
                builder.addScalar("idx0007", (Type)StandardBasicTypes.STRING);
                builder.addScalar("idx0008", (Type)StandardBasicTypes.STRING);
                List listOfResults = finder.find(builder);
                for (Map oneResults : listOfResults) {
                    Date date;
                    MrnDocumentData mrnDocumentData = new MrnDocumentData();
                    mrnDocumentData.setFileId((String)oneResults.get("fileid"));
                    mrnDocumentData.setClassName((String)oneResults.get("classname"));
                    mrnDocumentData.setDocumentId((String)oneResults.get("idx0001"));
                    mrnDocumentData.setDepartment((String)oneResults.get("idx0002"));
                    mrnDocumentData.setDocumentType((String)oneResults.get("idx0003"));
                    mrnDocumentData.setMrnNumber((String)oneResults.get("idx0004"));
                    mrnDocumentData.setFileName((String)oneResults.get("org_name"));
                    try {
                        date = sdf.parse((String)oneResults.get("idx0005"));
                        mrnDocumentData.setApplicationDate(date);
                    }
                    catch (Exception e) {
                        this.log.info((Object)("Value cannot be parset into date: " + String.valueOf(oneResults.get("idx0005"))));
                    }
                    mrnDocumentData.setInternalNumber((String)oneResults.get("idx0006"));
                    mrnDocumentData.setContractorNumber((String)oneResults.get("idx0007"));
                    try {
                        date = sdf.parse((String)oneResults.get("idx0008"));
                        mrnDocumentData.setArchivisationDate(date);
                    }
                    catch (Exception e) {
                        this.log.info((Object)("Value cannot be parset into date: " + String.valueOf(oneResults.get("idx0008"))));
                    }
                    listOfDocuments.add(mrnDocumentData);
                }
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            this.log.info((Object)("Incorrect value of MRN: " + mrnNumber));
        }
        return listOfDocuments;
    }

    @Override
    public byte[] getFileByFileId(String fileId) {
        this.log.trace((Object)("Retriving file from archive with fileId: " + fileId));
        byte[] dataHandler = null;
        if (fileId != null && fileId.length() > 0) {
            FileService fileService = ServiceFactory.getFileService();
            WfFile file = null;
            try {
                file = fileService.getFile(Long.valueOf(Long.parseLong(fileId)), new String[]{"documentClass"});
            }
            catch (Exception e) {
                this.log.info((Object)("Cannot get file with id: " + fileId));
            }
            if (file != null) {
                String fileName = "";
                String sFilePath = file.getFullPath();
                this.log.trace((Object)("File full path: " + sFilePath));
                try {
                    FileInputStream inputStram = new FileInputStream(sFilePath);
                    dataHandler = IOUtils.toByteArray((InputStream)inputStram);
                }
                catch (Exception e) {
                    this.log.error((Object)"An error occured during changing file into byte array.");
                }
                this.log.trace((Object)("File " + fileName + " ready to download"));
            } else {
                this.log.info((Object)("File with following id is null: " + fileId));
            }
        }
        return dataHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WfResponse findDocumentsInCategory(String category, String kod_kreskowy) {
        WfResponse response;
        Integer status;
        block25: {
            status = null;
            response = new WfResponse();
            SQLFinder finder = FinderFactory.getSQLFinder();
            try {
                Map<String, GrupaDokumentow> grupy_dokumentow;
                if (this._config == null) {
                    this.log.debug((Object)"odczytywanie pliku");
                    this._config = Configuration.odczytajConfig();
                }
                if ((grupy_dokumentow = this._config.getGrupy_dokumentow()) == null) {
                    status = -1;
                    throw new Exception("Nie poprawnie zdefiniowany plik konfiguracyjny");
                }
                if (grupy_dokumentow.isEmpty()) {
                    status = -1;
                    throw new Exception("Nie poprawnie zdefiniowany plik konfiguracyjny, brak jakiejkolwiek kategorii");
                }
                GrupaDokumentow grupa_dokumentow = grupy_dokumentow.get(category);
                if (grupa_dokumentow == null) {
                    status = -2;
                    throw new Exception("Brak kategorii: " + category + ", w pliku konfiguracyjnym");
                }
                Map<Long, KlasaDokumentow> klasa_dokumentow = grupa_dokumentow.getKlasy_dokumentow();
                if (klasa_dokumentow == null) {
                    status = -1;
                    throw new Exception("Nie poprawnie zdefiniowany plik konfiguracyjny");
                }
                for (KlasaDokumentow k : klasa_dokumentow.values()) {
                    String nazwa_indeksu_kodu_kreskowego;
                    Map<String, Long> nazwy_indeksow_map_id = k.getMapping();
                    Long indeks_kodu_kreskowego = nazwy_indeksow_map_id.get(nazwa_indeksu_kodu_kreskowego = k.getNazwa_kod_kreskowy());
                    if (indeks_kodu_kreskowego == null) {
                        this.log.error((Object)("Brak indeksu kodu kreskowego dla: " + k.getNazwa()));
                        continue;
                    }
                    SQLBuilder builder = new SQLBuilder();
                    String query_find_file_id = "SELECT 1 as jeden FROM pm_idx000@docClassId@ WHERE idx000@idxKodId@ = '@valueKod@'";
                    query_find_file_id = query_find_file_id.replace("@docClassId@", String.valueOf(k.getId())).replace("@idxKodId@", String.valueOf(indeks_kodu_kreskowego)).replace("@valueKod@", kod_kreskowy);
                    builder.setQuery(query_find_file_id);
                    builder.addScalar("jeden", (Type)StandardBasicTypes.STRING);
                    List document = finder.find(builder);
                    if (document == null) {
                        this.log.error((Object)"B\u0142\u0105d przy sprawdzaniu czy dany dokument istnieje w bazie");
                        continue;
                    }
                    if (document.isEmpty()) {
                        this.log.debug((Object)"Brak dokumentu dla podanego kodu kreskowego");
                        continue;
                    }
                    HashMap<Long, String> indeksy_map_nazwy = new HashMap<Long, String>();
                    List dane_dokumentow_db = null;
                    SQLBuilder sqlbuilder = new SQLBuilder();
                    StringBuilder sb = new StringBuilder();
                    sb.append("SELECT pm_files.id as fileid, pm_files.name as name, pm_files.path as path, pm_files.file_size as filesize, pm_files.org_name as orgname, pm_files.file_date as filedate, ");
                    sqlbuilder.addScalar("fileid", (Type)StandardBasicTypes.STRING);
                    sqlbuilder.addScalar("name", (Type)StandardBasicTypes.STRING);
                    sqlbuilder.addScalar("path", (Type)StandardBasicTypes.STRING);
                    sqlbuilder.addScalar("filesize", (Type)StandardBasicTypes.STRING);
                    sqlbuilder.addScalar("orgname", (Type)StandardBasicTypes.STRING);
                    sqlbuilder.addScalar("filedate", (Type)StandardBasicTypes.STRING);
                    int i = 0;
                    for (String nazwa : nazwy_indeksow_map_id.keySet()) {
                        Long indeks = nazwy_indeksow_map_id.get(nazwa);
                        indeksy_map_nazwy.put(indeks, nazwa);
                        sb.append("indeksy.");
                        sb.append("idx000");
                        sb.append(indeks);
                        sb.append(" as \"");
                        sb.append(indeks);
                        sqlbuilder.addScalar(Long.toString(indeks), (Type)StandardBasicTypes.STRING);
                        sb.append("\"");
                        if (i < nazwy_indeksow_map_id.size() - 1) {
                            sb.append(", ");
                        } else {
                            sb.append(" ");
                        }
                        ++i;
                    }
                    sb.append(" FROM ");
                    sb.append("pm_idx000");
                    sb.append(k.getId());
                    sb.append(" as indeksy JOIN pm_files as pm_files ON indeksy.fileid = pm_files.id WHERE indeksy.idx000");
                    sb.append(indeks_kodu_kreskowego);
                    sb.append(" = '");
                    sb.append(kod_kreskowy);
                    sb.append("'");
                    this.log.debug((Object)("Zapytanie: " + String.valueOf(sb)));
                    sqlbuilder.setQuery(sb.toString());
                    dane_dokumentow_db = finder.find(sqlbuilder);
                    if (dane_dokumentow_db == null || dane_dokumentow_db.isEmpty()) {
                        status = -4;
                        throw new Exception("B\u0142\u0105d przy pobieraniu danych dla indeks\u00f3w z bazy");
                    }
                    status = 0;
                    response.setDescription("");
                    for (Map dane_pliku : dane_dokumentow_db) {
                        WfDocumentResponse file_response = new WfDocumentResponse();
                        file_response.setDocClassName(k.getNazwa());
                        HashMap<String, String> indecies = new HashMap<String, String>();
                        for (String columns : dane_pliku.keySet()) {
                            this.log.debug((Object)("key d: " + columns));
                            String value = (String)dane_pliku.get(columns);
                            this.log.debug((Object)("value: " + value));
                            if (columns.equals("fileid")) {
                                file_response.setFileId(Long.parseLong(value));
                                continue;
                            }
                            if (columns.equals("filesize")) {
                                file_response.setFileSize(Long.parseLong(value));
                                continue;
                            }
                            if (columns.equals("orgname")) {
                                file_response.setFullFileName(value);
                                continue;
                            }
                            if (columns.equals("filedate")) {
                                file_response.setUpload_date(value);
                                continue;
                            }
                            if (columns.equals("path")) {
                                file_response.setPath(value);
                                continue;
                            }
                            if (columns.equals("name")) {
                                file_response.setName(value);
                                continue;
                            }
                            String nazwa_indeksu = (String)indeksy_map_nazwy.get(Long.parseLong(columns));
                            this.log.debug((Object)("nazwa indeksu: " + nazwa_indeksu));
                            indecies.put(nazwa_indeksu, value);
                        }
                        file_response.setIndecies(indecies);
                        response.getFiles().add(file_response);
                    }
                }
                if (status != null) break block25;
                status = -3;
            }
            catch (Exception e) {
                block26: {
                    try {
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                        if (status != null) break block26;
                        status = -10;
                    }
                    catch (Throwable throwable) {
                        this.log.debug((Object)("status: " + status));
                        response.setStatus(status);
                        throw throwable;
                    }
                }
                this.log.debug((Object)("status: " + status));
                response.setStatus(status);
            }
        }
        this.log.debug((Object)("status: " + status));
        response.setStatus(status);
        return response;
    }
}

