var tableHeaderTitle = 'Tabela dekretacji';

SuncodeFormService.addOnReadyEvent(refreshTableHeaderTitleOnReady);

function refreshTableHeaderTitleOnReady(){
    var vssForTable = ServiceFactory.getVariableSetService();
    var vsForTable = ServiceFactory.getVariableService();
    var grid = vssForTable.get('tabela_dekretacji');
    if(grid.getId() != undefined){
        vsForTable.addEvent('kwota_netto', 'change', refreshTableHeader);
        vsForTable.addEvent('rezerwa', 'change', refreshReserveColumnState);
        refreshReserveColumnState();
        refreshTableHeader();
    }
}

function viewReadyForTable( table, eOpts ) {
    SuncodeFormService.suspendLayouts();
    try {
        refreshTable();
    }
    finally {
        SuncodeFormService.resumeLayouts();
    }
}

function refreshTable(){
    var vssForTable = ServiceFactory.getVariableSetService();
    var vsForTable = ServiceFactory.getVariableService();

    var grid = vssForTable.get('tabela_dekretacji');
    if(grid.getId() != undefined){
        var rowsCount = vssForTable.getRowsCount(grid);
        for(var index = 0; index < rowsCount; index++)
            calculateNetAndGrossForRowAddOrRemove( index );
    }
}

function setNetAndGrossValuesByCurrency( record ){
    var vsForTable = ServiceFactory.getVariableService();
    var netValue = vsForTable.getValue('kwota_netto');
    var currency = vsForTable.getValue('waluta');
    var currencyRate = vsForTable.getValue('kurs_waluty');

    var netValueInPLN = 0;
    if(currency.indexOf('PLN') > -1 ) {
        record.data.kwota_netto_pozycji_w_p = (parseFloat(record.data.kwota_netto_pozycji)).toFixed(2);
        netValueInPLN = parseFloat(record.data.kwota_netto_pozycji_w_p);
        setNetAndGrossValuesInRow(netValueInPLN, record);
    }else{
        netValueInPLN = parseFloat(record.data.kwota_netto_pozycji) * currencyRate;
        record.data.kwota_netto_pozycji_w_p = netValueInPLN.toFixed(2);
        setNetAndGrossValuesInRow(netValueInPLN, record);
    }
}

function setNetAndGrossValuesInRow(netValue, record){
    var vatRate = parseFloat(record.data.stawka_vat);
    var vatCost = parseFloat(record.data.kwota_vat);

    if(!isNaN(vatRate)){
        var rate = vatRate / 100;
        var vatValue = netValue * rate;
        if(isFieldEmpty(vatCost))
            record.data.kwota_vat = vatValue.toFixed(2);
        record.data.kwota_brutto_pozycji_w = (netValue + vatValue).toFixed(2);

    }else{
        record.data.kwota_brutto_pozycji_w = netValue.toFixed(2);
        record.data.kwota_vat = 0;
    }

}

function refreshTableHeader(){
    var vss = ServiceFactory.getVariableSetService();
    var vs = ServiceFactory.getVariableService();
    var ais = ServiceFactory.getActivityInfoService();

    var vatSumColumnInPLN = null;
    var grossSumColumnInPLN = null;

    var grid = vss.get('tabela_dekretacji');
    if(grid.getId() != undefined){

        var activityDefId = ais.getActivityDefId();

        if( activityDefId === 'opis_ksiegowy' ){
            vatSumColumnInPLN = parseFloat(vss.getColumnSum(grid, 'kwota_vat')).toFixed(2);
            grossSumColumnInPLN = parseFloat(vss.getColumnSum(grid, 'kwota_brutto_pozycji_w')).toFixed(2);
        }

        var net = parseFloat(vs.getValue('kwota_netto')).toFixed(2);
        var netSumColumn = parseFloat(vss.getColumnSum(grid, 'kwota_netto_pozycji')).toFixed(2);

        var dif = (parseFloat(net) - parseFloat(netSumColumn)).toFixed(2);
        var newHeaderTitle = '';
        if(dif == 0){
            newHeaderTitle = tableHeaderTitle + '<br> Łączna wartość NETTO (z nagłówka/z tabeli):  <font color="#2E8B57">' + net.toString().replace('.',',') + '</font> / <font color="#2E8B57">' + netSumColumn.toString().replace('.',',') + '</font> ' +  ' Rozbieżność sumy: <font color="#2E8B57">' + dif.toString().replace('.',',') + '</font>';
        }else{
            newHeaderTitle = tableHeaderTitle + '<br> Łączna wartość NETTO (z nagłówka/z tabeli):  <font color="#800000">' + net.toString().replace('.',',') + '</font> / <font color="#800000">' + netSumColumn.toString().replace('.',',') + '</font> ' +  ' Rozbieżność sumy: <font color="#800000">' + dif.toString().replace('.',',') + '</font>';
        }

        if(vatSumColumnInPLN != null && grossSumColumnInPLN != null){
            newHeaderTitle += '<br> Łączna wartość BRUTTO w PLN:  <font color="#E85C00">' + grossSumColumnInPLN.toString().replace('.',',') + '</font>' + ' Łączna wartość stawki VAT w PLN:  <font color="#E85C00">' + vatSumColumnInPLN.toString().replace('.',',') + '</font> ';
        }

        vss.setTitle(grid, newHeaderTitle);
    }
}

function addRowDataToTable( store, records, index, eOpts ) {
    SuncodeFormService.suspendLayouts();
    try {
        calculateNetAndGrossForRowAddOrRemove(index);
        setTaxDate(records);
        setDecreeRecordValuesForReserve( records );
    }
    finally {
        SuncodeFormService.resumeLayouts();
    }
}

function removeDataRowFromTable( store, record, index, isMove, eOpts ) {
    calculateNetAndGrossForRowAddOrRemove(index);
}

function calculateNetAndGrossForRowAddOrRemove( index ){
    var rowNetAmountInPositionId = 'kwota_netto_pozycji';
    var rowPercentId = 'procent';

    var vsForTable = ServiceFactory.getVariableService();
    var netValue = vsForTable.getValue('kwota_netto');


    var vssForTable = ServiceFactory.getVariableSetService();
    var grid = vssForTable.get('tabela_dekretacji');

    var netValueInRow = vssForTable.getValue(grid, index, rowNetAmountInPositionId);

    if((netValueInRow == '' || netValueInRow=='0.00') &&  parseFloat(netValue) != 0){
        var netSumColumn = vssForTable.getColumnSum(grid, rowNetAmountInPositionId);
        var net = netValue - netSumColumn;
        var procentage = (net / netValue) * 100;

        if(!isNaN(procentage))
            vssForTable.setValue(grid, index, rowPercentId, procentage);
        vssForTable.setValue(grid, index, rowNetAmountInPositionId, net.toFixed(2))
    }else if(parseFloat(netValue) != 0){
        var procentage = (netValueInRow  / netValue) * 100;
        if(!isNaN(procentage))
            vssForTable.setValue(grid, index, rowPercentId, procentage);

        var netValue = vsForTable.getValue('kwota_netto');
        var currency = vsForTable.getValue('waluta');
        var currencyRate = vsForTable.getValue('kurs_waluty');

        var netValueInPLN = 0;
        if(currency.indexOf('PLN') > -1 ) {
            netValueInPLN = parseFloat(netValueInRow);
            vssForTable.setValue(grid, index, 'kwota_netto_pozycji_w_p', netValueInPLN.toFixed(2));
            insertGrossValueInRowOnLoad(index, netValueInPLN);
        }else{
            netValueInPLN = parseFloat(netValueInRow) * parseFloat(currencyRate);
            vssForTable.setValue(grid, index, 'kwota_netto_pozycji_w_p', netValueInPLN.toFixed(2));
            insertGrossValueInRowOnLoad(index, netValueInPLN);
        }

        setTaxDateForRowOnLoad(index);
        setDecreeSectionForRowInReserveOnLoad(index);
        setDecreeTaxForRowInReserveOnLoad(index);
    }
    refreshTableHeader();
}

function setTaxDateForRowOnLoad(index){
    var vssForTable = ServiceFactory.getVariableSetService();
    var vsForTable = ServiceFactory.getVariableService();
    var grid = vssForTable.get('tabela_dekretacji');

    var currentTaxDate = vssForTable.getValue(grid, index, 'data_obowiazku_vat_pozy');
    if(isFieldEmpty(currentTaxDate)){
        var vatDate = vsForTable.getValue('data_obowiazku_vat');
        vssForTable.setValue(grid, index, 'data_obowiazku_vat_pozy', vatDate);
    }
}

function setDecreeSectionForRowInReserveOnLoad(index){
    var vsForTable = ServiceFactory.getVariableService();
    var vssForTable = ServiceFactory.getVariableSetService();
    var grid = vssForTable.get('tabela_dekretacji');

    var docCategory = vsForTable.getValue('kategoria_dokumentu');
    if(docCategory.indexOf('Rezerwy kosztowe' ) > -1){
        var currentRegistrySection = vsForTable.getValue('sekcja_rejestru');
        if(isFieldEmpty(currentRegistrySection))
            vssForTable.setValue(grid, index, 'sekcja_rejestru', 'REZ');
    }

}

function setDecreeTaxForRowInReserveOnLoad(index){
    var vssForTable = ServiceFactory.getVariableSetService();
    var vsForTable = ServiceFactory.getVariableService();
    var grid = vssForTable.get('tabela_dekretacji');

    var docCategory = vsForTable.getValue('kategoria_dokumentu');
    if(docCategory.indexOf('Rezerwy kosztowe' ) > -1){
        var currentVatValue = vsForTable.getValue('stawka_vat');
        if(isFieldEmpty(currentVatValue))
            vssForTable.setValue(grid, index, 'stawka_vat', 'NP');
    }
}

function setDecreeNetAmountRowInReserveOnLoad(index, state){
    var vssForTable = ServiceFactory.getVariableSetService();
    var grid = vssForTable.get('tabela_dekretacji');

    var netAmountRecord = vssForTable.getValue(grid, index, 'kwota_netto_pozycji');
    var reserveAmountRecord = vssForTable.getValue(grid, index, 'kwota_rozwiazania_rezer');

    if( state == true && (reserveAmountRecord == 0 || reserveAmountRecord == ''))
        vssForTable.setValue(grid, index, 'kwota_rozwiazania_rezer', netAmountRecord);
    else
        vssForTable.setValue(grid, index, 'kwota_rozwiazania_rezer', 0);
}


function insertGrossValueInRowOnLoad(index, netValueInPLN){

    var vssForTable = ServiceFactory.getVariableSetService();
    var grid = vssForTable.get('tabela_dekretacji');

    var vatRate = vssForTable.getValue(grid, index, 'stawka_vat');
    vatRate = parseFloat(vatRate);

    if(!isNaN(vatRate)){
        var rate = vatRate / 100;
        var vatValue = netValueInPLN * rate;
        var grossValueInRow = netValueInPLN + vatValue;

        vssForTable.setValue(grid, index, 'kwota_brutto_pozycji_w', grossValueInRow.toFixed(2));
        vssForTable.setValue(grid, index, 'kwota_vat', vatValue.toFixed(2));
    }else{
        vssForTable.setValue(grid, index, 'kwota_brutto_pozycji_w', netValueInPLN.toFixed(2));
        vssForTable.setValue(grid, index, 'kwota_vat', 0);
    }
}

function updateDataInTable( store, record, operation, modifiedFieldNames, eOpts ) {
    if(modifiedFieldNames != null){
        var modifyColumnName = modifiedFieldNames[0];
        calculateNetAndGrossForRowUpdate(record, modifyColumnName);
    }
}

function calculateNetAndGrossForRowUpdate( record, modifyColumnName ){
    var vsForTable = ServiceFactory.getVariableService();
    var netValue = vsForTable.getValue('kwota_netto');

    if(isModifyName(modifyColumnName) && modifyColumnName.indexOf('kwota_netto_pozycji') > -1 && parseFloat(netValue) != 0){
        var currentNetValue = parseFloat(record.data.kwota_netto_pozycji);
        var procentage = (currentNetValue / netValue) * 100;

        if(!isNaN(procentage)){
            record.data.procent = procentage;
        }else{
            record.data.procent = 0;
        }
    }

    if(isModifyName(modifyColumnName) && modifyColumnName.indexOf('procent') > -1 && parseFloat(netValue) != 0){
        var currentProcentage = parseFloat(record.data.procent);

        if(!isNaN(currentProcentage)){
            var posNetValue = netValue * (currentProcentage / 100);
            record.data.kwota_netto_pozycji = posNetValue.toFixed(2);
        }
    }

    setNetAndGrossValuesByCurrency( record );
    refreshTableHeader();

}

function setTaxDateForRow( record ){
    var currentTaxDate = record.data.data_obowiazku_vat_pozy;
    if(isFieldEmpty(currentTaxDate))
        record.data.data_obowiazku_vat_pozy = variableService.getValue('data_obowiazku_vat');
}

function setDecreeSectionForRowInReserve( record ){
    var docCategory = variableService.getValue('kategoria_dokumentu');
    if(docCategory.indexOf('Rezerwy kosztowe' ) > -1){
        var currentRegistrySection = variableService.getValue('sekcja_rejestru');
        if(isFieldEmpty(currentRegistrySection))
            record.data.sekcja_rejestru = 'REZ';
    }
}

function setDecreeTaxForRowInReserve( record ){
    var docCategory = variableService.getValue('kategoria_dokumentu');
    if(docCategory.indexOf('Rezerwy kosztowe' ) > -1){
        var currentVatValue = variableService.getValue('stawka_vat');
        if(isFieldEmpty(currentVatValue))
            record.data.stawka_vat = 'NP';
    }
}

function setTaxDate( records ){
    var rowTaxDateId = 'data_obowiazku_vat_pozy';
    for( var i = 0 ; i < records.length ; i++ ){
        var record = records[i];
        var rowTaxDate = record.get(rowTaxDateId);
        if( rowTaxDate == null || rowTaxDate == '' ){
            var taxDate = variableService.getValue('data_obowiazku_vat');
            record.set(rowTaxDateId,taxDate);
        }
    }
}

function setDecreeRecordValuesForReserve( records ){
    for( var i = 0 ; i < records.length ; i++ ){
        var record = records[i];
        var docCategory = variableService.getValue('kategoria_dokumentu');
        if( docCategory == 'Rezerwy kosztowe' ){
            setDecreeRecordSectionForReserve(record);
            setDecreeRecordTaxForReserve(record);
        }
        var defaultSection = getDefaultSection();
        record.set('sekcja_rejestru',defaultSection);
    }
}

function setDecreeRecordSectionForReserve(record){
    var rowSectionId = 'sekcja_rejestru';
    var rowSection = record.get(rowSectionId);
    if( rowSection == null || rowSection == '' )
        record.set(rowSectionId,"REZ");
}

function setDecreeRecordTaxForReserve(record){
    var taxId = 'stawka_vat';
    var taxRecord = record.get(taxId);
    if( taxRecord == null || taxRecord == '' )
        record.set(taxId,'NP');
}

function refreshReserveColumnState(){
    var vss = ServiceFactory.getVariableSetService();
    var vs = ServiceFactory.getVariableService();

    var reserveField = vs.getValue('rezerwa');
    var grid = vss.get('tabela_dekretacji');

    if(grid.getId() != undefined && !isFieldEmpty(reserveField)){
        SuncodeFormService.suspendLayouts();
        try {
            setReserveValuesInColumn(true);
            vss.showColumn(grid, 'kwota_rozwiazania_rezer');
        }
        finally {
            SuncodeFormService.resumeLayouts();
        }

    }else if(grid.getId() != undefined){
        SuncodeFormService.suspendLayouts();
        try {
            vs.setValue('kwota_rozliczenia_rezer', '');
            vss.hideColumn(grid, 'kwota_rozwiazania_rezer');
            setReserveValuesInColumn(false);
        }
        finally {
            SuncodeFormService.resumeLayouts();
        }
    }

}

function setReserveValuesInColumn(state){
    var vssForTable = ServiceFactory.getVariableSetService();

    var grid = vssForTable.get('tabela_dekretacji');
    if(grid.getId() != undefined){
        var rowsCount = vssForTable.getRowsCount(grid);
        for(var index = 0; index < rowsCount; index++)
            setDecreeNetAmountRowInReserveOnLoad(index, state);
    }
}


function isModifyName(modify){
    if(modify == undefined || modify == null)
        return false;
    return true;
}


