var vsForFieldSetter;

SuncodeFormService.addOnReadyEvent(fieldSetterOnReady);

function fieldSetterOnReady(){
    vsForFieldSetter = ServiceFactory.getVariableService();
    var activityInfoService = ServiceFactory.getActivityInfoService();

    if (activityInfoService.getProcessDefId('dokumenty_k')) {
        vsForFieldSetter.addEvent('kategoria_dokumentu', 'blur', setFields);
        setOtherNumberFieldState();
        setReserveFieldState();
        setBookingMonth();
        setDateFieldState();
    }
}

function setFields(){
    setOtherNumberFieldState();
    setReserveFieldState();
    setDateFieldState();
    setBookingMonth();
}

function setBookingMonth(){
    var ais = ServiceFactory.getActivityInfoService();
    var activityDefId = ais.getActivityDefId();
    if(activityDefId.indexOf('opis_merytoryczny') > -1
        || activityDefId.indexOf('opis_ksiegowy') > -1){
        var docType = vsForFieldSetter.getValue('kategoria_dokumentu');
        if(docType.indexOf('Faktury proforma') > -1){
            vsForFieldSetter.hide('miesiac_ksiegowania');
        }else{
            vsForFieldSetter.show('miesiac_ksiegowania');
        }
    }
}

function setDateFieldState(){
    var docType = vsForFieldSetter.getValue('kategoria_dokumentu');
    if(docType.indexOf('Rezerwy kosztowe') > -1){
        vsForFieldSetter.hide('data_sprzedazy');
    }else{
        vsForFieldSetter.show('data_sprzedazy');
    }
}

function setOtherNumberFieldState(){
    var ais = ServiceFactory.getActivityInfoService();
    var activityDefId = ais.getActivityDefId();
    if(activityDefId.indexOf('rejestracja_dokumentu_k') > -1){
        var docType = vsForFieldSetter.getValue('kategoria_dokumentu');
        if(docType.indexOf('Rezerwy kosztowe') > -1){
            var otherNmb = vsForFieldSetter.getValue('numer_obcy');
            if(otherNmb.charAt(0) != 'R')
                vsForFieldSetter.setValue('numer_obcy', '');
            vsForFieldSetter.hide('numer_obcy');
        }

        else{
            vsForFieldSetter.show('numer_obcy');
        }

    }
}

function setReserveFieldState(){
    var ais = ServiceFactory.getActivityInfoService();
    var activityDefId = ais.getActivityDefId();
    var docType = vsForFieldSetter.getValue('kategoria_dokumentu');

    if(activityDefId.indexOf('opis_merytoryczny') > -1
        || activityDefId.indexOf('akceptacja_poziom_1_ese') > -1){
        if(docType.indexOf('Faktury spedycyjne') > -1
            || docType.indexOf('Koszty eksploatacyjne') > -1
            || docType.indexOf('Polisy ubezpieczeniowe') > -1){
            vsForFieldSetter.show('rezerwa');
            vsForFieldSetter.show('kwota_rozliczenia_rezer');
        }
        else{
            vsForFieldSetter.hide('rezerwa');
            vsForFieldSetter.hide('kwota_rozliczenia_rezer');
        }
    }else if(activityDefId.indexOf('opis_ksiegowy') > -1
        && docType.indexOf('Rezerwy kosztowe') > -1 ){
        vsForFieldSetter.hide('rezerwa');
        vsForFieldSetter.hide('kwota_rozliczenia_rezer');
    }

}