/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.documents.util.extensions;

import com.plusmpm.CUF.util.extension.InternalDataBase;
import com.plusmpm.util.DocumentData;
import com.suncode.cuf.mail.MailConfiguration;
import com.suncode.cuf.mail.MailContent;
import com.suncode.cuf.mail.MailSender;
import com.suncode.cuf.mail.SendReport;
import com.suncode.cuf.mail.SystemMailConfiguration;
import com.suncode.cuf.mail.TemplateMailContent;
import com.suncode.cuf.util.CufComponentFactory;
import com.suncode.plugin.jasfbgclient.documents.util.extensions.EmailTemplate;
import com.suncode.plugin.jasfbgclient.documents.util.extensions.P0063Tools;
import com.suncode.plugin.jasfbgclient.documents.util.extensions.config.Configuration;
import com.suncode.plugin.jasfbgclient.documents.util.extensions.config.DodanieDoArchiwumConfig;
import com.suncode.plugin.jasfbgclient.documents.util.extensions.config.GrupaDokumentow;
import com.suncode.plugin.jasfbgclient.documents.util.extensions.config.KlasaDokumentow;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.ActivityService;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class DocTools {
    private static Logger log = Logger.getLogger(DocTools.class);

    public static boolean checkDuplicate(String kod_kreskowy, long doc_class_id, long file_id, String id_kod_kreskowy, String idx_typ_dok) throws Exception {
        String query = "SELECT 1 as jeden FROM pm_idx000@docClassId@ WHERE @idIdxNrEwid@ = '@nrEwid@' AND fileid != '@fileId@' AND @idIdxTypDok@ = 'Dokument g\u0142\u00f3wny'";
        query = query.replace("@docClassId@", String.valueOf(doc_class_id)).replace("@idIdxNrEwid@", id_kod_kreskowy).replace("@nrEwid@", kod_kreskowy).replace("@fileId@", String.valueOf(file_id)).replace("@idIdxTypDok@", idx_typ_dok);
        SQLFinder finder = FinderFactory.getSQLFinder();
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery(query);
        builder.addScalar("jeden", (Type)StandardBasicTypes.STRING);
        List results_duplikaty = finder.find(builder);
        if (results_duplikaty != null && !results_duplikaty.isEmpty()) {
            log.debug((Object)("Duplikat kodu: " + kod_kreskowy + " w class doc " + doc_class_id));
            return true;
        }
        return false;
    }

    public static KlasaDokumentow pobierzKonfiguracjeKlasyDokumentow(String nazwa_grupy, long doc_class_id) throws Exception {
        log.debug((Object)("nazwa_grupy: " + nazwa_grupy + ", doc_class_id: " + doc_class_id));
        DodanieDoArchiwumConfig config = Configuration.odczytajConfig();
        Map<String, GrupaDokumentow> grupy_dokumentow = config.getGrupy_dokumentow();
        if (grupy_dokumentow == null) {
            throw new Exception("Brak grup dokumentow w pliku konfiguracyjnym");
        }
        GrupaDokumentow grupa_dokumentow = grupy_dokumentow.get(nazwa_grupy);
        if (grupa_dokumentow == null) {
            throw new Exception("Brak grupy dokumentow dla podanej nazwy w pliku konfiguracyjnym");
        }
        KlasaDokumentow klasa_dokumentow = grupa_dokumentow.getKlasy_dokumentow().get(doc_class_id);
        if (klasa_dokumentow == null) {
            throw new Exception("Brak klasy dokumentow dla podanego doc id w pliku  konfiguracyjnym");
        }
        return klasa_dokumentow;
    }

    public static Map<String, String> pobierzDaneIndeksowPliku(Connection conn, long doc_class_id, long file_id) throws Exception {
        String query = "SELECT DISTINCT * FROM pm_idx000@docClassId@ WHERE fileid = '@fileId@'";
        query = query.replace("@docClassId@", String.valueOf(doc_class_id)).replace("@fileId@", String.valueOf(file_id));
        return InternalDataBase.executeOneResultQuery((Connection)conn, (String)query);
    }

    public static String zmienKodKresowyZgrupuj(String kod_kreskowy, String regexp, String replace_group) {
        try {
            log.debug((Object)("kod: " + kod_kreskowy + ", regexp: " + regexp + ", replace_group: " + replace_group));
            Pattern p = Pattern.compile(regexp);
            Matcher m = p.matcher(kod_kreskowy);
            if (m.find()) {
                String output = m.replaceAll(replace_group);
                log.debug((Object)("nowy kod_kreskowy: " + output));
                kod_kreskowy = output.trim();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return kod_kreskowy;
    }

    public static void usunDokumentZBazyIDysku(DocumentData dd) {
        log.debug((Object)("usunDokumentZBazyIDysku(" + dd.getLDocClassId() + "," + dd.getLFileId() + ")"));
        DocumentService documentService = ServiceFactory.getDocumentService();
        WfDocument wf = documentService.getDocument(Long.valueOf(dd.getLFileId()));
        documentService.deleteAllDocumentVersions(wf);
        log.debug((Object)("usunDokumentZBazyIDysku(" + dd.getLDocClassId() + "," + dd.getLFileId() + ") OK"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wyslijPowiadomienie(String typ_grupy, long file_id, String placowka, String reason, Map<String, String> dane_do_powiadomien, String nazwa_klasy_dokumentow) {
        block9: {
            try {
                log.debug((Object)("wyslijPowiadomienie: typ_grupy: " + typ_grupy + ", placowka: " + placowka + ", file_id " + file_id + ", reason: " + reason));
                String emailAddress = P0063Tools.getEmailAdresForDepartment(placowka);
                ArrayList<String> emails = new ArrayList<String>();
                emails.add(emailAddress);
                if (emailAddress == null || emailAddress.length() <= 0) {
                    log.info((Object)("Dla jednostki " + placowka + " nie znaleziono adresu email. Powiadomienie o archiwizacji nie zostanie wys\u0142ane"));
                    break block9;
                }
                EmailTemplate emailTemplate = P0063Tools.getEmailTemplate(typ_grupy, reason);
                if (emailTemplate == null) break block9;
                MailSender sender = CufComponentFactory.getMailSender();
                SystemMailConfiguration cfg = SystemMailConfiguration.getInstance();
                TemplateMailContent content = new TemplateMailContent();
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                tempMap.putAll(dane_do_powiadomien);
                String docId_encoded = new String(Base64.encodeBase64((byte[])String.valueOf(file_id).getBytes("UTF-8")), "UTF-8");
                tempMap.put("klasa", nazwa_klasy_dokumentow);
                String link = "<A href=\"" + SystemProperties.getString((String)"HTTPLink") + "/ShowFile.do?fileName=" + docId_encoded + "\">Poka\u017c plik</A>";
                tempMap.put("link", link);
                content.setSubject(emailTemplate.getEmailSubject());
                content.setTemplatePath(emailTemplate.getEmailTemplatePath());
                content.setVariables(tempMap);
                SendReport report = new SendReport();
                if (reason.compareTo("ARCHIWIZACJA_BRAK_KODU") == 0) {
                    FileService fileService = ServiceFactory.getFileService();
                    WfFile file = fileService.getFile(Long.valueOf(file_id), new String[]{"documentClass"});
                    ArrayList<String> files = new ArrayList<String>();
                    files.add(file.getFullPath());
                    log.debug((Object)("Wiadomosc z zalacznikiem o nazwie: " + file.getFileName()));
                    content.addAttachment(file.getFileName(), file.getFullPath());
                }
                ClassLoader previousContextClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(ActivityService.class.getClassLoader());
                    report = sender.send((MailConfiguration)cfg, (MailContent)content, emails);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(previousContextClassLoader);
                }
                if (report.getFailedEmails() == null || report.getFailedEmails().isEmpty()) {
                    log.debug((Object)("Poprawnie wys\u0142ano maila do u\u017cytkownika " + emailAddress + " o temacie: " + emailTemplate.getEmailSubject()));
                } else {
                    log.info((Object)("Nie uda\u0142o si\u0119 wys\u0142a\u0107 maila do u\u017cytkownika " + emailAddress + " o temacie: " + emailTemplate.getEmailSubject()));
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static String getIndexByName(Connection conn, long doc_class, String index_name) throws Exception {
        String query = "SELECT indexorderid FROM pm_idx000@docClassId@ WHERE indexname = '@name@'";
        HashMap results_index = InternalDataBase.executeOneResultQuery((Connection)conn, (String)(query = query.replace("@docClassId@", String.valueOf(doc_class)).replace("@name@", index_name)));
        if (results_index != null && !results_index.isEmpty()) {
            return (String)results_index.get("indexorderid");
        }
        return null;
    }

    public static void wyprintujIndeksyDoLoga(Map<String, String> indecies) {
        log.debug((Object)"Printing indices");
        for (String k : indecies.keySet()) {
            log.debug((Object)("key: " + k + ", value: " + indecies.get(k)));
        }
    }
}

