/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.costdocuments.setters;

import com.plusmpm.database.DocumentTemplateTable;
import com.suncode.cuf.mail.MailConfiguration;
import com.suncode.cuf.mail.MailContent;
import com.suncode.cuf.mail.MailSender;
import com.suncode.cuf.mail.SystemMailConfiguration;
import com.suncode.cuf.mail.TemplateMailContent;
import com.suncode.cuf.util.CufComponentFactory;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.archive.DocumentTemplateService;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClientMailSender {
    private static Logger log = Logger.getLogger(ClientMailSender.class);
    private MailConfiguration mailConfiguration = SystemMailConfiguration.getInstance();
    private String sSubject;
    private String sTemplatePath;
    private String sProcessId;
    private String sCustHistoryLink;
    private List<String> lAttachmentPaths = new ArrayList<String>();
    private List<String> lMailAdresses = null;
    private Map<String, String> mMailValues = null;

    public void setiMailAdresses(List<String> iMailAdresses) {
        this.lMailAdresses = iMailAdresses;
    }

    public void setlAttachmentPaths(List<String> lAttachmentPaths) {
        this.lAttachmentPaths = lAttachmentPaths;
    }

    public void setmExtraMailValues(Map<String, String> mExtraMailValues) {
        if (mExtraMailValues != null) {
            for (String sKey : mExtraMailValues.keySet()) {
                this.mMailValues.put(sKey, mExtraMailValues.get(sKey));
            }
        }
    }

    public ClientMailSender(List<String> iUserIds, String sSubject, String sTemplateTableMailName, String sProcessId) throws Exception {
        log.debug((Object)"Rozpoczynam konstruowanie obiektu");
        this.sSubject = sSubject;
        this.sProcessId = sProcessId;
        this.lMailAdresses = ClientMailSender.getEmailsByUsersIds(iUserIds);
        this.sTemplatePath = this.getPathByDocumentTemplateTableName(sTemplateTableMailName);
        this.mMailValues = this.getmMailValuesFormProcess(sProcessId);
        this.sCustHistoryLink = this.getHistoryProcessLink();
    }

    private static List<String> getEmailsByUsersIds(List<String> userIds) {
        ArrayList<String> usersMails = new ArrayList<String>();
        UserFinder userFinder = FinderFactory.getUserFinder();
        for (String userId : userIds) {
            User user = userFinder.findByUserName(userId, new String[0]);
            if (user == null) continue;
            usersMails.add(user.getEmail());
        }
        return usersMails;
    }

    private String getPathByDocumentTemplateTableName(String documentTeamplateTableName) throws Exception {
        DocumentTemplateService documentTemplateService = ServiceFactory.getDocumentTemplateService();
        DocumentTemplateTable dtt = documentTemplateService.getByName(documentTeamplateTableName, new String[0]);
        if (dtt != null) {
            return dtt.getTemplatePath();
        }
        throw new Exception("Szablon o nazwie " + documentTeamplateTableName + " nie istnieje");
    }

    private Map<String, String> getmMailValuesFormProcess(String sProcessId) {
        ProcessService processService = ServiceFactory.getProcessService();
        Map mObjectProcessMap = processService.getProcessContext(sProcessId);
        Map<String, String> mStringProcessMap = ClientMailSender.parseToMapStringValues(mObjectProcessMap);
        return mStringProcessMap;
    }

    public void setHistoryActivityLinkToProcess(String ... sActivityDefIds) {
        Activity lastActivity = null;
        for (String sActivityDefId : sActivityDefIds) {
            lastActivity = this.getLastActivityByProcesIdAndActivityDefinitionId(sActivityDefId);
            if (lastActivity == null) continue;
            this.sCustHistoryLink = this.getHistoryActivityLink(lastActivity.getActivityId());
            break;
        }
    }

    private Activity getLastActivityByProcesIdAndActivityDefinitionId(String sActivityDefId) {
        ActivityFinder activityFinder = FinderFactory.getActivityFinder();
        List activitis = activityFinder.findByProcessId(this.sProcessId, new String[0]);
        Activity result = null;
        for (Activity activity : activitis) {
            if (result == null && activity.getActivityDefinitionId().equals(sActivityDefId)) {
                result = activity;
                continue;
            }
            if (!activity.getActivityDefinitionId().equals(sActivityDefId) || result.getStartedTime().getTime() >= activity.getStartedTime().getTime()) continue;
            result = activity;
        }
        return result;
    }

    private String getHistoryActivityLink(String sActivityId) {
        Object result = SystemProperties.getString((String)"HTTPLink");
        result = (String)result + "/ShowDetailHistory.do?ProcessId=" + this.sProcessId + "&histActivityId=" + sActivityId;
        result = "<a LINK href=\"" + (String)result + "\">Szczeg\u00f3\u0142y</a>";
        return result;
    }

    private String getHistoryProcessLink() {
        Object result = SystemProperties.getString((String)"HTTPLink");
        result = (String)result + "/ShowProcessHistory.do?ProcessId=" + this.sProcessId;
        result = "<a LINK href=\"" + (String)result + "\">Szczeg\u00f3\u0142y</a>";
        return result;
    }

    private void logMailValues() {
        log.debug((Object)("sSubject: " + this.sSubject));
        log.debug((Object)("sTemplatePath: " + this.sTemplatePath));
        log.debug((Object)("sProcessId: " + this.sProcessId));
        log.debug((Object)("sSubject: " + this.sSubject));
        this.logListValues("lAttachmentPaths", this.lAttachmentPaths);
        this.logListValues("iMailAdresses", this.lMailAdresses);
    }

    private void logListValues(String sName, List<String> lToDisplay) {
        if (lToDisplay == null) {
            log.debug((Object)(sName + ": null"));
        } else {
            StringBuffer sbLogResult = new StringBuffer(sName + ": ");
            for (String value : lToDisplay) {
                sbLogResult.append(" " + value);
            }
            log.debug((Object)sbLogResult.toString());
        }
    }

    public static Map<String, String> parseToMapStringValues(Map<String, Object> toParse) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String id : toParse.keySet()) {
            result.put(id, toParse.get(id).toString());
        }
        return result;
    }

    public void sendMessages() throws Exception {
        log.debug((Object)"Rozpoczynam wysy\u0142anie wiadomo\u015bci");
        this.logMailValues();
        try {
            this.mMailValues.put("custHistoryLink", this.sCustHistoryLink);
            log.debug((Object)"Rozpoczyname wysy\u0142anie wiadomo\u015bci");
            TemplateMailContent content = new TemplateMailContent();
            content.setAttachments(this.lAttachmentPaths);
            content.setSubject(this.sSubject);
            content.setTemplatePath(this.sTemplatePath);
            content.setVariables(this.mMailValues);
            MailSender mailSender = CufComponentFactory.getMailSender();
            mailSender.send(this.mailConfiguration, (MailContent)content, this.lMailAdresses);
            log.debug((Object)"Wiadomoci zosta\u0142y wys\u0142ane");
        }
        catch (Exception ex) {
            log.error((Object)"Nie poiod\u0142o si\u0119 wysy\u0142anie wiadomo\u015bci");
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

