/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.costdocuments.servlets;

import com.suncode.plugin.jasfbgclient.costdocuments.services.AcceptDefinitionService;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.util.FinderFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/custom/servlet"})
public class DefaultAcceptGetter {
    private static Logger log = Logger.getLogger(DefaultAcceptGetter.class);

    @RequestMapping(value={"getDefaultAcceptI"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getDefaultAcceptI(@RequestParam String documentCategory, @RequestParam String documentType, @RequestParam String meritUserName) {
        String idFirma;
        List<User> acceptUsers;
        HashMap<String, String> result = new HashMap<String, String>();
        Set<String> userSuperiors = this.getUserSuperiors(meritUserName);
        List<User> acceptSuperiors = this.getUserInList(userSuperiors, acceptUsers = this.getAcceptByLevel(documentCategory, documentType, idFirma = "1"));
        if (acceptSuperiors.size() == 1) {
            User meritSuperior = acceptSuperiors.get(0);
            result.put("fullName", meritSuperior.getFirstName() + " " + meritSuperior.getLastName());
            result.put("userName", meritSuperior.getUserName());
        }
        return result;
    }

    private List<User> getAcceptByLevel(String documentCategory, String documentType, String idFirma) {
        AcceptDefinitionService ads = new AcceptDefinitionService(documentCategory, documentType, idFirma, "A1", "A2");
        List<User> acceptUsers = ads.getUserAcceptList();
        return acceptUsers;
    }

    private Set<String> getUserSuperiors(String userName) {
        PositionFinder positionFinder = FinderFactory.getPositionFinder();
        List userPositions = positionFinder.findByUserName(userName, new String[]{"organizationalUnit"});
        HashSet<String> directorNamesList = new HashSet<String>();
        for (Position position : userPositions) {
            String directorPositionName = this.getOuDirectorByPosition(position);
            if (directorPositionName.isEmpty()) continue;
            directorNamesList.add(directorPositionName);
        }
        log.debug((Object)("directorNamesList: " + directorNamesList));
        return directorNamesList;
    }

    private List<User> getUserInList(Set<String> searchUsers, List<User> listToSearch) {
        UserFinder uf = FinderFactory.getUserFinder();
        ArrayList<User> result = new ArrayList<User>();
        for (String userName : searchUsers) {
            User user = uf.findByUserName(userName, new String[0]);
            boolean isSuperioeInAcceptList = this.isUserInUserList(user, listToSearch);
            if (!isSuperioeInAcceptList) continue;
            result.add(user);
        }
        return result;
    }

    private String getOuDirectorByPosition(Position position) {
        PositionFinder pf;
        User director;
        OrganizationalUnit organizationalUnitWithDirector;
        Position directorPosition;
        OrganizationalUnitFinder ouf = FinderFactory.getOrganizationalUnitFinder();
        OrganizationalUnit organizationalUnit = position.getOrganizationalUnit();
        if (organizationalUnit != null && (directorPosition = (organizationalUnitWithDirector = ouf.findBySymbol(organizationalUnit.getSymbol(), new String[]{"directorPosition"})).getDirectorPosition()) != null && (director = (directorPosition = (pf = FinderFactory.getPositionFinder()).findBySymbol(organizationalUnitWithDirector.getDirectorPosition().getSymbol(), new String[]{"user"})).getUser()) != null) {
            return director.getUserName();
        }
        return "";
    }

    private boolean isUserInUserList(User user, List<User> userList) {
        boolean result = false;
        for (User userFromList : userList) {
            if (!user.getUserName().equals(userFromList.getUserName())) continue;
            result = true;
            break;
        }
        return result;
    }
}

