/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.costdocuments.booking;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.suncode.dbexplorer.DatabaseExplorer;
import com.suncode.dbexplorer.database.Database;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.plugin.jasfbgclient.costdocuments.booking.ClientProcedureGenerator;
import com.suncode.plugin.jasfbgclient.costdocuments.booking.JasFbgSpringContext;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BookInOracle {
    private String invoiceOracleNo = "";
    private String reserveOracleNo = "";
    private String formInvoiceOraclId;
    private String formReserveOraclId;
    public Logger log = Logger.getLogger(BookInOracle.class);
    private static final String[] decrreColumnIds = new String[]{"sekcja_rejestru", "kwota_brutto_pozycji_w", "kwota_netto_pozycji_w_p", "kwota_vat", "opis_pozycji", "stawka_vat", "nr_zlecenia", "typ_pozycji", "data_obowiazku_vat_pozy", "kwota_netto_pozycji", "kwota_rozwiazania_rezer", "mpk", "nr_teczki", "nr_pojazdu", "kod_pojazdu", "nr_pracownik", "rozrachunek_na", "rodzaj_paliwa", "ilosc_paliwa", "konto_ks_dla_lea", "kurs_hist_dla_lea_2"};
    private static final String SET_COMPANY_PROC = "{ CALL EAADM.EAP_GLOBALS.USTAW_FIRME(:firma) }";
    private static final String SET_CONSL_PROC = "{ CALL EAADM.EAP_GLOBALS.USTAW_KONSOLIDACJE() }";
    private static final String NADAJ_NUMER = "{ ? = call DMS.EGERIA_API_DOKUMENT.NADAJ_NUMER(?, ?) }";

    public String getInvoiceOracleNo() {
        return this.invoiceOracleNo;
    }

    public String getReserveOracleNo() {
        return this.reserveOracleNo;
    }

    public String getFormInvoiceOraclId() {
        return this.formInvoiceOraclId;
    }

    public String getFormReserveOraclId() {
        return this.formReserveOraclId;
    }

    public void bookByProcessContextMap(Map<String, Object> processContext) throws Exception {
        try {
            this.setContextValuesForInvoice(processContext);
            ClientProcedureGenerator formBookingProcedure = this.getFormBookingProcedure(processContext);
            List<ClientProcedureGenerator> decreeBookingProcedure = this.getDecreeBookingProcedure(processContext);
            boolean InvoiceIsConnectWithReserve = this.checkInvoiceIsConnectWithReserve(processContext);
            ClientProcedureGenerator formReserveBookingProcedure = null;
            List<Object> decreeReserveBookingProcedure = new ArrayList();
            if (InvoiceIsConnectWithReserve) {
                this.setContexValuesForReserve(processContext);
                formReserveBookingProcedure = this.getFormBookingProcedure(processContext);
                decreeReserveBookingProcedure = this.getDecreeBookingProcedure(processContext);
            }
            DatabaseExplorer databaseExplorer = JasFbgSpringContext.getBean(DatabaseExplorer.class);
            Database database = databaseExplorer.get("JAS FBG");
            ClientProcedureGenerator finalFormReserveBookingProcedure = formReserveBookingProcedure;
            List<Object> finalDecreeReserveBookingProcedure = decreeReserveBookingProcedure;
            database.withinSession(session -> {
                this.exceuteProcedureInOracle(formBookingProcedure, decreeBookingProcedure, finalFormReserveBookingProcedure, finalDecreeReserveBookingProcedure, processContext, session);
                return true;
            });
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            String sUserError = this.getUserErrorFromOracleError(ex.getMessage());
            throw new Exception(sUserError);
        }
    }

    private Map<String, Object> convertToObjectMap(Map<String, String> mapToConvert) {
        HashMap<String, Object> convertResult = new HashMap<String, Object>();
        for (String key : mapToConvert.keySet()) {
            String obj = mapToConvert.get(key);
            convertResult.put(key, obj);
        }
        return convertResult;
    }

    private String getUserErrorFromOracleError(String oracleError) {
        String result = oracleError;
        try {
            String[] orcleByLineSplit = oracleError.split("\\r?\\n");
            result = orcleByLineSplit[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private void setContextValuesForInvoice(Map<String, Object> processContext) {
        Double nettoByDecree = this.getDecreeColumnSumColumnSumByColumnId(processContext, "kwota_netto_pozycji_w_p");
        processContext.put("kwota_netto", nettoByDecree);
        Double taxByDecree = this.getDecreeColumnSumColumnSumByColumnId(processContext, "kwota_vat");
        processContext.put("kwota_podatek", taxByDecree);
        Double bruttoByDecree = this.getDecreeColumnSumColumnSumByColumnId(processContext, "kwota_brutto_pozycji_w");
        processContext.put("kwota_brutto", bruttoByDecree);
        this.setVehicleCodesByVehicleNo(processContext);
    }

    private void setContexValuesForReserve(Map<String, Object> processContext) {
        processContext.put("kod_klienta", "9999999");
        processContext.put("numer_wlasny", "");
        Double nettoReserveByDecree = this.getDecreeColumnSumColumnSumByColumnId(processContext, "kwota_rozwiazania_rezer");
        nettoReserveByDecree = Math.abs(nettoReserveByDecree) * -1.0;
        processContext.put("kwota_netto", nettoReserveByDecree);
        processContext.put("kwota_brutto", nettoReserveByDecree);
        processContext.put("kwota_podatek", "0.0");
        String npTaxValue = this.getNPTaxValue(processContext);
        processContext.put("stawka_vat", npTaxValue);
        String reserveDescription = this.getReserveDescription(processContext);
        processContext.put("opis_dokumentu", reserveDescription);
        String foreignNo = (String)processContext.get("rezerwa");
        processContext.put("numer_obcy", foreignNo);
        this.removeFromContextPositionWithZeroReserve(processContext);
        this.setDecreeReserveAsDecreeAmount(processContext);
        this.setRejSectionForReserve(processContext);
        String documentType = this.getReserveTypeByRezerwNo(processContext);
        processContext.put("rodzaj_dokumentu", documentType);
        processContext.put("waluta", "PLN");
        processContext.put("kurs_waluty", "1.0");
    }

    private Double getDecreeColumnSumColumnSumByColumnId(Map<String, Object> processContext, String columnId) {
        List<Map<String, String>> decreeRecords = this.getDecreeRecords(processContext);
        BigDecimal sum = new BigDecimal(0);
        sum.setScale(2, 5);
        BigDecimal lineValue = null;
        for (Map<String, String> line : decreeRecords) {
            if (line.get(columnId).isEmpty()) continue;
            lineValue = new BigDecimal(line.get(columnId));
            lineValue.setScale(2, 5);
            sum = sum.add(lineValue);
        }
        sum.setScale(2, 5);
        Double result = sum.doubleValue();
        this.log.debug((Object)("Counted sum for id: " + columnId + " has value: " + result));
        return result;
    }

    private void setVehicleCodesByVehicleNo(Map<String, Object> processContext) {
        List<Map<String, String>> decreeRecords = this.getDecreeRecords(processContext);
        for (Map<String, String> record : decreeRecords) {
            String vehicleCode = record.get("kod_pojazdu");
            this.log.debug((Object)("vehicleCode: " + vehicleCode));
            if (vehicleCode == null || vehicleCode.isEmpty()) continue;
            record.put("nr_pojazdu", vehicleCode);
        }
        this.convertToProcessContextAndAdd(processContext, decreeRecords);
    }

    private String getNPTaxValue(Map<String, Object> processContext) {
        List<Map<String, String>> decreeRecords = this.getDecreeRecords(processContext);
        int decreeSize = decreeRecords.size();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < decreeSize; ++i) {
            if (result.length() != 0) {
                result.append(";");
            }
            result.append("NP");
        }
        return result.toString();
    }

    private String getReserveDescription(Map<String, Object> processContext) {
        String invoiceNo = (String)processContext.get("numer_obcy");
        invoiceNo = invoiceNo.toUpperCase();
        return "Rozwi\u0105zanie dokumentem nr " + invoiceNo;
    }

    private void removeFromContextPositionWithZeroReserve(Map<String, Object> processContext) {
        List<Map<String, String>> decreeRecords = this.getDecreeRecords(processContext);
        ArrayList<Map<String, String>> decreeRecordsWuthoutZeroReserve = new ArrayList<Map<String, String>>();
        for (Map<String, String> record : decreeRecords) {
            boolean reserveIsZero = this.checkReserveIsZero(record);
            if (reserveIsZero) continue;
            decreeRecordsWuthoutZeroReserve.add(record);
        }
        processContext = this.convertToProcessContextAndAdd(processContext, decreeRecordsWuthoutZeroReserve);
    }

    private boolean checkReserveIsZero(Map<String, String> record) {
        String reserveCellValue = record.get("kwota_rozwiazania_rezer");
        boolean reserveIsZero = false;
        if (reserveCellValue.isEmpty()) {
            reserveIsZero = true;
        } else {
            try {
                Double dReserveCellValue = Double.valueOf(reserveCellValue);
                if (dReserveCellValue.compareTo(0.0) == 0) {
                    reserveIsZero = true;
                }
            }
            catch (Exception ex) {
                reserveIsZero = true;
            }
        }
        return reserveIsZero;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDecreeReserveAsDecreeAmount(Map<String, Object> processContext) {
        this.log.debug((Object)"setDecreeReserveAsDecreeAmount");
        List<Map<String, String>> decreeRecords = this.getDecreeRecords(processContext);
        for (int i = 0; i < decreeRecords.size(); ++i) {
            Map<String, String> record = decreeRecords.get(i);
            String sKwotaRozRez = "0";
            try {
                this.log.debug((Object)("record.get(kwota_rozwiazania_rezer): " + record.get("kwota_rozwiazania_rezer")));
                Double kwotaRozRez = Double.valueOf(record.get("kwota_rozwiazania_rezer"));
                kwotaRozRez = Math.abs(kwotaRozRez) * -1.0;
                sKwotaRozRez = this.convertDoubleToString(kwotaRozRez);
                this.log.debug((Object)("sKwotaRozRez: " + sKwotaRozRez));
                continue;
            }
            catch (Exception ex) {
                this.log.error((Object)ex.getMessage(), (Throwable)ex);
                continue;
            }
            finally {
                record.put("kwota_netto_pozycji_w_p", sKwotaRozRez);
                record.put("kwota_brutto_pozycji_w", sKwotaRozRez);
                record.put("kwota_vat", "0");
                record.put("kwota_netto_pozycji", sKwotaRozRez);
            }
        }
        processContext = this.convertToProcessContextAndAdd(processContext, decreeRecords);
    }

    private String convertDoubleToString(Double valueToConvert) {
        String result = String.valueOf(new DecimalFormat("#.##").format(valueToConvert));
        result = result.replace(",", ".");
        return result;
    }

    private Map<String, Object> convertToProcessContextAndAdd(Map<String, Object> processContext, List<Map<String, String>> records) {
        Map recordsMPMFormat = DynamicTableFunctions.convertFromListOfMapsToMap(records, (String[])decrreColumnIds);
        for (String key : recordsMPMFormat.keySet()) {
            processContext.put(key, recordsMPMFormat.get(key));
        }
        return processContext;
    }

    private void setRejSectionForReserve(Map<String, Object> processContext) {
        List<Map<String, String>> decreeRecords = this.getDecreeRecords(processContext);
        for (Map<String, String> record : decreeRecords) {
            record.put("sekcja_rejestru", "REZ");
        }
        processContext = this.convertToProcessContextAndAdd(processContext, decreeRecords);
    }

    private String getReserveTypeByRezerwNo(Map<String, Object> processContext) {
        String result = "";
        String reserveType = (String)processContext.get("rodzaj_dokumentu");
        String reserveNo = (String)processContext.get("rezerwa");
        this.log.debug((Object)("reserveType: " + reserveType + " reserveNo: " + reserveNo));
        if (!reserveNo.isEmpty() && reserveNo.length() > 4) {
            result = reserveNo.substring(0, 5);
        }
        this.log.debug((Object)("result: " + result));
        return result;
    }

    private ClientProcedureGenerator getFormBookingProcedure(Map<String, Object> processContext) {
        ClientProcedureGenerator cpg = new ClientProcedureGenerator(ClientProcedureGenerator.ProcedurName.WST_DOKUMENT, processContext);
        String correctionOfInvoicesMark = this.getCorrectionOfInvoicesMark(processContext);
        String platnosc = (String)processContext.get("forma_platnosci");
        this.log.debug((Object)("wartosc zmiennej przelew przed:" + platnosc + ";"));
        cpg.addValue("P_DOK_F_KOREKTA", correctionOfInvoicesMark, "'");
        cpg.addValue("P_DOK_NUMER_PACZKI ", "", "'");
        cpg.addByIdAsDate("P_DOK_DATA_WYSTAWIENIA", "data_wystawienia");
        cpg.addByIdAsDate("P_DOK_DATA_OPERACJI", "data_sprzedazy");
        cpg.addByIdAsDate("P_DOK_DATA_WYSLANIA", "data_wplywu");
        cpg.addByIdAsDate("P_DOK_TERMIN_ZAPLATY", "termin_zaplaty");
        cpg.addByIdAsNo("P_DOK_NETTO", "kwota_netto");
        cpg.addByIdAsNo("P_DOK_PODATEK", "kwota_podatek");
        cpg.addByIdAsNo("P_DOK_KWOTA", "kwota_brutto");
        cpg.addByIdAsString("P_DOK_WALUTA", "waluta");
        cpg.addByIdAsNo("P_DOK_KURS", "kurs_waluty");
        cpg.addByIdAsString("P_DOK_RDOK_KOD", "rodzaj_dokumentu");
        cpg.addByIdAsString("P_DOK_OPIS", "opis_dokumentu");
        this.setOwnNo(processContext, cpg);
        String foreignNo = this.getForeignNo(processContext);
        cpg.addValue("P_DOK_NUMER_OBCY", foreignNo, "'");
        String clientCode = this.getClientCode(processContext, cpg);
        cpg.addValueAsLong("P_DOK_KL_KOD_POD", new Long(clientCode));
        if (platnosc.compareTo("Przelew") == 0) {
            cpg.addValue("P_DOK_SPOSOB_ZAPLATY", "1", "'");
            this.log.debug((Object)("warunek prawidlowy, wartosc zmiennej przelew:" + platnosc + ";"));
        } else {
            cpg.addValue("P_DOK_SPOSOB_ZAPLATY", "2", "'");
            this.log.debug((Object)("warunek fa\u0142szywy, wartosc zmiennej przelew:" + platnosc + ";"));
        }
        cpg.addByIdAsString("P_DOK_NUMER_KOR", "nr_dokumentu_pierwotneg");
        String bookingDate = this.getBookingDate(processContext);
        cpg.addDateValue("P_DOK_DATA_ZAKSIEGOWANIA", bookingDate);
        cpg.addNullValue("P_DEF_0");
        cpg.addNullValue("P_DEF_1");
        cpg.addNullValue("P_DEF_2");
        cpg.addNullValue("P_DEF_3");
        cpg.addNullValue("P_DEF_4");
        cpg.addNullValue("P_DEF_5");
        cpg.addNullValue("P_DEF_6");
        cpg.addNullValue("P_DEF_7");
        cpg.addNullValue("P_DEF_8");
        cpg.addNullValue("P_DEF_9");
        cpg.addNullValue("P_PRC_ID_POD");
        cpg.addByIdAsDate("P_DOK_DOV", "data_obowiazku_vat");
        cpg.addByIdAsLong("P_ADR_ID", "identyfikator_adresu");
        cpg.logProcedure();
        return cpg;
    }

    private String getCorrectionOfInvoicesMark(Map<String, Object> processContext) {
        String result = "N";
        String documentkorygujacy = (String)processContext.get("dokument_korygujacy");
        if (documentkorygujacy.equalsIgnoreCase("TAK")) {
            result = "T";
        }
        return result;
    }

    private void setOwnNo(Map<String, Object> processContext, ClientProcedureGenerator cpg) {
        String ownNoOracleId = "P_DOK_NUMER_WLASNY";
        String ownNoPWId = "numer_wlasny";
        String ownNo = (String)processContext.get(ownNoPWId);
        if ((ownNo = ownNo.trim()).isEmpty()) {
            cpg.addValue(ownNoOracleId, "NULL", "");
        } else {
            cpg.addByIdAsString(ownNoOracleId, ownNoPWId);
        }
    }

    private String getForeignNo(Map<String, Object> processContext) {
        String foreignNo = (String)processContext.get("numer_obcy");
        return foreignNo.toUpperCase();
    }

    private String getClientCode(Map<String, Object> processContext, ClientProcedureGenerator cpg) {
        String documentType = (String)processContext.get("kategoria_dokumentu");
        String clientCode = (String)processContext.get("kod_klienta");
        if (documentType.equals("Rezerwy kosztowe")) {
            clientCode = "9999999";
        }
        return clientCode;
    }

    private String getBookingDate(Map<String, Object> processContext) {
        String bookingMonth = (String)processContext.get("miesiac_ksiegowania");
        this.log.debug((Object)("Wartosc w polu miesiac ksiegowania: " + bookingMonth));
        boolean currnetMonth = this.isCurrentMonth(bookingMonth);
        String result = "";
        result = currnetMonth ? this.getISOCurrentDate() : this.getISOBoockingDateByBookingMonth(bookingMonth);
        this.log.debug((Object)("Zwrocona do procedury ksiegujacej wartosc: " + result));
        return result;
    }

    private boolean isCurrentMonth(String bookingMonth) {
        Calendar currentDate = Calendar.getInstance();
        Calendar cBookinMonth = this.getCalendarFormBookingMonthValue(bookingMonth);
        return currentDate.get(2) == cBookinMonth.get(2) && currentDate.get(1) == currentDate.get(1);
    }

    private String getISOBoockingDateByBookingMonth(String bookingMonth) {
        Calendar cBookingMonth = this.getCalendarFormBookingMonthValue(bookingMonth);
        this.log.debug((Object)("cBookingMonth " + cBookingMonth.getTime().toString()));
        cBookingMonth.add(2, 1);
        cBookingMonth.add(5, -1);
        this.log.debug((Object)("after set days: cBookingMonth " + cBookingMonth.getTime().toString()));
        return this.getIsoStringDate(cBookingMonth);
    }

    private Calendar getCalendarFormBookingMonthValue(String bookingMonth) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM.yyyy");
        Calendar cBookinMonth = Calendar.getInstance();
        try {
            cBookinMonth.setTime(sdf.parse(bookingMonth));
        }
        catch (ParseException ex) {
            this.log.error((Object)("Nie powiod\u0142a si\u0119 konwersja daty: " + bookingMonth));
        }
        return cBookinMonth;
    }

    private String getISOCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        return this.getIsoStringDate(calendar);
    }

    private String getIsoStringDate(Calendar calendar) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(calendar.getTime());
    }

    private List<ClientProcedureGenerator> getDecreeBookingProcedure(Map<String, Object> processContext) {
        int recordNo = 1;
        ArrayList<ClientProcedureGenerator> decreeBookingProcedure = new ArrayList<ClientProcedureGenerator>();
        List<Map<String, String>> decreeRecords = this.getDecreeRecords(processContext);
        String rodzaj_dokumentu = (String)processContext.get("rodzaj_dokumentu");
        String identyfikator_firmy = (String)processContext.get("identyfikator_firmy");
        for (Map<String, String> record : decreeRecords) {
            ClientProcedureGenerator recordProcedure = this.getDecreeRecordBookingProcedure(record, recordNo, rodzaj_dokumentu, identyfikator_firmy);
            decreeBookingProcedure.add(recordProcedure);
            ++recordNo;
        }
        return decreeBookingProcedure;
    }

    private List<Map<String, String>> getDecreeRecords(Map<String, Object> processContext) {
        List result = DynamicTableFunctions.convertFromMapToListOfMaps(processContext, (String[])decrreColumnIds);
        return result;
    }

    private ClientProcedureGenerator getDecreeRecordBookingProcedure(Map<String, String> record, int recordNo, String rodzaj_dokumentu, String identyfikator_firmy) {
        Map<String, Object> oRecord = this.parseToMapObjectValues(record);
        ClientProcedureGenerator cpg = new ClientProcedureGenerator(ClientProcedureGenerator.ProcedurName.WST_POZYCJE, oRecord);
        cpg.addValueAsLong("P_PD_LP", new Long(recordNo));
        cpg.addByIdAsString("P_SEKCJA_REJ", "sekcja_rejestru");
        cpg.addByIdAsNo("P_PD_KWOTA ", "kwota_brutto_pozycji_w");
        cpg.addByIdAsNo("P_PD_NETTO", "kwota_netto_pozycji_w_p");
        cpg.addByIdAsNo("P_PD_PODATEK", "kwota_vat");
        cpg.addByIdAsString("P_PD_OPIS", "opis_pozycji");
        cpg.addNullValue("P_PD_REJ_VAT");
        cpg.addByIdAsString("P_PD_STAWKA_POD", "stawka_vat");
        this.log.debug((Object)("rodzaj_dokumentu: " + rodzaj_dokumentu));
        this.log.debug((Object)("identyfikator_firmy: " + identyfikator_firmy));
        if (identyfikator_firmy.equals("100001") || identyfikator_firmy.equals("100002")) {
            if (rodzaj_dokumentu.equals("LEA")) {
                this.log.debug((Object)("konto_ks_dla_lea: " + oRecord.get("konto_ks_dla_lea")));
                this.log.debug((Object)("kurs_hist_dla_lea_2: " + oRecord.get("kurs_hist_dla_lea_2")));
                cpg.addByIdAsString("P_DEF_0", "konto_ks_dla_lea");
                cpg.addByIdAsNo("P_DEF_1", "kurs_hist_dla_lea_2");
                cpg.addNullValue("P_DEF_2");
                cpg.addNullValue("P_DEF_3");
                cpg.addNullValue("P_DEF_4");
            } else {
                cpg.addNullValue("P_DEF_0");
                cpg.addByIdAsString("P_DEF_1", "nr_pojazdu");
                this.log.debug((Object)("nr_pojazdu: " + oRecord.get("nr_pojazdu")));
                cpg.addByIdAsString("P_DEF_2", "nr_pracownik");
                this.log.debug((Object)("nr_pracownik: " + oRecord.get("nr_pracownik")));
                cpg.addByIdAsString("P_DEF_3", "rozrachunek_na");
                this.log.debug((Object)("rozrachunek_na: " + oRecord.get("rozrachunek_na")));
                cpg.addByIdAsString("P_DEF_4", "mpk");
            }
            cpg.addNullValue("P_DEF_5");
            cpg.addNullValue("P_DEF_6");
            cpg.addNullValue("P_DEF_7");
            cpg.addNullValue("P_DEF_8");
        } else {
            cpg.addNullValue("P_DEF_0");
            cpg.addByIdAsString("P_DEF_1", "mpk");
            cpg.addNullValue("P_DEF_2");
            cpg.addByIdAsString("P_DEF_3", "nr_zlecenia");
            cpg.addByIdAsNo("P_DEF_4", "nr_pojazdu");
            cpg.addNullValue("P_DEF_5");
            cpg.addByIdAsString("P_DEF_6", "nr_teczki");
            cpg.addByIdAsString("P_DEF_7", "rodzaj_paliwa");
            cpg.addByIdAsNo("P_DEF_8", "ilosc_paliwa");
        }
        cpg.addNullValue("P_DEF_9");
        cpg.addByIdAsString("P_TPOZ_SYMBOL", "typ_pozycji");
        String taxPart = this.getTaxPart(record);
        cpg.addValue("P_SPOS_ODL", taxPart, "'");
        cpg.addByIdAsDate("P_PD_DOV", "data_obowiazku_vat_pozy");
        cpg.addByIdAsNo("P_PD_KWOTA_WALUTY", "kwota_netto_pozycji");
        cpg.logProcedure();
        return cpg;
    }

    private Map<String, Object> parseToMapObjectValues(Map<String, String> toParse) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String id : toParse.keySet()) {
            result.put(id, toParse.get(id));
        }
        return result;
    }

    private String getTaxPart(Map<String, String> record) {
        return "C";
    }

    private boolean checkInvoiceIsConnectWithReserve(Map<String, Object> processContext) {
        String reserve = (String)processContext.get("rezerwa");
        return !reserve.isEmpty();
    }

    private void exceuteProcedureInOracle(ClientProcedureGenerator formBookingProcedure, List<ClientProcedureGenerator> decreeBookingProcedure, ClientProcedureGenerator formReserveBookingProcedure, List<ClientProcedureGenerator> decreeReserveBookingProcedure, Map<String, Object> processContext, DatabaseSession session) throws Exception {
        Long identyfikator_firmy = 1L;
        try {
            String sIdFirmy = (String)processContext.get("identyfikator_firmy");
            identyfikator_firmy = Long.parseLong(sIdFirmy);
        }
        catch (Exception ex) {
            this.log.debug((Object)"identyfikator_firmy ERROR ", (Throwable)ex);
        }
        Connection connection = session.getConnection();
        connection.setAutoCommit(false);
        try {
            this.exceuteStartProcedurs(connection, identyfikator_firmy);
            this.formInvoiceOraclId = this.executeFormProcedure(connection, formBookingProcedure);
            this.executeDecreeProcedure(connection, decreeBookingProcedure, this.formInvoiceOraclId);
            boolean executeNoProcedure = this.checkExecuteInvoiceNoProcedure(processContext);
            if (executeNoProcedure) {
                this.invoiceOracleNo = this.executeNoProcedure(connection, this.formInvoiceOraclId);
            }
            if (formReserveBookingProcedure != null) {
                this.formReserveOraclId = this.executeFormProcedure(connection, formReserveBookingProcedure);
                this.executeDecreeProcedure(connection, decreeReserveBookingProcedure, this.formReserveOraclId);
                this.reserveOracleNo = this.executeNoProcedure(connection, this.formReserveOraclId);
            }
            this.log.debug((Object)"Wykonywanie connection.commit()");
            try {
                connection.commit();
                this.log.debug((Object)"connection.commit() wykonany pomy\u015blnie");
            }
            catch (Exception ex) {
                this.log.error((Object)"connection.commit() blad - pomijamy");
                this.log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    private Connection getDefaultConnection() {
        DatabaseExplorer databaseExplorer = JasFbgSpringContext.getBean(DatabaseExplorer.class);
        Database database = databaseExplorer.get("JAS FBG");
        return (Connection)database.withinSession(DatabaseSession::getConnection);
    }

    private void exceuteStartProcedurs(Connection connection, long identyfikator_firmy) throws Exception {
        try (CallableStatement setCompanyCS = null;){
            setCompanyCS = connection.prepareCall(SET_COMPANY_PROC);
            long firma = identyfikator_firmy;
            this.log.debug((Object)("firma: " + firma));
            setCompanyCS.setLong("firma", firma);
            setCompanyCS.executeUpdate();
            CallableStatement setConsolidationCS = connection.prepareCall(SET_CONSL_PROC);
            setConsolidationCS.executeUpdate();
        }
    }

    private String executeFormProcedure(Connection connection, ClientProcedureGenerator formProcedure) throws Exception {
        String result = "";
        try (CallableStatement exportFormCS = null;){
            exportFormCS = formProcedure.createCallableStatment(connection);
            exportFormCS.registerOutParameter(1, 12);
            this.log.debug((Object)exportFormCS.toString());
            exportFormCS.executeUpdate();
            Object oFormId = exportFormCS.getObject(1);
            if (oFormId == null) {
                throw new Exception("procedura nie zwr\u00f3ci\u0142a id dokumentu");
            }
            result = oFormId.toString();
            this.log.debug((Object)("documentId: " + result));
        }
        return result;
    }

    private void executeDecreeProcedure(Connection connection, List<ClientProcedureGenerator> decreeBookingProcedure, String formOraclId) throws Exception {
        for (ClientProcedureGenerator decreeProcedure : decreeBookingProcedure) {
            decreeProcedure.addValueAsLong("P_PD_DOK_ID", new Long(formOraclId));
            this.log.debug((Object)("decreeProcedure: " + decreeProcedure));
            CallableStatement exportDecreeRecordCS = null;
            try {
                exportDecreeRecordCS = decreeProcedure.createCallableStatment(connection);
                exportDecreeRecordCS.registerOutParameter(1, -5);
                exportDecreeRecordCS.executeUpdate();
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                if (exportDecreeRecordCS == null) continue;
                exportDecreeRecordCS.close();
            }
        }
    }

    private boolean checkExecuteInvoiceNoProcedure(Map<String, Object> processContext) {
        String ownNo = (String)processContext.get("numer_wlasny");
        return ownNo.trim().isEmpty();
    }

    private String executeNoProcedure(Connection connection, String formOraclId) throws Exception {
        String result = "";
        try (CallableStatement getNoCS = null;){
            getNoCS = connection.prepareCall(NADAJ_NUMER);
            getNoCS.registerOutParameter(1, 12);
            getNoCS.setLong(2, (long)new Long(formOraclId));
            getNoCS.setLong(3, (long)new Long(1L));
            getNoCS.executeUpdate();
            result = (String)getNoCS.getObject(1);
            this.log.debug((Object)("Oracle No: " + result));
        }
        return result;
    }
}

