/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.lgldocuments.scripts;

import com.plusmpm.enhydra.shark.transaction.WfActivityTransaction;
import com.plusmpm.util.documents.DocumentEvent;
import com.plusmpm.util.documents.handlers.DocumentEventHandler;
import com.suncode.plugin.jasfbgclient.accountsreceivable.tools.ClientTools;
import com.suncode.plugin.jasfbgclient.documents.util.extensions.DocTools;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.util.ServiceFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class ArchiveLGLDocument
implements DocumentEventHandler {
    private static final Logger log = Logger.getLogger(ArchiveLGLDocument.class);
    public static final String ATTACHMENTS_CLASS_NAME = "Dokumenty g\u0142\u00f3wne LGL";
    private final DocumentService documentService = ServiceFactory.getDocumentService();

    public ArchiveLGLDocument(String id) {
    }

    public void handleEvent(WfActivityTransaction st, DocumentEvent documentEvent) throws Exception {
        long fileId = documentEvent.getDocument().getLFileId();
        boolean sendNotification = true;
        String notificationReason = "ARCHIWIZACJA_BRAK_DANYCH";
        log.debug((Object)("fileId: " + fileId));
        DocumentClassService docClassService = ServiceFactory.getDocumentClassService();
        WfDocument document = this.documentService.getDocument(Long.valueOf(fileId));
        DocumentClass documentClass = docClassService.getDocumentClass(ATTACHMENTS_CLASS_NAME, new String[0]);
        long idIndex = ClientTools.findIndexIdByCriteria("ID Transportu", documentClass);
        long companyIndex = ClientTools.findIndexIdByCriteria("Firma", documentClass);
        long id = (Long)document.getIndexValue(Long.valueOf(idIndex));
        String company = (String)document.getIndexValue(Long.valueOf(companyIndex));
        int companyId = ClientTools.getCompanyId(company);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String currentDate = sdf.format(new Date());
        log.debug((Object)"Sprawdzam, czy istnieje dokument g\u0142\u00f3wny");
        HashMap<String, Object> indexes = new HashMap<String, Object>();
        indexes.put("ID Transportu", id);
        indexes.put("Firma", company);
        if (id != 0L && ClientTools.checkDuplicate(indexes, ATTACHMENTS_CLASS_NAME, fileId)) {
            log.debug((Object)"Dokument g\u0142\u00f3wny istnieje ju\u017c w systemie");
            notificationReason = "ARCHIWIZACJA_DUPLIKAT";
        } else if (id != 0L && companyId >= 0) {
            try {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("id", String.valueOf(id));
                parameters.put("CompanyId", String.valueOf(companyId));
                parameters.put("Class", String.valueOf(documentClass.getId()));
                JSONObject documentJson = ClientTools.getResponseFromWS(SystemProperties.getString((String)"LGL_DOK_GLOWNY_WS_URL"), parameters);
                if (documentJson != null) {
                    log.debug((Object)"Dane dokumentu zosta\u0142y pobrane");
                    Map<String, Object> wsData = ArchiveLGLDocument.translateDocument(documentJson);
                    Set<Map.Entry<String, Object>> entrySet = wsData.entrySet();
                    for (Map.Entry<String, Object> oneResult : entrySet) {
                        document.setIndexValue(oneResult.getKey(), oneResult.getValue());
                    }
                    document.setIndexValue("Data archiwizacji", (Object)currentDate);
                    this.documentService.updateDocument(document);
                    sendNotification = false;
                }
            }
            catch (Exception e) {
                log.debug((Object)("B\u0142\u0105d pobierania danych:" + e.getMessage()), (Throwable)e);
            }
        } else {
            log.debug((Object)"Brak Id Transportu lub Firmy");
        }
        if (sendNotification) {
            log.debug((Object)("Nie pobrano danych dokumentu o id: " + id + " i Firmie: " + company + ". Dokument zostanie usuni\u0119ty z Archiwum."));
            long orgUnitIndex = ClientTools.findIndexIdByCriteria("Punkt skanowania", documentClass);
            String orgUnit = (String)document.getIndexValue(Long.valueOf(orgUnitIndex));
            HashMap<String, String> newIndexes = new HashMap<String, String>();
            newIndexes.put("id_transportu", String.valueOf(id));
            newIndexes.put("firma", company);
            newIndexes.put("klasa", ATTACHMENTS_CLASS_NAME);
            newIndexes.put("data_archiwizacji", currentDate);
            DocTools.wyslijPowiadomienie("LGL", fileId, orgUnit, notificationReason, newIndexes, ATTACHMENTS_CLASS_NAME);
            this.documentService.deleteDocument(document);
        }
    }

    private static Map<String, Object> translateDocument(JSONObject document) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Numer transportu", document.getString("TransportNumber"));
        map.put("Data za\u0142adunku", ClientTools.changeDateToString(ClientTools.changeStringToDate(document.getString("LoadingDate"), "yyyy-MM-dd'T'HH:mm:ss"), "yyyy-MM-dd"));
        map.put("Data roz\u0142adunku", ClientTools.changeDateToString(ClientTools.changeStringToDate(document.getString("UnloadingDate"), "yyyy-MM-dd'T'HH:mm:ss"), "yyyy-MM-dd"));
        map.put("Miejsce za\u0142adunku", document.getString("LoadingPlace"));
        map.put("Miejsce roz\u0142adunku", document.getString("UnloadingPlace"));
        map.put("Kod kontrahenta", document.getString("CarrierCode"));
        map.put("Nazwa kontrahenta", document.getString("CarrierName"));
        map.put("NIP", document.getString("CarrierTaxId"));
        map.put("Plac\u00f3wka", document.getString("Branch"));
        return map;
    }
}

