/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.costdocuments.util;

import com.plusmpm.CUF.database.queryDataChooser.QueryDataChooser;
import com.plusmpm.CUF.database.queryDataChooser.QueryDataChooserManager;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.InternalDataBase;
import com.plusmpm.util.classLoader.PlusClassLoader;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBTools {
    public static final String S_QUERY_CRITERIA_KEY = "GetDataChooserContentServlet_parameter_query";
    private static final Logger log = LoggerFactory.getLogger(DBTools.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Map<String, String>> GetDataFromDB(String queryId, Map<String, String> criteria) throws Exception {
        ArrayList<Map<String, String>> allResults = new ArrayList<Map<String, String>>();
        ArrayList results = null;
        Connection conn = null;
        ResultSet rs = null;
        ResultSet rsCount = null;
        PreparedStatement pstmQuery = null;
        PreparedStatement pstmCountQuery = null;
        try {
            List listOfQueries = QueryDataChooserManager.getQueryDataChooserForName((String)queryId);
            if (listOfQueries != null && listOfQueries.size() > 0) {
                HashMap<String, String> row = null;
                for (int a = 0; a < listOfQueries.size(); ++a) {
                    String parameters = ((QueryDataChooser)listOfQueries.get(a)).getParameters();
                    String query = ((QueryDataChooser)listOfQueries.get(a)).getQuery();
                    String countQuery = ((QueryDataChooser)listOfQueries.get(a)).getCountQuery();
                    if (StringUtils.isNotBlank((String)query) && StringUtils.isNotBlank((String)countQuery) && query.compareToIgnoreCase(" ") != 0 && countQuery.compareToIgnoreCase(" ") != 0) {
                        block58: {
                            String externaldb = ((QueryDataChooser)listOfQueries.get(a)).getExternalDB();
                            if (externaldb != null && externaldb.compareToIgnoreCase("TRUE") == 0) {
                                String externalDBConfName = ((QueryDataChooser)listOfQueries.get(a)).getExternalDBConfName();
                                log.debug("Nazwa konfiguracji polaczenia z zewnetrzna baza danych: " + externalDBConfName);
                                String sClassFullName = ((QueryDataChooser)listOfQueries.get(a)).getFullClassName();
                                log.debug("Pelna sciezka klasy do obslugi polaczenia z zewnetrzna baza danych: " + sClassFullName);
                                if (!StringUtils.isNotBlank((String)query) || !StringUtils.isNotBlank((String)externalDBConfName) || !StringUtils.isNotBlank((String)sClassFullName)) throw new CUFException("Brak odpowiednich parametrow do uzyskania polaczenia z zewnetrzna baza danych. Sprawdz definicje: " + queryId + " w tabeli pm_querydatachooser");
                                log.info("Zapytanie wykonywane na zewnetrznej bazie danych");
                                PlusClassLoader plusClassLoader = new PlusClassLoader();
                                Object[] oMethodArgs = new Object[]{externalDBConfName};
                                Class[] cMethodArgs = new Class[]{String.class};
                                try {
                                    log.info("Proba wywolania funkcji GetExternalDBConnection w celu uzyskania polaczenia z zewnetrzna baza danych");
                                    conn = (Connection)plusClassLoader.executeClassMethod(sClassFullName, "GetExternalDBConnection", oMethodArgs, cMethodArgs);
                                    if (conn == null || conn.isClosed()) {
                                        throw new CUFException("Brak polaczania z zewnetrzna baza danych");
                                    }
                                    break block58;
                                }
                                catch (Exception e) {
                                    throw new CUFException("Blad w definicji klasy, metody lub brak definicji dla funkcji uzyskiwania polaczenia z zewnetrzna bazy danych");
                                }
                            }
                            log.info("Zapytanie wykonywane na wewnetrznej bazie danych. Proba uzyskania polaczenia z wewnetrzna baza danych");
                            conn = InternalDataBase.connect();
                            if (conn == null || conn.isClosed()) {
                                throw new CUFException("Brak polaczania z wewnetrzna baza danych");
                            }
                        }
                        String[] queryTable = query.split("[?]", -1);
                        String[] queryCountTable = countQuery.split("[?]", -1);
                        pstmQuery = conn.prepareStatement(query);
                        pstmCountQuery = conn.prepareStatement(countQuery);
                        if (queryTable.length > 1) {
                            if (!StringUtils.isNotBlank((String)parameters) || parameters.compareToIgnoreCase("NULL") == 0) throw new CUFException("Nie podano parameters w tabeli pm_querydatachooser");
                            log.debug("Parameters: " + parameters);
                            String[] parametersTableWithTypes = parameters.split(",");
                            if (queryTable.length - 1 != parametersTableWithTypes.length) throw new CUFException("Niezgodnosc ilosci podanych parametrow z iloscia parametrow w zapytaniu lub blad w zapytaniu liczenia rezultatow");
                            int indexForCountQuery = 1;
                            for (int k = 1; k < queryTable.length; ++k) {
                                String[] parametersTable = parametersTableWithTypes[k - 1].split(":");
                                if (parametersTable[0].compareToIgnoreCase("DCKEY") == 0) {
                                    log.debug("Parametr " + k + ": query key");
                                    text = criteria.get(S_QUERY_CRITERIA_KEY);
                                    if (parametersTable.length == 2) {
                                        pstmQuery = DBTools.SetParameterForStatement(pstmQuery, k, parametersTable[1], text);
                                        if (k <= queryCountTable.length) {
                                            pstmCountQuery = DBTools.SetParameterForStatement(pstmCountQuery, indexForCountQuery, parametersTable[1], text);
                                        }
                                    } else {
                                        pstmQuery = DBTools.SetParameterForStatement(pstmQuery, k, "string", text);
                                        if (k <= queryCountTable.length) {
                                            pstmCountQuery = DBTools.SetParameterForStatement(pstmCountQuery, indexForCountQuery, "string", text);
                                        }
                                    }
                                } else {
                                    text = criteria.get(parametersTable[0]);
                                    if (text != null) {
                                        log.debug("Parametr " + k + ": FormCriteria");
                                        if (parametersTable.length == 2) {
                                            pstmQuery = DBTools.SetParameterForStatement(pstmQuery, k, parametersTable[1], text);
                                            if (k <= queryCountTable.length) {
                                                pstmCountQuery = DBTools.SetParameterForStatement(pstmCountQuery, indexForCountQuery, parametersTable[1], text);
                                            }
                                        } else {
                                            pstmQuery = DBTools.SetParameterForStatement(pstmQuery, k, "string", text);
                                            if (k <= queryCountTable.length) {
                                                pstmCountQuery = DBTools.SetParameterForStatement(pstmCountQuery, indexForCountQuery, "string", text);
                                            }
                                        }
                                    } else if (parametersTable[0].equals("startItem")) {
                                        log.debug("Parametr " + k + ": startItem");
                                    } else if (parametersTable[0].equals("endItem")) {
                                        log.debug("Parametr " + k + ": endItem");
                                    } else if (parametersTable[0].equals("limit")) {
                                        log.debug("Parametr " + k + ": limit");
                                    } else {
                                        log.debug("Parametr " + k + ": stala wartosc");
                                        if (parametersTable.length == 2) {
                                            pstmQuery = DBTools.SetParameterForStatement(pstmQuery, k, parametersTable[1], parametersTable[0]);
                                            if (k <= queryCountTable.length) {
                                                pstmCountQuery = DBTools.SetParameterForStatement(pstmCountQuery, indexForCountQuery, parametersTable[1], parametersTable[0]);
                                            }
                                        } else {
                                            pstmQuery = DBTools.SetParameterForStatement(pstmQuery, k, "string", parametersTable[0]);
                                            if (k <= queryCountTable.length) {
                                                pstmCountQuery = DBTools.SetParameterForStatement(pstmCountQuery, indexForCountQuery, "string", parametersTable[0]);
                                            }
                                        }
                                    }
                                }
                                ++indexForCountQuery;
                            }
                        }
                        log.debug("Query: " + query);
                        log.debug("CountQuery: " + countQuery);
                        results = new ArrayList();
                        rs = pstmQuery.executeQuery();
                        ResultSetMetaData rsmd = rs.getMetaData();
                        int numColumns = rsmd.getColumnCount();
                        while (rs.next()) {
                            HashMap<String, String> oneRow = new HashMap<String, String>();
                            for (int i = 1; i < numColumns + 1; ++i) {
                                String columnName = rsmd.getColumnName(i);
                                String oneValue = rs.getString(columnName);
                                columnName = columnName.toLowerCase();
                                if (oneValue == null) {
                                    oneValue = "";
                                }
                                oneRow.put(columnName, oneValue);
                            }
                            results.add(oneRow);
                        }
                        rsCount = pstmCountQuery.executeQuery();
                        if (results != null && results.size() > 0) {
                            Iterator mappings = ((HashMap)results.get(0)).keySet().iterator();
                            String[] mappingsTable = new String[((HashMap)results.get(0)).size()];
                            int nrOfMappings = 0;
                            while (mappings.hasNext()) {
                                String oneMapping = (String)mappings.next();
                                log.debug("Mapping: " + oneMapping);
                                mappingsTable[nrOfMappings] = oneMapping;
                                ++nrOfMappings;
                            }
                            for (int j = 0; j < results.size(); ++j) {
                                row = new HashMap<String, String>();
                                for (int i = 0; i < nrOfMappings; ++i) {
                                    row.put(mappingsTable[i], (String)((HashMap)results.get(j)).get(mappingsTable[i]));
                                }
                                allResults.add(row);
                            }
                            continue;
                        }
                        log.info("Brak wynikow zapytania");
                        continue;
                    }
                    log.warn("Niepoprawnie zdefiniowane zapytania dla identyfikatora " + queryId);
                }
            } else {
                log.warn("Brak zapytan dla identyfikatora " + queryId);
            }
            ArrayList<Map<String, String>> arrayList = allResults;
            return arrayList;
        }
        catch (CUFException e) {
            log.error(e.getMessage());
            List<Map<String, String>> list = null;
            return list;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            List<Map<String, String>> list = null;
            return list;
        }
        finally {
            try {
                if (rsCount != null) {
                    rsCount.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static PreparedStatement SetParameterForStatement(PreparedStatement pstm, int index, String sType, String sValue) throws SQLException {
        log.debug("************ SetParameterForStatement(index=" + String.valueOf(index) + ", sType=" + sType + ", sValue=" + sValue + ") ************");
        try {
            if (sType.compareToIgnoreCase("string") == 0) {
                pstm.setString(index, sValue);
            } else if (sType.compareToIgnoreCase("int") == 0 || sType.compareToIgnoreCase("int8") == 0 || sType.compareToIgnoreCase("integer") == 0) {
                if (StringUtils.isNotBlank((String)sValue)) {
                    pstm.setInt(index, Integer.valueOf(sValue));
                } else {
                    pstm.setInt(index, 0);
                }
            } else if (sType.compareToIgnoreCase("float") == 0 || sType.compareToIgnoreCase("float8") == 0) {
                if (StringUtils.isNotBlank((String)sValue)) {
                    pstm.setFloat(index, Float.valueOf(sValue).floatValue());
                } else {
                    pstm.setFloat(index, 0.0f);
                }
            } else if (sType.compareToIgnoreCase("double") == 0 || sType.compareToIgnoreCase("double8") == 0) {
                if (StringUtils.isNotBlank((String)sValue)) {
                    pstm.setDouble(index, Double.valueOf(sValue));
                } else {
                    pstm.setDouble(index, 0.0);
                }
            } else if (sType.compareToIgnoreCase("timestamp") == 0) {
                if (StringUtils.isNotBlank((String)sValue)) {
                    pstm.setTimestamp(index, Timestamp.valueOf(sValue));
                } else {
                    pstm.setTimestamp(index, new Timestamp(0L));
                }
            } else if (sType.compareToIgnoreCase("date") == 0) {
                if (StringUtils.isNotBlank((String)sValue)) {
                    pstm.setDate(index, Date.valueOf(sValue));
                } else {
                    pstm.setDate(index, new Date(0L));
                }
            }
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        return pstm;
    }
}

