/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.costdocuments.setters;

import com.suncode.plugin.jasfbgclient.category.Categories;
import com.suncode.plugin.jasfbgclient.costdocuments.setters.OracleResponse;
import com.suncode.plugin.jasfbgclient.costdocuments.setters.OracleResponseService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@VariableSetter
public class SetOwnNo {
    private static final String ORACLE_NO_ID = "numer_wlasny";
    private static final String ORACLE_RESERVE_NO_ID = "numer_ksiegowy_rezerwy";
    private static final String ORACLE_NO_ID_ID = "id_systemu_egeria";
    private static final String ORACLE_RESERVE_ID_ID = "id_systemu_egeria_rezer";
    private static Logger log = Logger.getLogger(SetOwnNo.class);

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("jas-fbg-client.set-own-no")).name("Ustawienie numeru ksi\u0119gowania JAS-FBG Client")).description("Ustawienie numeru ksi\u0119gowania JAS-FBG Client")).category(new Category[]{Categories.JASFBG})).icon((Icon)SilkIconPack.APPLICATION)).create();
    }

    public void set(ActivityContextMap context) {
        OracleResponse oracleResponse = OracleResponseService.getOracleResponseByPorcessId(context.getProcessId());
        log.debug((Object)("oracleResponse: " + oracleResponse));
        this.setOwnNumber(context, oracleResponse.getInvoiceOracleNo());
        this.setReserveAccountNumber(context, oracleResponse.getReserveOracleNo());
        this.setEgeriaSystemIdentifier(context, oracleResponse.getFormInvoiceOraclId());
        this.setEgeriaRezerSystemIdentifier(context, oracleResponse.getFormReserveOraclId());
        boolean isRemove = OracleResponseService.removeOracleResponseByProcessId(context.getProcessId());
        log.debug((Object)("isRemove: " + isRemove));
    }

    private void setOwnNumber(ActivityContextMap context, String value) {
        Variable ownNumber = context.getVariable(ORACLE_NO_ID);
        if (ownNumber.getValue().toString().isEmpty() && StringUtils.isNotBlank((CharSequence)value)) {
            ownNumber.setValue((Object)value);
        }
    }

    private void setReserveAccountNumber(ActivityContextMap context, String value) {
        Variable reserveAccountNumber = context.getVariable(ORACLE_RESERVE_NO_ID);
        if (reserveAccountNumber.getValue().toString().isEmpty() && StringUtils.isNotBlank((CharSequence)value)) {
            reserveAccountNumber.setValue((Object)value);
        }
    }

    private void setEgeriaSystemIdentifier(ActivityContextMap context, String value) {
        Variable egeriaSystemIdentifier = context.getVariable(ORACLE_NO_ID_ID);
        if (egeriaSystemIdentifier.getValue().toString().isEmpty() && StringUtils.isNotBlank((CharSequence)value)) {
            egeriaSystemIdentifier.setValue((Object)value);
        }
    }

    private void setEgeriaRezerSystemIdentifier(ActivityContextMap context, String value) {
        Variable egeriaRezerSystemIdentifier = context.getVariable(ORACLE_RESERVE_ID_ID);
        if (egeriaRezerSystemIdentifier.getValue().toString().isEmpty() && StringUtils.isNotBlank((CharSequence)value)) {
            egeriaRezerSystemIdentifier.setValue((Object)value);
        }
    }
}

