/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.costdocuments.servlets;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.util.FinderFactory;
import java.util.List;
import java.util.Map;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/custom/servlet"})
public class RefreshExchangeRate {
    private static final Logger log = LoggerFactory.getLogger(RefreshExchangeRate.class);

    @RequestMapping(value={"getExchangeRate"}, method={RequestMethod.POST})
    @ResponseBody
    public String getExchangeRate(@RequestParam String jSon) {
        String rate = null;
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map reqData = (Map)mapper.readValue(jSon, Map.class);
            String currency = (String)reqData.get("currency");
            DateTime date = new DateTime(reqData.get("date"));
            String destDate = date.toString(formatter);
            SQLBuilder builder = new SQLBuilder();
            builder.setQuery("select * from pm_cuf_currencyexchangerate where code=:code and date < to_date(:dateCondition,'YYYY-MM-DD') order by  date desc limit 1");
            builder.setParameter("code", (Object)currency);
            builder.setParameter("dateCondition", (Object)destDate);
            builder.addScalar("rate", (Type)StandardBasicTypes.DOUBLE);
            SQLFinder finder = FinderFactory.getSQLFinder();
            List dbData = finder.find(builder);
            for (Map data : dbData) {
                rate = String.valueOf(data.get("rate"));
            }
            return rate;
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            return "";
        }
    }
}

