/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.costdocuments.services;

import com.plusmpm.database.hibernate.HibernateUtil;
import com.suncode.plugin.jasfbgclient.costdocuments.model.AcceptDefinition;
import com.suncode.plugin.jasfbgclient.costdocuments.services.CategoryService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.util.FinderFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class AcceptDefinitionService {
    private String documentCategory;
    private String documentType;
    private String[] roles;
    private String idFirma;
    private static Logger log = Logger.getLogger(AcceptDefinition.class);

    public AcceptDefinitionService(String documentCategoryName, String documentType, String idFirma, String ... roles) {
        this.documentCategory = this.getCategorySymbolByCategoryName(documentCategoryName);
        this.documentType = documentType;
        this.idFirma = idFirma;
        this.roles = roles;
    }

    private String getCategorySymbolByCategoryName(String categoryName) {
        return CategoryService.getCategorySymbolByCategoryName(categoryName);
    }

    public List<User> getUserAcceptList() {
        List<AcceptDefinition> acceptDefinitions = this.getAcceptDefinitionByCategoryAndType();
        List<User> userList = this.convertToUserList(acceptDefinitions);
        return userList;
    }

    private List<AcceptDefinition> getAcceptDefinitionByCategoryAndType() {
        DetachedCriteria criteria = this.getDetachCriteriaDefinitionByCategoryAndType();
        return this.getAcceptDefinitions(criteria);
    }

    private DetachedCriteria getDetachCriteriaDefinitionByCategoryAndType() {
        log.debug((Object)("documentCategory: " + this.documentCategory + " documentType: " + this.documentType + " idFirma: " + this.idFirma + " roles: " + Arrays.toString(this.roles)));
        DetachedCriteria criteria = DetachedCriteria.forClass(AcceptDefinition.class);
        if (!StringUtils.isBlank((String)this.documentCategory)) {
            SimpleExpression emptyCategory = Restrictions.eq((String)"documentCategory", (Object)"");
            SimpleExpression sameCategoty = Restrictions.eq((String)"documentCategory", (Object)this.documentCategory);
            Criterion nullCategoty = Restrictions.isNull((String)"documentCategory");
            criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{emptyCategory, sameCategoty, nullCategoty}));
        }
        if (!StringUtils.isBlank((String)this.documentType)) {
            SimpleExpression emptyType = Restrictions.eq((String)"documentType", (Object)"");
            SimpleExpression sameType = Restrictions.eq((String)"documentType", (Object)this.documentType);
            Criterion nullType = Restrictions.isNull((String)"documentType");
            criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{emptyType, sameType, nullType}));
        }
        if (!StringUtils.isBlank((String)this.idFirma)) {
            SimpleExpression sameidFirma = Restrictions.eq((String)"idFirma", (Object)this.idFirma);
            criteria.add((Criterion)sameidFirma);
        }
        ArrayList<SimpleExpression> roleCriteriaList = new ArrayList<SimpleExpression>();
        for (String role : this.roles) {
            SimpleExpression roleCriteria = Restrictions.eq((String)"role", (Object)role);
            roleCriteriaList.add(roleCriteria);
        }
        criteria.add((Criterion)Restrictions.or((Criterion[])roleCriteriaList.toArray(new Criterion[roleCriteriaList.size()])));
        return criteria;
    }

    private List<User> convertToUserList(List<AcceptDefinition> acceptDefinitions) {
        ArrayList<User> userList = new ArrayList<User>();
        for (AcceptDefinition acceptDefinition : acceptDefinitions) {
            User user = this.convertToUser(acceptDefinition);
            if (user == null) continue;
            userList.add(user);
        }
        return userList;
    }

    private User convertToUser(AcceptDefinition acceptDefinition) {
        String userName;
        UserFinder uf = FinderFactory.getUserFinder();
        User user = uf.findByUserName(userName = acceptDefinition.getUserName().toLowerCase(), new String[0]);
        if (user == null) {
            log.warn((Object)("U\u017cytkownik o nazwie: " + userName + " nie wyst\u0119puje w systemie"));
        }
        return user;
    }

    public Double getUserLimitByUserName(String userName) {
        DetachedCriteria criteria = this.getDetachCriteriaDefinitionByCategoryAndType();
        criteria.add((Criterion)Restrictions.eq((String)"userName", (Object)userName));
        List<AcceptDefinition> findUserAcceptDefinition = this.getAcceptDefinitions(criteria);
        int bigestLimit = 0;
        for (AcceptDefinition acceptDefinition : findUserAcceptDefinition) {
            bigestLimit = bigestLimit < acceptDefinition.getLimitAmout() ? acceptDefinition.getLimitAmout() : bigestLimit;
        }
        return bigestLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AcceptDefinition> getAcceptDefinitions(DetachedCriteria criteria) {
        Session session = null;
        List<AcceptDefinition> definitions = new ArrayList<AcceptDefinition>();
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            log.debug((Object)definitions.toString());
            definitions = criteria.getExecutableCriteria(session).list();
            log.debug((Object)("definition.size() " + definitions.size()));
        }
        catch (Exception exception) {
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        this.setDefinitionNotLimitAmount(definitions);
        return definitions;
    }

    private void setDefinitionNotLimitAmount(List<AcceptDefinition> definitions) {
        for (AcceptDefinition acceptDefinition : definitions) {
            Integer acceptDefinitionAmount = acceptDefinition.getLimitAmout();
            if (acceptDefinitionAmount != -1) continue;
            acceptDefinition.setLimitAmout(Integer.MAX_VALUE);
        }
    }

    public boolean checkSendEmail(String userName) {
        boolean sendEmail = false;
        DetachedCriteria criteria = this.getDetachCriteriaDefinitionByCategoryAndType();
        criteria.add((Criterion)Restrictions.eq((String)"userName", (Object)userName));
        List<AcceptDefinition> findUserAcceptDefinition = this.getAcceptDefinitions(criteria);
        for (AcceptDefinition acceptDefinition : findUserAcceptDefinition) {
            String sendNotification = acceptDefinition.getSendNotification();
            if (sendNotification == null || !sendNotification.equalsIgnoreCase("TAK")) continue;
            sendEmail = true;
            break;
        }
        return sendEmail;
    }
}

