/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.costdocuments.plannedtasks;

import com.plusmpm.database.SessionAwareTransactionCallbackWithoutResult;
import com.suncode.cuf.template.WordTemplateService;
import com.suncode.cuf.util.CufServiceFactory;
import com.suncode.cuf.util.TemporaryFile;
import com.suncode.cuf.util.template.WordTemplateUtil;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class GenerateMetricsFromFile {
    private static WordTemplateService wordTemplateService = CufServiceFactory.getWordTemplateService();
    public static Logger log = Logger.getLogger(GenerateMetricsFromFile.class);

    public void generate(final String fileName, final String docClassName, final String templateName, final String pdf, final String addToProcess, final String newVersion) {
        TransactionTemplate tt = new TransactionTemplate(TransactionManagerFactory.getHibernateTransactionManager());
        tt.execute((TransactionCallback)new SessionAwareTransactionCallbackWithoutResult(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void doWithSession(Session session) {
                String processId = null;
                String activityId = null;
                ActivityFinder activityFinder = FinderFactory.getActivityFinder();
                boolean saveAsPDF = GenerateMetricsFromFile.asBoolean(pdf);
                boolean attachToProces = GenerateMetricsFromFile.asBoolean(addToProcess);
                boolean saveAsNewVersion = GenerateMetricsFromFile.asBoolean(newVersion);
                WordTemplateService.OutputFormat format = saveAsPDF ? WordTemplateService.OutputFormat.PDF : WordTemplateService.OutputFormat.DOCX;
                File output = null;
                BufferedReader br = null;
                try {
                    String sLine;
                    FileReader fr = new FileReader(fileName);
                    br = new BufferedReader(fr);
                    while ((sLine = br.readLine()) != null) {
                        processId = sLine.trim();
                        log.debug((Object)("processId: " + processId));
                        Activity activity = activityFinder.findLastActivity(processId);
                        activityId = activity.getActivityId();
                        log.debug((Object)("activityId: " + activityId));
                        try {
                            output = TemporaryFile.create((String)(templateName + "_" + processId + "_"), (String)("." + format.toString().toLowerCase()));
                            wordTemplateService.generateForActivity(output, templateName, processId, activityId, format);
                            WordTemplateUtil.archiveAndAttachToProcess((File)output, (String)processId, (String)activityId, (String)docClassName, (String)templateName, (WordTemplateService.OutputFormat)format, (boolean)attachToProces, (boolean)saveAsNewVersion);
                        }
                        catch (Exception e) {
                            try {
                                log.error((Object)e.getMessage(), (Throwable)e);
                            }
                            catch (Throwable throwable) {
                                FileUtils.deleteQuietly(output);
                                throw throwable;
                                return;
                            }
                            FileUtils.deleteQuietly((File)output);
                            continue;
                        }
                        FileUtils.deleteQuietly((File)output);
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    return;
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        });
    }

    private static boolean asBoolean(String param) {
        return Boolean.valueOf(param);
    }
}

