/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.jasfbgclient.balanceconfirmation.scripts;

import com.plusmpm.enhydra.shark.transaction.WfActivityTransaction;
import com.plusmpm.util.documents.DocumentEvent;
import com.plusmpm.util.documents.handlers.DocumentEventHandler;
import com.suncode.cuf.mail.MailConfiguration;
import com.suncode.cuf.mail.MailContent;
import com.suncode.cuf.mail.MailSender;
import com.suncode.cuf.mail.SendReport;
import com.suncode.cuf.mail.SystemMailConfiguration;
import com.suncode.cuf.mail.TemplateMailContent;
import com.suncode.cuf.util.CufComponentFactory;
import com.suncode.plugin.jasfbgclient.accountsreceivable.tools.ClientTools;
import com.suncode.plugin.jasfbgclient.documents.util.extensions.EmailTemplate;
import com.suncode.plugin.jasfbgclient.documents.util.extensions.P0063Tools;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class NewDocumentScript
implements DocumentEventHandler {
    private static final Logger log = Logger.getLogger(NewDocumentScript.class);
    private static final String ATTACHMENTS_CLASS_NAME = "Potwierdzenia sald";
    private final DocumentService documentService = ServiceFactory.getDocumentService();

    public NewDocumentScript(String processId) {
    }

    public void handleEvent(WfActivityTransaction st, DocumentEvent documentEvent) throws Exception {
        long fileId = documentEvent.getDocument().getLFileId();
        WfDocument document = this.documentService.getDocument(Long.valueOf(fileId));
        String docNumber = (String)document.getIndexValue("Numer dokumentu");
        String contrCode = (String)document.getIndexValue("Kod kontrahenta");
        String company = (String)document.getIndexValue("Firma");
        String state = (String)document.getIndexValue("Stan na dzie\u0144");
        String currentDate = this.getCurrentDate();
        log.debug((Object)("Przetwarzam dokument o numerze: " + docNumber + " i kodzie kontrahenta: " + contrCode));
        HashMap<String, String> newIndexes = new HashMap<String, String>();
        newIndexes.put("firma", company);
        newIndexes.put("kod_kontrahenta", contrCode);
        newIndexes.put("data_archiwizacji", currentDate);
        newIndexes.put("numer_dokumentu", docNumber != null ? docNumber : "");
        newIndexes.put("stan_na_dzien", state != null ? state : "");
        if (StringUtils.isNotBlank((CharSequence)company) && StringUtils.isNotBlank((CharSequence)contrCode)) {
            int companyId = ClientTools.getCompanyId(company);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("CustomerCode", contrCode);
            parameters.put("CompanyId", String.valueOf(companyId));
            parameters.put("Class", ATTACHMENTS_CLASS_NAME);
            String contractorEmail = NewDocumentScript.getResponseFromWS(SystemProperties.getString((String)"POTWIERDZENIA_SALD_WS_URL"), parameters);
            if (StringUtils.isNotBlank((CharSequence)contractorEmail)) {
                try {
                    log.debug((Object)("Adres email kontrahenta: " + contractorEmail));
                    NewDocumentScript.wyslijPowiadomienie("POTWIERDZENIA_SALD", fileId, contractorEmail, "ARCHIWIZACJA_POPRAWNA", newIndexes, ATTACHMENTS_CLASS_NAME);
                    document.setIndexValue("Email", (Object)contractorEmail);
                    this.documentService.updateDocument(document);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                log.info((Object)"Brak adresu email. Wiadomo\u015b\u0107 email nie zostanie wys\u0142ana.");
            }
        } else {
            log.info((Object)"Brak danych do pobrania adresu email. Wiadomo\u015b\u0107 email nie zostanie wys\u0142ana.");
        }
    }

    public static String getResponseFromWS(String sUrl, Map<String, String> parameters) throws Exception {
        try (BufferedReader reader = null;){
            StringBuilder authData = new StringBuilder();
            authData.append(SystemProperties.getString((String)"WS_USER"));
            authData.append(SystemProperties.getString((String)"WS_PASS"));
            byte[] authEncBytes = Base64.encodeBase64((byte[])authData.toString().getBytes());
            String authStringEnc = new String(authEncBytes);
            StringBuilder wsUrl = new StringBuilder();
            wsUrl.append(sUrl);
            wsUrl.append("?");
            Set<Map.Entry<String, String>> entrySet = parameters.entrySet();
            int i = 0;
            for (Map.Entry<String, String> entry : entrySet) {
                wsUrl.append(i > 0 ? "&" : "");
                wsUrl.append(entry.getKey());
                wsUrl.append("=");
                wsUrl.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                ++i;
            }
            log.debug((Object)("wsUrl: " + wsUrl));
            URL url = new URL(wsUrl.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("charset", "UTF-8");
            connection.setRequestProperty("Authorization", "Basic " + authStringEnc);
            int responseCode = connection.getResponseCode();
            String result = "";
            log.debug((Object)("responseCode: " + responseCode));
            if (responseCode < 400) {
                String line = "";
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    log.debug((Object)("line: " + line));
                    result = line.replaceAll("\"", "");
                }
            } else {
                throw new Exception("Dane nie zosta\u0142y pobrane.");
            }
            String string = result.compareToIgnoreCase("null") == 0 ? "" : result;
            return string;
        }
    }

    private static void wyslijPowiadomienie(String typ_grupy, long file_id, String emailAddress, String reason, Map<String, String> dane_do_powiadomien, String nazwa_klasy_dokumentow) {
        try {
            log.debug((Object)("wyslijPowiadomienie: typ_grupy: " + typ_grupy + ", emailAddress: " + emailAddress + ", file_id " + file_id + ", reason: " + reason));
            ArrayList<String> emails = new ArrayList<String>();
            emails.add(emailAddress);
            if (emailAddress == null || emailAddress.length() <= 0) {
                log.info((Object)"Brak adresu email. Wiadomos\u0107 nie zostanie wys\u0142ana");
            } else {
                EmailTemplate emailTemplate = P0063Tools.getEmailTemplate(typ_grupy, reason);
                if (emailTemplate != null) {
                    MailSender sender = CufComponentFactory.getMailSender();
                    SystemMailConfiguration cfg = SystemMailConfiguration.getInstance();
                    TemplateMailContent content = new TemplateMailContent();
                    HashMap<String, String> tempMap = new HashMap<String, String>();
                    tempMap.putAll(dane_do_powiadomien);
                    tempMap.put("klasa", nazwa_klasy_dokumentow);
                    content.setSubject(emailTemplate.getEmailSubject());
                    content.setTemplatePath(emailTemplate.getEmailTemplatePath());
                    content.setVariables(tempMap);
                    SendReport report = new SendReport();
                    FileService fileService = ServiceFactory.getFileService();
                    WfFile file = fileService.getFile(Long.valueOf(file_id), new String[]{"documentClass"});
                    ArrayList<String> files = new ArrayList<String>();
                    files.add(file.getFullPath());
                    log.debug((Object)("Wiadomosc z zalacznikiem o nazwie: " + file.getFileName()));
                    content.addAttachment(file.getFileName(), file.getFullPath());
                    report = sender.send((MailConfiguration)cfg, (MailContent)content, emails);
                    if (report.getFailedEmails() == null || report.getFailedEmails().isEmpty()) {
                        log.debug((Object)("Poprawnie wys\u0142ano maila na adres" + emailAddress + " o temacie: " + emailTemplate.getEmailSubject()));
                    } else {
                        log.info((Object)("Nie uda\u0142o si\u0119 wys\u0142a\u0107 maila na adres " + emailAddress + " o temacie: " + emailTemplate.getEmailSubject()));
                        new Exception("B\u0142\u0105d wysy\u0142ania wiadomo\u015bci email na adres: " + emailAddress);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private String getCurrentDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String currentDate = sdf.format(new Date());
        return currentDate;
    }
}

