/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.upgrader_tasks;

import com.suncode.pwfl.administration.configuration.Category;
import com.suncode.pwfl.administration.configuration.ParameterType;
import com.suncode.pwfl.administration.configuration.SystemParameter;
import com.suncode.pwfl.administration.configuration.SystemParameterService;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.upgrader.change.task.Task;
import org.apache.log4j.Logger;

public class AddSystemProperties
implements Task {
    private Logger log = Logger.getLogger(this.getClass());
    private final String[] parameters = new String[]{"PRNDirectory"};

    public void run() {
        try {
            Category category = new Category("IKEA Industry");
            SystemParameterService service = ServiceFactory.getSystemParameterService();
            for (int i = 0; i < this.parameters.length; ++i) {
                SystemParameter parameter = new SystemParameter(category, ParameterType.TEXT, this.parameters[i]);
                service.create(parameter);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void rollback() {
        SystemParameterService service = ServiceFactory.getSystemParameterService();
        for (int i = 0; i < this.parameters.length; ++i) {
            SystemParameter parameter = service.getParameter(this.parameters[i]);
            try {
                service.delete(parameter.getKey());
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

