/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.application;

import com.suncode.client.Categories;
import com.suncode.client.utils.Tools;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Application
public class GeneratePreliminaryPrnFile {
    private static final Logger log = LoggerFactory.getLogger(GeneratePreliminaryPrnFile.class);

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("ikea-prn-generate-preliminary-file-task")).name("application.ikea-prn-generate-preliminary-file-task.name")).description("application.ikea-prn-generate-preliminary-file-task.desc")).icon((Icon)SilkIconPack.PAGE_EDIT)).category(new Category[]{Categories.CLIENT})).parameter().id("prnFilePrefix").name("application.ikea-prn-generate-file-task.prnFilePrefix.name").description("application.ikea-prn-generate-file-task.prnFilePrefix.desc").type((Type)Types.STRING).create()).parameter().id("prnSubDirectory").name("application.ikea-prn-generate-file-task.prnSubDirectory.name").description("application.ikea-prn-generate-file-task.prnSubDirectory.desc").type((Type)Types.STRING).optional().create()).parameter().id("supplierId").name("application.ikea-prn-generate-file-task.supplierId.name").description("application.ikea-prn-generate-file-task.supplierId.desc").type((Type)Types.STRING).create()).parameter().id("invoiceNo").name("application.ikea-prn-generate-file-task.invoiceNo.name").description("application.ikea-prn-generate-file-task.invoiceNo.desc").type((Type)Types.STRING).create()).parameter().id("invoiceDate").name("application.ikea-prn-generate-file-task.invoiceDate.name").description("application.ikea-prn-generate-file-task.invoiceDate.desc").type((Type)Types.DATE).create()).parameter().id("paymentDate").name("application.ikea-prn-generate-file-task.paymentDate.name").description("application.ikea-prn-generate-file-task.paymentDate.desc").type((Type)Types.DATE).create()).parameter().id("grossAmount").name("application.ikea-prn-generate-file-task.grossAmount.name").description("application.ikea-prn-generate-file-task.grossAmount.desc").type((Type)Types.FLOAT).create()).parameter().id("netAmount").name("application.ikea-prn-generate-file-task.netAmount.name").description("application.ikea-prn-generate-file-task.netAmount.desc").type((Type)Types.FLOAT_ARRAY).create()).parameter().id("taxAmount").name("application.ikea-prn-generate-file-task.taxAmount.name").description("application.ikea-prn-generate-file-task.taxAmount.desc").type((Type)Types.FLOAT_ARRAY).create()).parameter().id("taxCode").name("application.ikea-prn-generate-file-task.taxCode.name").description("application.ikea-prn-generate-file-task.taxCode.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("currency").name("application.ikea-prn-generate-file-task.currency.name").description("application.ikea-prn-generate-file-task.currency.desc").type((Type)Types.STRING).create()).parameter().id("exchangeRate").name("application.ikea-prn-generate-file-task.exchangeRate.name").description("application.ikea-prn-generate-file-task.exchangeRate.desc").type((Type)Types.FLOAT).create()).parameter().id("incomingDate").name("application.ikea-prn-generate-file-task.incomingDate.name").description("application.ikea-prn-generate-file-task.incomingDate.desc").type((Type)Types.DATE).create()).parameter().id("deliveryDate").name("application.ikea-prn-generate-file-task.deliveryDate.name").description("application.ikea-prn-generate-file-task.deliveryDate.desc").type((Type)Types.DATE).create()).parameter().id("postingDate").name("application.ikea-prn-generate-file-task.postingDate.name").description("application.ikea-prn-generate-file-task.postingDate.desc").type((Type)Types.DATE).create()).parameter().id("responsible").name("application.ikea-prn-generate-file-task.responsible.name").description("application.ikea-prn-generate-file-task.responsible.desc").type((Type)Types.STRING).create()).parameter().id("bankAccount").name("application.ikea-prn-generate-file-task.bankAccount.name").description("application.ikea-prn-generate-file-task.bankAccount.desc").type((Type)Types.STRING).create()).parameter().id("bankAccountId").name("application.ikea-prn-generate-file-task.bankAccountId.name").description("application.ikea-prn-generate-file-task.bankAccountId.desc").type((Type)Types.STRING).create()).parameter().id("supplierDomesticCountry").name("application.ikea-prn-generate-file-task.supplierDomesticCountry.name").description("application.ikea-prn-generate-file-task.supplierDomesticCountry.desc").type((Type)Types.STRING).create()).parameter().id("paymentMethod").name("application.ikea-prn-generate-file-task.paymentMethod.name").description("application.ikea-prn-generate-file-task.paymentMethod.desc").type((Type)Types.STRING).create()).parameter().id("supplierAccount").name("application.ikea-prn-generate-file-task.supplierAccount.name").description("application.ikea-prn-generate-file-task.supplierAccount.desc").type((Type)Types.STRING).create()).parameter().id("netValueAccount").name("application.ikea-prn-generate-file-task.netValueAccount.name").description("application.ikea-prn-generate-file-task.netValueAccount.desc").type((Type)Types.STRING).create()).parameter().id("taxAccounts").name("application.ikea-prn-generate-file-task.taxAccounts.name").description("application.ikea-prn-generate-file-task.taxAccounts.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("countedTaxAccount").name("application.ikea-prn-generate-file-task.countedTaxAccount.name").description("application.ikea-prn-generate-file-task.countedTaxAccount.desc").type((Type)Types.STRING).create()).parameter().id("dueTaxAccount").name("application.ikea-prn-generate-file-task.dueTaxAccount.name").description("application.ikea-prn-generate-file-task.dueTaxAccount.desc").type((Type)Types.STRING).create()).parameter().id("reversCharge").name("application.ikea-prn-generate-file-task.reversCharge.name").description("application.ikea-prn-generate-file-task.reversCharge.desc").type((Type)Types.STRING).create()).parameter().id("invoiceType").name("application.ikea-prn-generate-file-task.invoiceType.name").description("application.ikea-prn-generate-file-task.invoiceType.desc").type((Type)Types.STRING).create()).parameter().id("facility").name("application.ikea-prn-generate-file-task.factory.name").description("application.ikea-prn-generate-file-task.factory.desc").type((Type)Types.STRING).create();
    }

    public static void execute(ActivityContextMap activityContextMap, @Param String prnFilePrefix, @Param String prnSubDirectory, @Param LocalDate invoiceDate, @Param LocalDate paymentDate, @Param LocalDate postingDate, @Param LocalDate incomingDate, @Param LocalDate deliveryDate, @Param Double[] netAmount, @Param Double grossAmount, @Param Double[] taxAmount, @Param String[] taxCode, @Param String currency, @Param Double exchangeRate, @Param String invoiceNo, @Param String supplierId, @Param String paymentMethod, @Param String responsible, @Param String bankAccount, @Param String bankAccountId, @Param String supplierDomesticCountry, @Param String supplierAccount, @Param String netValueAccount, @Param String[] taxAccounts, @Param String countedTaxAccount, @Param String dueTaxAccount, @Param String reversCharge, @Param String invoiceType, @Param String facility) throws Exception {
        log.info("*************** START: GeneratePreliminaryPrnFile ******** ");
        try {
            int i;
            Long lPrnNr;
            File file;
            long lGroupNo = 1L;
            Object sPrnFileSeq = "seq_prelim_prn";
            Object sGroupSeq = "seq_groupno";
            String sCredit = "C";
            String sDebit = "D";
            String sFilePrefix = prnFilePrefix;
            sPrnFileSeq = sFilePrefix + "_" + (String)sPrnFileSeq;
            sGroupSeq = sFilePrefix + "_" + (String)sGroupSeq;
            Object sUserDirectory = ServiceFactory.getSystemParameterService().getParameter("PRNDirectory").getValueString();
            log.debug("PRNDirectory:" + (String)sUserDirectory);
            long lNrPrzebiegu = 1L;
            if (!((String)sUserDirectory).endsWith("/")) {
                sUserDirectory = (String)sUserDirectory + "/";
            }
            if (StringUtils.isNotEmpty((String)prnSubDirectory)) {
                sUserDirectory = ((String)sUserDirectory).concat(prnSubDirectory).concat("/");
            }
            if ((file = new File((String)sUserDirectory + sFilePrefix + String.valueOf(lPrnNr = Tools.getCurrentSequenceValue((String)sPrnFileSeq)) + ".prn")).exists()) {
                lGroupNo = ServiceFactory.getSequenceService().getNextSequenceValue((String)sGroupSeq) + 1L;
                log.info("File " + file.getAbsolutePath() + " exist. lGroupNo: " + lGroupNo);
            } else {
                lPrnNr = ServiceFactory.getSequenceService().getNextSequenceValue((String)sPrnFileSeq);
                Tools.removeSequence((String)sGroupSeq);
                lGroupNo = 1L;
                file = new File((String)sUserDirectory + sFilePrefix + String.valueOf(lPrnNr) + ".prn");
                log.info("System will create a new PRN file: " + file.getAbsolutePath());
            }
            if (invoiceType.compareToIgnoreCase("Corrective invoices") == 0 && grossAmount < 0.0) {
                sCredit = "D";
                sDebit = "C";
                grossAmount = -1.0 * grossAmount;
            }
            String sDataWystawienia = invoiceDate == null ? "" : invoiceDate.toString("yyyyMMdd");
            String sTerminPlatnosci = paymentDate == null ? "" : paymentDate.toString("yyyyMMdd");
            String sDataWplywu = incomingDate == null ? "" : incomingDate.toString("yyyyMMdd");
            String sDataDostawy = deliveryDate == null ? "" : deliveryDate.toString("yyyyMMdd");
            FileWriter fileWriter = new FileWriter(file, true);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            String[] row1 = new String[]{"I1", String.valueOf(lNrPrzebiegu), String.valueOf(lGroupNo), supplierId, supplierId, invoiceNo, sDataWystawienia, sTerminPlatnosci, String.valueOf(Math.abs(grossAmount)), "", "", currency, "01", String.valueOf(exchangeRate), sDataWplywu, responsible, supplierAccount, bankAccountId, sCredit, sDataDostawy, facility, paymentMethod};
            bufferedWriter.append(Tools.generateRow(row1));
            bufferedWriter.newLine();
            boolean bEmptyI2Line = true;
            for (i = 0; i < netAmount.length; ++i) {
                if (netAmount[i] == 0.0) continue;
                bEmptyI2Line = false;
                String[] row2 = new String[]{"I2", String.valueOf(lNrPrzebiegu), String.valueOf(lGroupNo), supplierId, supplierId, invoiceNo, sDataWystawienia, sTerminPlatnosci, String.valueOf(Math.abs(netAmount[i])), taxCode[i], "", currency, "01", String.valueOf(exchangeRate), sDataWplywu, responsible, netValueAccount, "", sDebit, "", facility};
                bufferedWriter.append(Tools.generateRow(row2));
                bufferedWriter.newLine();
            }
            if (bEmptyI2Line) {
                String[] row2 = new String[]{"I2", String.valueOf(lNrPrzebiegu), String.valueOf(lGroupNo), supplierId, supplierId, invoiceNo, sDataWystawienia, sTerminPlatnosci, String.valueOf(Math.abs(grossAmount)), "", "", currency, "01", String.valueOf(exchangeRate), sDataWplywu, responsible, netValueAccount, "", sDebit, "", facility};
                bufferedWriter.append(Tools.generateRow(row2));
                bufferedWriter.newLine();
            }
            log.debug("netAmount: " + Arrays.toString((Object[])netAmount));
            log.debug("taxAccounts: " + Arrays.toString(taxAccounts));
            log.debug("taxCode: " + Arrays.toString(taxCode));
            log.debug("supplierDomesticCountry: " + supplierDomesticCountry);
            log.debug("reversCharge: " + reversCharge);
            for (i = 0; i < netAmount.length; ++i) {
                if (netAmount[i] == 0.0) continue;
                log.debug("taxAmount[i]:" + i + ":" + taxAmount[i] + "|taxCode:" + taxCode[i]);
                if (taxAmount[i] == 0.0) continue;
                String[] row3 = new String[]{"I3", String.valueOf(lNrPrzebiegu), String.valueOf(lGroupNo), supplierId, supplierId, invoiceNo, sDataWystawienia, sTerminPlatnosci, String.valueOf(Math.abs(taxAmount[i])), taxCode[i], "", currency, "01", String.valueOf(exchangeRate), sDataWplywu, responsible, taxAccounts[i], "", sDebit, "", facility};
                bufferedWriter.append(Tools.generateRow(row3));
                bufferedWriter.newLine();
            }
            ArrayList<String> reverseChareTaxCodes = new ArrayList<String>();
            reverseChareTaxCodes.add("5");
            reverseChareTaxCodes.add("8");
            reverseChareTaxCodes.add("15");
            reverseChareTaxCodes.add("16");
            reverseChareTaxCodes.add("18");
            reverseChareTaxCodes.add("28");
            reverseChareTaxCodes.add("29");
            reverseChareTaxCodes.add("30");
            reverseChareTaxCodes.add("32");
            reverseChareTaxCodes.add("33");
            reverseChareTaxCodes.add("38");
            reverseChareTaxCodes.add("39");
            reverseChareTaxCodes.add("95");
            reverseChareTaxCodes.add("96");
            reverseChareTaxCodes.add("97");
            if (reversCharge.equals("TAK") || reversCharge.equals("YES")) {
                log.debug("odwrotne_obciazenie tylko dla wybranych kod\u00f3w VAT");
                for (int i2 = 0; i2 < netAmount.length; ++i2) {
                    log.debug("taxAmount[i]:" + i2 + ":" + taxAmount[i2] + "|taxCode:" + taxCode[i2]);
                    if (netAmount[i2] == 0.0 || !reverseChareTaxCodes.contains(taxCode[i2])) continue;
                    log.debug("taxAmount[i]:" + i2 + ":" + taxAmount[i2]);
                    if (taxAmount[i2] == 0.0) continue;
                    row3 = new String[]{"I3", String.valueOf(lNrPrzebiegu), String.valueOf(lGroupNo), supplierId, supplierId, invoiceNo, sDataWystawienia, sTerminPlatnosci, String.valueOf(Math.abs(taxAmount[i2])), taxCode[i2], "", currency, "01", String.valueOf(exchangeRate), sDataWplywu, responsible, dueTaxAccount, "", sCredit, "", facility};
                    bufferedWriter.append(Tools.generateRow(row3));
                    bufferedWriter.newLine();
                }
            } else if (supplierDomesticCountry.equals("NIE") || supplierDomesticCountry.equals("NO")) {
                log.debug("Dostawca NIP nie PL");
                for (int i3 = 0; i3 < netAmount.length; ++i3) {
                    if (netAmount[i3] == 0.0) continue;
                    log.debug("taxAmount[i]:" + i3 + ":" + taxAmount[i3] + "|taxCode:" + taxCode[i3]);
                    if (taxAmount[i3] == 0.0) continue;
                    row3 = new String[]{"I3", String.valueOf(lNrPrzebiegu), String.valueOf(lGroupNo), supplierId, supplierId, invoiceNo, sDataWystawienia, sTerminPlatnosci, String.valueOf(Math.abs(taxAmount[i3])), taxCode[i3], "", currency, "01", String.valueOf(exchangeRate), sDataWplywu, responsible, countedTaxAccount, "", sCredit, "", facility};
                    bufferedWriter.append(Tools.generateRow(row3));
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.close();
            fileWriter.close();
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                String sDate = sdf.format(new Date());
                String sWorkingDirectory = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY);
                log.debug("Copy o file:" + sWorkingDirectory + sFilePrefix + String.valueOf(lPrnNr) + "_" + sDate + ".prn");
                File dest = new File(sWorkingDirectory + sFilePrefix + String.valueOf(lPrnNr) + "_" + sDate + ".prn");
                FileUtils.copyFile((File)file, (File)dest);
            }
            catch (Exception e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
    }
}

