/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.fibaro.dc;

import com.suncode.dbexplorer.DatabaseExplorer;
import com.suncode.dbexplorer.database.Database;
import com.suncode.plugin.fibaro.categories.Categories;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinitionBuilder;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import com.suncode.pwfl.workflow.form.datachooser.annotation.DataChooser;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@DataChooser
public class Account {
    private static int iloscWynikow;
    @Autowired
    private DatabaseExplorer dbex;
    public static Logger log;

    @Define
    public void definition(DataChooserDefinitionBuilder builder) {
        ((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)builder.id("account")).name("Account")).description("Account")).icon((Icon)SilkIconPack.APPLICATION_GO)).category(new Category[]{Categories.FIBARO})).parameter().id("filterKey").name("Filter key").description("Filter key").type((Type)Types.STRING).create()).parameter().id("dbName").name("DB name").description("DB name").type((Type)Types.STRING).create()).parameter().id("vendorNo").name("Vendor no").description("Venor no").type((Type)Types.STRING).create()).mapping().id("nazwa").name("Nazwa").description("").create().mapping().id("czy_jednostka").name("Czy jednostka").description("").create().mapping().id("czy_stk").name("Czy STK").description("").create().mapping().id("czy_zlecenia").name("Czy zlecenia").description("").create().mapping().id("czy_transakcje").name("Czy transakcje").description("").create().mapping().id("czy_ppk").name("Czy PPK").description("").create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void data(UserInfo currentUser, ComponentQueryData queryData, Parameters parameters, DataChooserResult result) {
        String filterKey = queryData.getQuery();
        String dbName = (String)parameters.get("dbName");
        String nrKontrahenta = (String)parameters.get("vendorNo");
        Pagination pag = queryData.getPagination();
        Database db = this.dbex.get(dbName);
        Connection con = db.openSession().getConnection();
        int schemaCount = 0;
        boolean newConRequired = false;
        boolean isResult = false;
        log.debug((Object)("Get accounts: " + filterKey + ", " + dbName + ", " + nrKontrahenta));
        try {
            Account.setBasicData(con, nrKontrahenta);
            String query = "SELECT symbol_schematu, nazwa_schematu FROM integr_suncode_schematy";
            CallableStatement statement = con.prepareCall(query);
            ResultSet rs = statement.executeQuery();
            ArrayList rsList = new ArrayList();
            while (rs.next()) {
                HashMap<String, String> rsMap = new HashMap<String, String>();
                String schema = rs.getString(1);
                String name = rs.getString(2);
                rsMap.put("schema", schema);
                rsMap.put("name", name);
                rsList.add(rsMap);
            }
            ArrayList tmpResult = new ArrayList();
            Iterator it = rsList.iterator();
            while (it.hasNext()) {
                try {
                    HashMap oneSchema = (HashMap)it.next();
                    HashMap<String, String> record = new HashMap<String, String>();
                    String schema = (String)oneSchema.get("schema");
                    String name = (String)oneSchema.get("name");
                    if (!schema.toLowerCase().contains(filterKey.toLowerCase()) && !name.toLowerCase().contains(filterKey.toLowerCase()) && !StringUtils.isBlank((CharSequence)filterKey)) continue;
                    record.put("value", schema);
                    record.put("nazwa", name);
                    if (newConRequired) {
                        con = db.openSession().getConnection();
                        Account.setBasicData(con, nrKontrahenta);
                        newConRequired = false;
                    }
                    log.debug((Object)schema);
                    query = "{call fibar_suncode_integr.set_schemat (?)}";
                    statement = con.prepareCall(query);
                    statement.setString(1, schema);
                    isResult = statement.execute();
                    query = "SELECT CZY_WALUTY, CZY_JEDN_ORGAN, CZY_STANOWISKA_KOSZTOW, CZY_KONTRAHENCI, CZY_OSOBY, CZY_ZLECENIA_PRODUKCYJNE, CZY_CZESCI_PRODUKCYJNE, CZY_MAGAZYNY, CZY_TRANSAKCJE, CZY_POZYCJE_KALKULACJI_KOSZTOW, CZY_INNE_KLASYFIKATORY FROM integr_suncode_wymagane_klas";
                    statement = con.prepareCall(query);
                    ResultSet subRs = statement.executeQuery();
                    while (subRs.next()) {
                        record.put("czy_jednostka", Integer.toString(subRs.getInt(2)));
                        record.put("czy_stk", Integer.toString(subRs.getInt(3)));
                        record.put("czy_zlecenia", Integer.toString(subRs.getInt(6)));
                        record.put("czy_transakcje", Integer.toString(subRs.getInt(9)));
                        record.put("czy_ppk", Integer.toString(subRs.getInt(10)));
                    }
                    tmpResult.add(record);
                    if (++schemaCount < 20) continue;
                    con.close();
                    schemaCount = 0;
                    newConRequired = true;
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage());
                    con.close();
                }
            }
            log.debug((Object)("Found: " + tmpResult.size()));
            iloscWynikow = tmpResult.size();
            int nEndItem = pag.getStart() + pag.getLimit();
            int nStartItem = pag.getStart();
            if (nEndItem > iloscWynikow) {
                nEndItem = iloscWynikow;
            }
            if (nStartItem > nEndItem) {
                nStartItem = 0;
            }
            result.setData(tmpResult.subList(nStartItem, nEndItem));
            result.setTotal(iloscWynikow);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public int getDataChooserResultSize(Map<String, String> mCriteria, Map<String, String> mCustomKeys) {
        return iloscWynikow;
    }

    private static void setBasicData(Connection con, String nrKontrahenta) {
        try {
            boolean isResult = false;
            String query = "{call fibar_suncode_integr.set_firma(?)}";
            CallableStatement statement = con.prepareCall(query);
            statement.setString(1, "1");
            isResult = statement.execute();
            String year = Integer.toString(Calendar.getInstance().get(1));
            year = year.substring(2, 4);
            query = "{call fibar_suncode_integr.set_rok(?)}";
            statement = con.prepareCall(query);
            statement.setString(1, year);
            isResult = statement.execute();
            query = "{call fibar_suncode_integr.set_kontrahent (?)}";
            statement = con.prepareCall(query);
            statement.setString(1, nrKontrahenta);
            isResult = statement.execute();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    static {
        log = Logger.getLogger(Account.class);
    }
}

