/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.fibaro;

import com.suncode.dbexplorer.DatabaseExplorer;
import com.suncode.dbexplorer.database.Database;
import com.suncode.plugin.fibaro.categories.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.variable.Variable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class InvoiceCommit {
    @Autowired
    private DatabaseExplorer dbex;
    public static Logger log = Logger.getLogger(InvoiceCommit.class);
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("invoiceCommit")).name("Zatwierdzenie faktury")).description("")).icon((Icon)SilkIconPack.APPLICATION_CASCADE)).category(new Category[]{Categories.FIBARO})).parameter().id("invoice-id").name("Id faktury w Impuls").description("").type((Type)Types.VARIABLE).create()).parameter().id("export-status").name("Status faktury w Impuls").description("").type((Type)Types.VARIABLE).create()).parameter().id("db-name").name("Nazwa bazy").description("").type((Type)Types.STRING).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@Param(value="invoice-id") Variable invoiceId, @Param(value="export-status") Variable exportStatus, @Param(value="db-name") String dbName, ActivityContextMap activityCtxMap) throws Exception {
        block8: {
            log.debug((Object)"Starting InvoiceCommit...");
            boolean check = false;
            try (Connection con = null;){
                Map ctx = activityCtxMap.getVariables();
                log.error((Object)("Invoice commit" + activityCtxMap.getProcessId()));
                String bookingId = (String)invoiceId.getValue();
                Database db = this.dbex.get(dbName);
                con = db.openSession().getConnection();
                if (StringUtils.isBlank((String)bookingId)) break block8;
                try {
                    String query = "{call fibar_suncode_fibar.commit_fs (?,?,?,?,?)}";
                    CallableStatement statement = con.prepareCall(query);
                    statement.setInt(1, Integer.parseInt(bookingId));
                    statement.setInt(2, 1);
                    statement.registerOutParameter(3, 12);
                    statement.registerOutParameter(4, 12);
                    statement.registerOutParameter(5, 12);
                    boolean isResult = statement.execute();
                    String out1 = statement.getString(3);
                    String out2 = statement.getString(4);
                    String out3 = statement.getString(5);
                    log.debug((Object)out1);
                    if (Double.parseDouble(out1) > 0.0) {
                        exportStatus.setValue((Object)"");
                        log.debug((Object)"Successful invoice commit.");
                        break block8;
                    }
                    exportStatus.setValue((Object)out2);
                    log.warn((Object)("Error during invoice commit: " + out2));
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        log.debug((Object)"Finished InsertInvoiceHeader.");
    }
}

