/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.fibaro;

import com.suncode.dbexplorer.DatabaseExplorer;
import com.suncode.dbexplorer.database.Database;
import com.suncode.plugin.fibaro.categories.Categories;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.variable.Variable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class InsertInvoiceHeader {
    @Autowired
    private DatabaseExplorer dbex;
    public static Logger log = Logger.getLogger(InsertInvoiceHeader.class);
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("insertHeader")).name("Wstawianie nag\u0142\u00f3wka faktury")).description("")).icon((Icon)SilkIconPack.APPLICATION_CASCADE)).category(new Category[]{Categories.FIBARO})).parameter().id("invoice-id").name("Id faktury w Impuls").description("").type((Type)Types.VARIABLE).create()).parameter().id("export-status").name("Status faktury w Impuls").description("").type((Type)Types.VARIABLE).create()).parameter().id("db-name").name("Nazwa bazy").description("").type((Type)Types.STRING).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@Param(value="invoice-id") Variable invoiceId, @Param(value="export-status") Variable exportStatus, @Param(value="db-name") String dbName, ActivityContextMap activityCtxMap) throws Exception {
        log.debug((Object)"Starting InsertInvoiceHeader...");
        boolean check = false;
        try (Connection con = null;){
            Map ctx = activityCtxMap.getVariables();
            log.error((Object)("Header export procedure for process: " + activityCtxMap.getProcessId()));
            String bookingId = (String)invoiceId.getValue();
            String bookingStatus = (String)exportStatus.getValue();
            if (StringUtils.isBlank((String)bookingId)) {
                String year = Integer.toString(Calendar.getInstance().get(1));
                year = year.substring(2, 4);
                java.util.Date date = new java.util.Date();
                double dInvoiceNetPLN = (Double)((Variable)ctx.get("kwota_netto_pln")).getValue();
                double dInvoiceGrossPLN = (Double)((Variable)ctx.get("kwota_brutto_pln")).getValue();
                double dInvoiceNet = (Double)((Variable)ctx.get("kwota_netto_w_walucie")).getValue();
                double dInvoiceGross = (Double)((Variable)ctx.get("kwota_brutto_w_walucie")).getValue();
                double dInvoiceVatPLN = dInvoiceGrossPLN - dInvoiceNetPLN;
                double dInvoiceVat = dInvoiceGross - dInvoiceNet;
                double dExchangeRate = (Double)((Variable)ctx.get("kurs_waluty")).getValue();
                LocalDate dInvoiceDate = (LocalDate)((Variable)ctx.get("data_wystawienia_dokume")).getValue();
                String sInvoiceDate = dInvoiceDate.toString();
                String paymentType = (String)((Variable)ctx.get("forma_platnosci")).getValue();
                String paymentTypeCode = (String)((Variable)ctx.get("kod_formy_platnosci")).getValue();
                double paidWithCashPLN = 0.0;
                double paidWithCash = 0.0;
                if (paymentType.equalsIgnoreCase("got\u00f3wka")) {
                    paidWithCashPLN = dInvoiceGrossPLN;
                    paidWithCash = dInvoiceGross;
                }
                String sExchangeRateDate = sdf.format(InsertInvoiceHeader.addDays(sdf.parse(sInvoiceDate)));
                String wfInvId = (String)((Variable)ctx.get("id_dokumentu")).getValue();
                String httplink = SystemProperties.getString((String)"HTTPLink");
                StringBuilder linkSb = new StringBuilder();
                linkSb.append(httplink);
                linkSb.append("ShowDocumentFromArchive.do?type=docclass&objectName=Faktury&indexName=Id%20dokumentu&value=");
                linkSb.append(wfInvId);
                Database db = this.dbex.get(dbName);
                con = db.openSession().getConnection();
                String query = "{call fibar_suncode_fibar.insert_fs3 (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}";
                CallableStatement statement = con.prepareCall(query);
                statement.setString(1, "1");
                statement.setInt(2, Integer.parseInt(year));
                statement.setString(3, (String)((Variable)ctx.get("rodzaj_faktury")).getValue());
                statement.setString(4, (String)((Variable)ctx.get("numer_faktury")).getValue());
                statement.setDate(5, InsertInvoiceHeader.convertUtilToSql(((Variable)ctx.get("data_wystawienia_dokume")).getValue().toString()));
                statement.setDate(6, InsertInvoiceHeader.convertUtilToSql(((Variable)ctx.get("data_wplywu_dokumentu")).getValue().toString()));
                statement.setDouble(7, dInvoiceNetPLN);
                statement.setDouble(8, dInvoiceVatPLN);
                statement.setDouble(9, dInvoiceGrossPLN);
                statement.setDouble(10, paidWithCashPLN);
                statement.setString(11, null);
                statement.setDate(12, InsertInvoiceHeader.convertUtilToSql(((Variable)ctx.get("data_wplywu_dokumentu")).getValue().toString()));
                statement.setInt(13, Integer.parseInt((String)((Variable)ctx.get("nr_dostawcy")).getValue()));
                statement.setString(14, (String)((Variable)ctx.get("nip")).getValue());
                statement.setString(15, (String)((Variable)ctx.get("uwagi")).getValue());
                statement.setString(16, (String)((Variable)ctx.get("waluta")).getValue());
                statement.setDouble(17, dExchangeRate);
                statement.setDouble(18, dInvoiceNet);
                statement.setDouble(19, paidWithCash);
                statement.setInt(20, Integer.parseInt(paymentTypeCode));
                statement.setDate(21, InsertInvoiceHeader.convertUtilToSql(((Variable)ctx.get("termin_platnosci")).getValue().toString()));
                statement.setString(22, null);
                statement.setString(23, (String)((Variable)ctx.get("nr_rachunku_bankowego")).getValue());
                statement.setInt(24, Integer.parseInt((String)((Variable)ctx.get("nr_dostawcy")).getValue()));
                statement.setString(25, (String)((Variable)ctx.get("nip")).getValue());
                statement.setDouble(26, dInvoiceNet);
                statement.setDouble(27, dInvoiceVat);
                statement.setString(28, null);
                statement.setDate(29, InsertInvoiceHeader.convertUtilToSql(sExchangeRateDate));
                statement.setString(30, wfInvId);
                statement.setString(31, linkSb.toString());
                statement.setString(32, (String)((Variable)ctx.get("_id_faktury_korygowanej")).getValue());
                statement.setString(33, InsertInvoiceHeader.getContextStringOrNull(ctx, "numer_ksef"));
                statement.setDate(34, InsertInvoiceHeader.getContextDateOrNull(ctx, "data_ksef"));
                statement.registerOutParameter(35, 12);
                statement.registerOutParameter(36, 12);
                statement.registerOutParameter(37, 12);
                boolean isResult = statement.execute();
                String out1 = statement.getString(35);
                String out2 = statement.getString(36);
                String out3 = statement.getString(37);
                if (Integer.parseInt(out1) > 0) {
                    bookingId = out1;
                    bookingStatus = "";
                    log.debug((Object)("Successful invoice header export: " + out1));
                } else {
                    bookingStatus = out2;
                    log.warn((Object)("Error during invoice header export: " + out2));
                }
                invoiceId.setValue((Object)bookingId);
                exportStatus.setValue((Object)bookingStatus);
            } else {
                log.error((Object)"Header already exported! Skipping procedure...");
            }
        }
        log.debug((Object)"Finished InsertInvoiceHeader.");
    }

    private static Date convertUtilToSql(String date) {
        Date sDate = null;
        try {
            java.util.Date dDate = sdf.parse(date);
            sDate = new Date(dDate.getTime());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sDate;
    }

    private static java.util.Date addDays(java.util.Date dt) {
        Calendar c = Calendar.getInstance();
        c.setTime(dt);
        c.add(5, 1);
        dt = c.getTime();
        return dt;
    }

    private static String getContextStringOrNull(Map<String, Variable> ctx, String key) {
        if (!ctx.containsKey(key)) {
            return null;
        }
        String val = (String)ctx.get(key).getValue();
        return StringUtils.isBlank((String)val) ? null : val;
    }

    private static Date getContextDateOrNull(Map<String, Variable> ctx, String key) {
        if (!ctx.containsKey(key)) {
            return null;
        }
        try {
            Object val = ctx.get(key).getValue();
            if (val == null) {
                return null;
            }
            return InsertInvoiceHeader.convertUtilToSql(val.toString());
        }
        catch (Exception e) {
            return null;
        }
    }
}

