/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.fibaro.po;

import com.suncode.plugin.fibaro.categories.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFilter;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.search.sql.SimpleSQLFilter;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

@Application
public class ReservePo {
    public static Logger log = Logger.getLogger(ReservePo.class);

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("reservePo")).name("Rezerwacja linii zam\u00f3wienia")).icon((Icon)SilkIconPack.APPLICATION_CASCADE)).description("")).category(new Category[]{Categories.FIBARO})).parameter().id("poNo").name("Nr zam\u00f3wienia").description("").type((com.suncode.pwfl.core.type.Type)Types.STRING_ARRAY).create()).parameter().id("poLineId").name("Id linii zam\u00f3wienia").description("").type((com.suncode.pwfl.core.type.Type)Types.STRING_ARRAY).create()).parameter().id("amount").name("Net amount - to book").description("").type((com.suncode.pwfl.core.type.Type)Types.STRING_ARRAY).create();
    }

    public void execute(@Param(value="poNo") String[] poNo, @Param(value="poLineId") String[] poLineId, @Param(value="amount") String[] amount, ActivityContextMap ctx) {
        log.debug((Object)("ReservePo with PO no: " + poNo));
        try {
            ProcessService ps = ServiceFactory.getProcessService();
            ActivityService as = ServiceFactory.getActivityService();
            ActivityFinder af = FinderFactory.getActivityFinder();
            HashMap<String, String> poProcessId = new HashMap<String, String>();
            String processId = "";
            double tmpValue = 0.0;
            for (int i = 0; i < poNo.length; ++i) {
                if (StringUtils.isBlank((CharSequence)poNo[i])) {
                    log.debug((Object)"Non-PO line, continue...");
                    continue;
                }
                if (!poProcessId.containsKey(poNo[i])) {
                    processId = ReservePo.getPoProcessIdByIdx("nr_zlecenia", poNo[i]);
                    poProcessId.put(poNo[i], processId);
                } else {
                    processId = (String)poProcessId.get(poNo[i]);
                }
                log.debug((Object)("Searching for line: " + poLineId[i]));
                Map poCtx = ps.getProcessContext(processId);
                String[] tPoLineId = poCtx.get("id_pozycji").toString().split(";", -1);
                CharSequence[] tBookedValue = poCtx.get("wartosc_wykorzystana").toString().split(";", -1);
                for (int x = 0; x < tPoLineId.length; ++x) {
                    if (!poLineId[i].equalsIgnoreCase(tPoLineId[x])) continue;
                    log.debug((Object)("Adding booked value to line " + tPoLineId[x] + " with value " + amount[i]));
                    tmpValue = Double.parseDouble((String)tBookedValue[x]) + Double.parseDouble(amount[i]);
                    tBookedValue[x] = Double.toString(tmpValue);
                }
                log.debug((Object)("Values added to PO process: " + String.join((CharSequence)";", tBookedValue)));
                poCtx.put("ilosc_rozliczona", String.join((CharSequence)";", tBookedValue));
                List poActivities = af.findByProcessId(processId, new String[0]);
                ps.setProcessContext(processId, poCtx);
                for (Activity activity : poActivities) {
                    as.setActivityContext(processId, activity.getActivityId(), poCtx);
                }
            }
            log.debug((Object)"ReservePo finished.");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static String getPoProcessIdByIdx(String idxName, String idxValue) {
        Map rec;
        String processId = "";
        SQLBuilder builder = new SQLBuilder();
        SQLFinder finder = FinderFactory.getSQLFinder();
        String query = "SELECT processid FROM pm_idx_zapotrzebow";
        builder.setQuery(query);
        builder.addScalar("processid", (Type)StandardBasicTypes.STRING);
        builder.addFilter((SQLFilter)new SimpleSQLFilter(idxName, (Object)idxValue, FilterOperator.EQ));
        log.debug((Object)(query + " with " + idxName + " | " + idxValue));
        List data = finder.find(builder);
        log.debug((Object)("Results: " + data.size()));
        Iterator iterator = data.iterator();
        while (iterator.hasNext() && StringUtils.isBlank((CharSequence)(processId = (String)(rec = (Map)iterator.next()).get("processid")))) {
        }
        return processId;
    }
}

