/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.fibaro.dc;

import com.suncode.dbexplorer.DatabaseExplorer;
import com.suncode.dbexplorer.database.Database;
import com.suncode.plugin.fibaro.categories.Categories;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinitionBuilder;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import com.suncode.pwfl.workflow.form.datachooser.annotation.DataChooser;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@DataChooser
public class Transaction {
    private static int iloscWynikow;
    @Autowired
    private DatabaseExplorer dbex;
    public static Logger log;

    @Define
    public void definition(DataChooserDefinitionBuilder builder) {
        ((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)builder.id("transaction")).name("Transaction")).description("Transaction")).icon((Icon)SilkIconPack.APPLICATION_GO)).category(new Category[]{Categories.FIBARO})).parameter().id("filterKey").name("Filter key").description("Filter key").type((Type)Types.STRING).create()).parameter().id("dbName").name("DB name").description("DB name").type((Type)Types.STRING).create()).parameter().id("vendorNo").name("Vendor no").description("Venor no").type((Type)Types.STRING).create()).parameter().id("schema").name("schema").description("Schema").type((Type)Types.STRING).create()).mapping().id("amount").name("Warto\u015b\u0107").description("").create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void data(UserInfo currentUser, ComponentQueryData queryData, Parameters parameters, DataChooserResult result) {
        String filterKey = queryData.getQuery();
        String dbName = (String)parameters.get("dbName");
        String schema = (String)parameters.get("schema");
        String nrKontrahenta = (String)parameters.get("vendorNo");
        Pagination pag = queryData.getPagination();
        Database db = this.dbex.get(dbName);
        Connection con = db.openSession().getConnection();
        boolean isResult = false;
        log.debug((Object)("Get Transaction: " + filterKey + ", " + dbName + ", " + schema));
        try {
            Transaction.setBasicData(con, nrKontrahenta, schema);
            ArrayList tmpResult = new ArrayList();
            String query = "SELECT TRANSAKCJA, WARTOSC_WALUTA FROM INTEGR_SUNCODE_TRANSAKCJE";
            CallableStatement statement = con.prepareCall(query);
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                if (!rs.getString(1).toLowerCase().contains(filterKey)) continue;
                HashMap<String, Object> record = new HashMap<String, Object>();
                record.put("value", rs.getString(1));
                record.put("amount", rs.getDouble(2));
                tmpResult.add(record);
            }
            log.debug((Object)("Found: " + tmpResult.size()));
            iloscWynikow = tmpResult.size();
            int nEndItem = pag.getStart() + pag.getLimit();
            int nStartItem = pag.getStart();
            if (nEndItem > iloscWynikow) {
                nEndItem = iloscWynikow;
            }
            if (nStartItem > nEndItem) {
                nStartItem = 0;
            }
            result.setData(tmpResult.subList(nStartItem, nEndItem));
            result.setTotal(iloscWynikow);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public int getDataChooserResultSize(Map<String, String> mCriteria, Map<String, String> mCustomKeys) {
        return iloscWynikow;
    }

    private static void setBasicData(Connection con, String nrKontrahenta, String schema) {
        try {
            boolean isResult = false;
            String query = "{call fibar_suncode_integr.set_firma(?)}";
            CallableStatement statement = con.prepareCall(query);
            statement.setString(1, "1");
            isResult = statement.execute();
            String year = Integer.toString(Calendar.getInstance().get(1));
            year = year.substring(2, 4);
            query = "{call fibar_suncode_integr.set_rok(?)}";
            statement = con.prepareCall(query);
            statement.setString(1, year);
            isResult = statement.execute();
            query = "{call fibar_suncode_integr.set_kontrahent (?)}";
            statement = con.prepareCall(query);
            statement.setString(1, nrKontrahenta);
            isResult = statement.execute();
            query = "{call fibar_suncode_integr.set_schemat (?)}";
            statement = con.prepareCall(query);
            statement = con.prepareCall(query);
            statement.setString(1, schema);
            isResult = statement.execute();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    static {
        log = Logger.getLogger(Transaction.class);
    }
}

