/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.fibaro;

import com.suncode.cuf.math.MathFunctions;
import com.suncode.dbexplorer.DatabaseExplorer;
import com.suncode.dbexplorer.database.Database;
import com.suncode.plugin.fibaro.categories.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.variable.Variable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class InsertInvoiceLines {
    @Autowired
    private DatabaseExplorer dbex;
    public static Logger log = Logger.getLogger(InsertInvoiceLines.class);
    private static String vat_excluded = "oo;np;zw";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("insertLines")).name("Wstawianie linii faktury")).description("")).icon((Icon)SilkIconPack.APPLICATION_CASCADE)).category(new Category[]{Categories.FIBARO})).parameter().id("invoice-id").name("Id faktury w Impuls").description("").type((Type)Types.VARIABLE).create()).parameter().id("export-status").name("Status faktury w Impuls").description("").type((Type)Types.VARIABLE).create()).parameter().id("db-name").name("Nazwa bazy").description("").type((Type)Types.STRING).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@Param(value="invoice-id") Variable invoiceId, @Param(value="export-status") Variable exportStatus, @Param(value="db-name") String dbName, ActivityContextMap activityCtxMap) throws Exception {
        log.debug((Object)"Starting InsertInvoiceLines...");
        boolean check = false;
        try (Connection con = null;){
            Map ctx = activityCtxMap.getVariables();
            log.error((Object)("Lines export procedure for process: " + activityCtxMap.getProcessId()));
            Variable bookingId = (Variable)ctx.get("id_ksiegowania");
            Variable bookingStatus = (Variable)ctx.get("status_eksportu");
            double dExchangeRate = (Double)((Variable)ctx.get("kurs_waluty")).getValue();
            String year = Integer.toString(Calendar.getInstance().get(1));
            year = year.substring(2, 4);
            Date date = new Date();
            String[] tSchema = (String[])((Variable)ctx.get("konto")).getValue();
            String[] tVatCode = (String[])((Variable)ctx.get("stawka_vat")).getValue();
            Double[] tNetAmount = (Double[])((Variable)ctx.get("kwota_czastkowa")).getValue();
            String[] tOu = (String[])((Variable)ctx.get("jednostka_organizacyjna")).getValue();
            String[] tCC = (String[])((Variable)ctx.get("stk")).getValue();
            String[] tPPK = (String[])((Variable)ctx.get("ppk")).getValue();
            String[] tOrder = (String[])((Variable)ctx.get("nr_projektu")).getValue();
            String[] tDescr = (String[])((Variable)ctx.get("opis_pozycji")).getValue();
            String[] tTransaction = (String[])((Variable)ctx.get("transakcja")).getValue();
            Database db = this.dbex.get(dbName);
            con = db.openSession().getConnection();
            Double vat = 0.0;
            Double net = 0.0;
            Double gross = 0.0;
            Double vatPLN = 0.0;
            Double netPLN = 0.0;
            Double grossPLN = 0.0;
            for (int i = 0; i < tNetAmount.length; ++i) {
                net = tNetAmount[i];
                String vat_code = tVatCode[i];
                vat = !vat_excluded.contains(vat_code) && !StringUtils.isBlank((CharSequence)vat_code) ? Double.valueOf(net * (Double.parseDouble(vat_code) / 100.0)) : Double.valueOf(0.0);
                gross = net + vat;
                netPLN = MathFunctions.round((double)(net * dExchangeRate), (int)2);
                vatPLN = MathFunctions.round((double)(vat * dExchangeRate), (int)2);
                grossPLN = MathFunctions.round((double)(gross * dExchangeRate), (int)2);
                log.debug((Object)("Line " + i + " amounts: " + net + ", " + vat + ", " + gross));
                String query = "{call fibar_suncode_fibar.insert_pozfs (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}";
                CallableStatement statement = con.prepareCall(query);
                statement.setInt(1, Integer.parseInt((String)bookingId.getValue()));
                statement.setString(2, vat_code);
                statement.setDouble(3, (double)netPLN);
                statement.setDouble(4, (double)vatPLN);
                statement.setDouble(5, (double)grossPLN);
                statement.setDouble(6, (double)gross);
                statement.setString(7, tOu[i]);
                statement.setString(8, tCC[i]);
                statement.setString(9, tPPK[i]);
                statement.setString(10, tOrder[i]);
                statement.setString(11, tSchema[i]);
                statement.setString(12, "        " + tTransaction[i]);
                statement.setDouble(13, (double)net);
                statement.setDouble(14, (double)vat);
                statement.setString(15, tDescr[i]);
                statement.registerOutParameter(16, 12);
                statement.registerOutParameter(17, 12);
                statement.registerOutParameter(18, 12);
                boolean isResult = statement.execute();
                String out1 = statement.getString(16);
                String out2 = statement.getString(17);
                String out3 = statement.getString(18);
                if (Integer.parseInt(out1) > 0) {
                    bookingStatus.setValue((Object)"");
                    log.debug((Object)("Successful invoice lines export: " + out1));
                } else {
                    bookingStatus.setValue((Object)out2);
                    log.warn((Object)("Error during invoice lines export: " + out2));
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)bookingStatus.getValue()))) continue;
                InsertInvoiceLines.revertInvoice(con, (String)bookingId.getValue());
                break;
            }
            exportStatus.setValue(bookingStatus.getValue());
        }
        log.debug((Object)"Finished InsertInvoiceHeader.");
    }

    public static String revertInvoice(Connection con, String bookingId) {
        String result = "";
        try {
            String query = "{call fibar_suncode_fibar.commit_fs (?,?,?,?,?)}";
            CallableStatement statement = con.prepareCall(query);
            statement.setInt(1, Integer.parseInt(bookingId));
            statement.setInt(2, 2);
            statement.registerOutParameter(3, 12);
            statement.registerOutParameter(4, 12);
            statement.registerOutParameter(5, 12);
            boolean isResult = statement.execute();
            String out1 = statement.getString(15);
            String out2 = statement.getString(16);
            String out3 = statement.getString(17);
            if (Integer.parseInt(out1) > 0) {
                log.debug((Object)"Successful invoice deletion.");
            } else {
                log.warn((Object)("Error during invoice deletion: " + out2));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

