/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.fibaro;

import com.suncode.plugin.fibaro.categories.Categories;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFilter;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.search.sql.SimpleSQLFilter;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

@Application
public class CheckApprovals {
    public static Logger log = Logger.getLogger(CheckApprovals.class);
    private static String _matrix = "pm_cust_approval_matrix";
    private static String _continue_approval = "akceptacja";
    private static String _finish_approval = "realizacja";

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("checkApprovals")).name("Pobieranie akceptuj\u0105cych")).description("Pobieranie akceptuj\u0105cych zgonie ze struktur\u0105 organizacyjn\u0105 i okre\u015blonym limitem")).icon((Icon)SilkIconPack.APPLICATION_CASCADE)).category(new Category[]{Categories.FIBARO})).parameter().id("user").name("Opisuj\u0105cy").description("").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("supervisor").name("Prze\u0142o\u017cony").description("").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("supervisor_approval").name("Prze\u0142o\u017cony - status akceptacji").description("").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("value").name("Warto\u015b\u0107").description("").type((com.suncode.pwfl.core.type.Type)Types.FLOAT).create()).parameter().id("ceoCfoApproval").name("Akceptacja zarz\u0105du").description("").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("actionVar").name("Zmienna steruj\u0105ca").description("").type((com.suncode.pwfl.core.type.Type)Types.VARIABLE).create()).parameter().id("nextApprover").name("Nast\u0119pny akceptuj\u0105cy").description("").type((com.suncode.pwfl.core.type.Type)Types.VARIABLE).create();
    }

    public static void execute(@Param(value="user") String user, @Param(value="supervisor") String supervisor, @Param(value="supervisor_approval") String supervisor_approval, @Param(value="value") Double value, @Param(value="ceoCfoApproval") Variable ceoCfoApproval, @Param(value="actionVar") Variable actionVar, @Param(value="nextApprover") Variable nextApprover, ActivityContextMap activityCtxMap) throws Exception {
        log.debug((Object)"Starting CheckApprovals...");
        boolean check = false;
        try {
            String approver = (String)nextApprover.getValue();
            if (StringUtils.isBlank((CharSequence)approver)) {
                log.debug((Object)"Empty approver, checking user limit");
                check = CheckApprovals.hasLimit(user, value);
                if (check) {
                    actionVar.setValue((Object)_finish_approval);
                    log.debug((Object)"Finish approval at user");
                } else {
                    log.debug((Object)"Empty approver, checking supervisor limit");
                    check = CheckApprovals.hasLimit(supervisor, value);
                    if (check && supervisor_approval.equalsIgnoreCase("tak")) {
                        actionVar.setValue((Object)_finish_approval);
                        log.debug((Object)"Finish approval at supervisor");
                    } else if (check && supervisor_approval.equalsIgnoreCase("nie")) {
                        log.debug((Object)("Next approver (supervisor): " + supervisor));
                        nextApprover.setValue((Object)supervisor);
                        actionVar.setValue((Object)_continue_approval);
                    } else {
                        approver = CheckApprovals.getSupervisor(supervisor);
                        log.debug((Object)("Next approver: " + approver));
                        nextApprover.setValue((Object)approver);
                        actionVar.setValue((Object)_continue_approval);
                    }
                }
            } else {
                log.debug((Object)"Process during finance approval, checking current user limit");
                String ceo_cfo_approval = (String)ceoCfoApproval.getValue();
                check = CheckApprovals.hasLimit(approver, value);
                if (check || ceo_cfo_approval.equalsIgnoreCase("tak")) {
                    actionVar.setValue((Object)_finish_approval);
                    log.debug((Object)"Finish approval");
                } else {
                    Position position = CheckApprovals.getUserPosition(approver);
                    approver = CheckApprovals.getSupervisor(approver);
                    if (position.getSymbol().equalsIgnoreCase("ceo") || position.getSymbol().equalsIgnoreCase("cfo")) {
                        ceoCfoApproval.setValue((Object)"TAK");
                    }
                    log.debug((Object)("Next approver: " + approver));
                    nextApprover.setValue((Object)approver);
                    actionVar.setValue((Object)_continue_approval);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.debug((Object)"Finished CheckApprovals.");
    }

    private static boolean hasLimit(String login, Double value) {
        boolean result = false;
        SQLBuilder builder = new SQLBuilder();
        SQLFinder finder = FinderFactory.getSQLFinder();
        builder.setQuery("SELECT login, amount FROM " + _matrix);
        builder.addScalar("login", (Type)StandardBasicTypes.STRING);
        builder.addScalar("amount", (Type)StandardBasicTypes.FLOAT);
        builder.addFilter((SQLFilter)new SimpleSQLFilter("login", (Object)login, FilterOperator.EQ));
        builder.addFilter((SQLFilter)new SimpleSQLFilter("amount", (Object)value, FilterOperator.GE));
        List data = finder.find(builder);
        log.debug((Object)("Found " + data.size() + " records with parameters: " + login + ", " + value));
        if (data.size() > 0) {
            result = true;
        }
        return result;
    }

    private static String getSupervisor(String login) {
        String result = "";
        PositionFinder pf = FinderFactory.getPositionFinder();
        List positions = pf.findByUserName(login, new String[]{"higherPosition", "higherPosition.user"});
        if (positions.size() > 0) {
            User supervisor = ((Position)positions.get(0)).getHigherPosition().getUser();
            if (supervisor != null) {
                result = supervisor.getUserName();
            }
            if (login.equalsIgnoreCase(result) && positions.size() > 1 && (supervisor = ((Position)positions.get(1)).getHigherPosition().getUser()) != null) {
                result = supervisor.getUserName();
            }
        }
        return result;
    }

    private static double getApprovalMatrixMax() {
        double result = 0.0;
        SQLBuilder builder = new SQLBuilder();
        SQLFinder finder = FinderFactory.getSQLFinder();
        builder.setQuery("SELECT MAX(amount) as max FROM " + _matrix);
        builder.addScalar("max", (Type)StandardBasicTypes.DOUBLE);
        List data = finder.find(builder);
        if (data.size() > 0) {
            result = (Double)((Map)data.get(0)).get("max");
        }
        log.debug((Object)("Matrix max: " + result));
        return result;
    }

    private static Position getUserPosition(String userName) {
        Position result = null;
        PositionFinder pf = FinderFactory.getPositionFinder();
        List positions = pf.findByUserName(userName, new String[0]);
        if (positions.size() > 0) {
            result = (Position)positions.get(0);
        }
        return result;
    }
}

