EXCELDS = {
    t: PW.I18N.createT('com.suncode.plugin-excel-datasources')
}

PW.DataSources.register('excelDatasource', {
    buildParams: function (form, config) {
        form.addCombobox({
            id: 'sourceType',
            valueField: 'id',
            displayField: 'display',
            fields: [
                {name: 'id', type: 'string'},
                {name: 'display', type: 'string'},
            ],
            values: [
                {id: 'local', display: EXCELDS.t('excelDatasource.sourceType.local')},
                {id: 'googleDrive', display: EXCELDS.t('excelDatasource.sourceType.googleDrive')},
            ],
            listeners: {
                change: function (combo, newValue) {
                    if (newValue === 'googleDrive') {
                        form.show('googleDriveConfigId');
                        form.show('googleFileId');
                        form.hide('pathToFile');
                    } else {
                        form.hide('googleDriveConfigId');
                        form.hide('googleFileId');
                        form.show('pathToFile');
                    }
                },
            }
        });

        form.addCombobox({
            id: 'googleDriveConfigId',
            valueField: 'configurationId',
            displayField: 'configurationId',
            fields: [
                {name: 'configurationId', type: 'string'}
            ],
            remote: {
                url: Suncode.getAbsolutePath('plugin/com.suncode.plugin-plus-google-cloud-integrator/configurations'),
                fields: ["configurationId"],
                remoteSort: false,
                pageSize: 20
            }
        });

        form.addField('googleFileId');
        form.addField('pathToFile');
        form.addField('sheetName');

        if (form.getValue('sourceType') === 'googleDrive') {
            form.show('googleDriveConfigId');
            form.show('googleFileId');
        } else {
            form.hide('googleDriveConfigId');
            form.hide('googleFileId');
        }

        switch (config.operation) {
            case "READ":
                form.addField("defaultNumericFormat");
                var pathParametersTable = form.addTable({
                    id: 'pathParametersTable',
                    name: EXCELDS.t('excelDatasource.pathParametersTable')
                });
                pathParametersTable.addField('pathParametersId');
                pathParametersTable.addField('pathParametersName');
                var outputParametersTable = form.addTable({
                    id: 'outputParametersTable',
                    name: EXCELDS.t('excelDatasource.outputParametersTable')
                });
                outputParametersTable.addField('outputParametersId');
                outputParametersTable.addField('outputParametersName');
                outputParametersTable.addField('outputParametersHeader');
                break;
            case "INSERT":
                form.addCombobox({
                    id: 'handleExisting',
                    valueField: 'id',
                    displayField: 'display',
                    fields: [
                        {name: 'id', type: 'string'},
                        {name: 'display', type: 'string'},
                    ],
                    values: [
                        {id: 'extend', display: EXCELDS.t('excelDatasource.extend')},
                        {id: 'override', display: EXCELDS.t('excelDatasource.overwrite')},
                    ],
                });
                let handleExisting = form.form.items.get('handleExisting');
                if (handleExisting.getValue() === null) {
                    handleExisting.setValue('extend');
                }
            case "DELETE":
                var pathParametersTable = form.addTable({
                    id: 'pathParametersTable',
                    name: EXCELDS.t('excelDatasource.pathParametersTable')
                });
                pathParametersTable.addField('pathParametersId');
                pathParametersTable.addField('pathParametersName');
                form.addField('inputParametersHeader');
                break;
            case "UPDATE":
                form.addCombobox({
                    id: 'handleNewKey',
                    valueField: 'id',
                    displayField: 'display',
                    fields: [
                        {name: 'id', type: 'string'},
                        {name: 'display', type: 'string'},
                    ],
                    values: [
                        {id: 'add', display: EXCELDS.t('excelDatasource.add')},
                        {id: 'block', display: EXCELDS.t('excelDatasource.block')},
                        {id: 'pass', display: EXCELDS.t('excelDatasource.pass')},
                    ],
                    listeners: {
                        afterrender: function (field) {
                            if (!form.getValue('handleNewKey')) {
                                form.form.items.get('handleNewKey').setValue('block');
                            }
                        },
                    }
                });
                var pathParametersTable = form.addTable({
                    id: 'pathParametersTable',
                    name: EXCELDS.t('excelDatasource.pathParametersTable')
                });
                pathParametersTable.addField('pathParametersId');
                pathParametersTable.addField('pathParametersName');
                var inputParametersTable = form.addTable({
                    id: 'inputParametersTable',
                });
                inputParametersTable.addField('inputParametersHeader');
                inputParametersTable.addCombobox({
                    id: 'inputParametersType',
                    valueField: 'id',
                    displayField: 'display',
                    fields: [
                        {name: 'id', type: 'string'},
                        {name: 'display', type: 'string'},
                    ],
                    values: [
                        {id: 'pk', display: EXCELDS.t('excelDatasource.primaryKey')},
                        {id: 'param', display: EXCELDS.t('excelDatasource.parameter')},
                    ],
                });
                break;
        }
    }
});