CSVDS = {
	t: PW.I18N.createT('com.suncode.plugin-excel-datasources')
}
PW.DataSources.register('csvDatasource', {
	buildParams: function (form, config) {
		this.buildFileForm(form);
		var pathParametersTable = form.addTable({
			id: 'pathParametersTable',
			name: EXCELDS.t('excelDatasource.pathParametersTable')
		});
		pathParametersTable.addField('pathParametersId');
		pathParametersTable.addField('pathParametersName');
		form.addCombobox({
			id: 'format',
			valueField: 'id',
			displayField: 'display',
			value: 'Default',
			fields: [
				{ name: 'id', type: 'string' },
				{ name: 'display', type: 'string' },
			],
			values: [
				{ id: 'Default', display: "DEFAULT" },
				{ id: 'PLUSWORKFLOW', display: "PLUSWORKFLOW" },
				{ id: 'CUSTOM', display: "CUSTOM" },
				{ id: 'Excel', display: "EXCEL" },
				{ id: 'InformixUnload', display: "INFORMIX_UNLOAD" },
				{ id: 'InformixUnloadCsv', display: "INFORMIX_UNLOAD_CSV" },
				{ id: 'MongoDBCsv', display: "MONGODB_CSV" },
				{ id: 'MongoDBTsv', display: "MONGODB_TSV" },
				{ id: 'MySQL', display: "MYSQL" },
				{ id: 'Oracle', display: "ORACLE" },
				{ id: 'PostgreSQLCsv', display: "POSTGRESQL_CSV" },
				{ id: 'PostgreSQLText', display: "POSTGRESQL_TEXT" },
				{ id: 'RFC4180', display: "RFC4180" },
				{ id: 'TDF', display: "TDF" }
			],
			listeners: {
				change: function () {
					if (form.getValue('format') == 'CUSTOM') {
						form.show('separator');
						form.show("quoteChar");
					} else {
						form.hide('separator');
						form.hide("quoteChar");
						form.form.items.get('separator').setValue('');
						form.form.items.get("quoteChar").setValue('');
					}
				},
				afterrender: function () {
					if (!form.getValue('format')) {
						form.form.items.get('format').setValue('Default');
					}
				},
			}
		});
		form.addField({ id: 'separator', hidden: true });
		form.addField({ id: "quoteChar", hidden: true });
		switch (config.operation) {
			case "READ":
				form.addField({
					id: "useHeaderData",
					listeners: {
						change: function (field, newValue) {
							const items = form.form.down('#outputParametersTable').items;
							if (newValue) {
								for (let i = 0; i < items.length; i++) {
									items.get(i).down('#outputParametersHeader').show();
								}
							} else {
								for (let i = 0; i < items.length; i++) {
									items.get(i).down('#outputParametersHeader').hide();
									if (i > 0) {
										items.get(i).down('#outputParametersHeader').reset();
									}
								}
							}
						},
						afterrender: function (field) {
							const items = form.form.down('#outputParametersTable').items;
							if (!field.getValue()) {
								for (let i = 0; i < items.length; i++) {
									items.get(i).down('#outputParametersHeader').hide();
								}
							}
						},
					}
				});
				var outputParametersTable = form.addTable({
					id: 'outputParametersTable',
					name: CSVDS.t('datasource.label.outputParameter')
				});
				outputParametersTable.addField('outputParametersId');
				outputParametersTable.addField('outputParametersName');
				outputParametersTable.addField('outputParametersHeader');
				outputParametersTable.addCombobox({
					id: 'outputParametersType',
					valueField: 'id',
					displayField: 'display',
					value: 'string',
					fields: [
						{ name: 'id', type: 'string' },
						{ name: 'display', type: 'string' },
					],
					values: [
						{ id: 'STRING', display: CSVDS.t('datasource.type.string') },
						{ id: 'INTEGER', display: CSVDS.t('datasource.type.integer') },
						{ id: 'FLOAT', display: CSVDS.t('datasource.type.float') },
						{ id: 'DATE', display: CSVDS.t('datasource.type.date') },
						{ id: 'DATETIME', display: CSVDS.t('datasource.type.datetime') },
						{ id: 'BOOLEAN', display: CSVDS.t('datasource.type.boolean') }
					],
				});
				break;
			case "DELETE":
				form.addCombobox({
					id: 'deleteType',
					valueField: 'id',
					displayField: 'display',
					value: 'FIRST',
					fields: [
						{ name: 'id', type: 'string' },
						{ name: 'display', type: 'string' },
					],
					values: [
						{ id: 'FIRST', display: CSVDS.t('datasource.deleteType.first') },
						{ id: 'ALL', display: CSVDS.t('datasource.deleteType.all') }
					],
					listeners: {
						afterrender: function () {
							if (!form.getValue('deleteType')) {
								form.form.items.get('deleteType').setValue('FIRST');
							}
						},
					}
				});
				this.buildHandleExistingCombobox(form);
				form.addField('inputParametersHeader');
				break;
			case "INSERT":
				this.buildHandleExistingCombobox(form);
				form.addField('useHeaderData');
				form.addField('inputParametersHeader');
				break;
			case "UPDATE":
				form.addCombobox({
					id: 'handleNewKey',
					valueField: 'id',
					displayField: 'display',
					fields: [
						{ name: 'id', type: 'string' },
						{ name: 'display', type: 'string' },
					],
					values: [
						{ id: 'ADD', display: CSVDS.t('datasource.add') },
						{ id: 'BLOCK', display: CSVDS.t('datasource.block') },
						{ id: 'PASS', display: CSVDS.t('datasource.pass') },
					],
					listeners: {
						afterrender: function () {
							if (!form.getValue('handleNewKey')) {
								form.form.items.get('handleNewKey').setValue('BLOCK');
							}
						},
					}
				});
				form.addField('useHeaderData');
				var inputParametersTable = form.addTable({
					id: 'inputParametersTable',
					name: CSVDS.t('datasource.label.inputParameter')
				});
				inputParametersTable.addField('inputParametersHeader');
				inputParametersTable.addCombobox({
					id: 'inputParametersType',
					valueField: 'id',
					displayField: 'display',
					fields: [
						{ name: 'id', type: 'string' },
						{ name: 'display', type: 'string' },
					],
					values: [
						{ id: 'PRIMARY_KEY', display: CSVDS.t('datasource.primaryKey') },
						{ id: 'COMMON', display: CSVDS.t('datasource.parameter') },
					],
				});
				break;
		}
	},
	buildFileForm: function(form) {
		var row = form.addRow()
		row.addField('pathToFile');
		row.addCombobox({
			id: 'charsetName',
			valueField: 'name',
			displayField: 'name',
			queryCaching: false,
			remote: {
				url: Suncode.getAbsolutePath('plugin/com.suncode.plugin-excel-datasources/form/charsets'),
				fields: ['name'],
				remoteSort: true,
				pageSize: 20
			},
			sort: [{
				property: 'name',
				direction: 'ASC'
			}],
		});
	},

	buildHandleExistingCombobox: function(form) {
		form.addCombobox({
			id: 'handleExisting',
			valueField: 'id',
			displayField: 'display',
			fields: [
				{ name: 'id', type: 'string' },
				{ name: 'display', type: 'string' },
			],
			values: [
				{ id: 'extend', display: CSVDS.t('excelDatasource.extend') },
				{ id: 'override', display: CSVDS.t('excelDatasource.overwrite') },
			],
		});
		let handleExisting = form.form.items.get('handleExisting');
		if (handleExisting.getValue() === null) {
			handleExisting.setValue('extend');
		}
	}
});