/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.excel.writers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SpreadsheetDataWriter {
    public static void writeSheetData(String pathToFile, String sheetName, Map<String, String> parameters, String handleExisting) {
        if (handleExisting.equalsIgnoreCase("override")) {
            SpreadsheetDataWriter.createNewSheetsFile(pathToFile, sheetName, parameters);
            return;
        }
        if (SpreadsheetDataWriter.checkIfSheetFileExists(pathToFile)) {
            SpreadsheetDataWriter.updateSheet(pathToFile, sheetName, parameters);
        } else {
            SpreadsheetDataWriter.createNewSheetsFile(pathToFile, sheetName, parameters);
        }
    }

    private static boolean checkIfSheetFileExists(String filename) {
        return new File(filename).exists();
    }

    private static void updateSheet(String pathToFile, String sheetName, Map<String, String> parameters) {
        try (Workbook workbook = WorkbookFactory.create((InputStream)new FileInputStream(pathToFile));){
            Sheet sheet;
            Sheet sheet2 = sheet = workbook.getSheet(sheetName) != null ? workbook.getSheet(sheetName) : SpreadsheetDataWriter.createNewSheetInFile(workbook, sheetName, parameters);
            if (sheet.getRow(0) == null) {
                SpreadsheetDataWriter.createHeaderCell(sheet, parameters);
            }
            SpreadsheetDataWriter.fillSheet(pathToFile, parameters, workbook, sheet);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static void fillSheet(String pathToFile, Map<String, String> parameters, Workbook workbook, Sheet sheet) throws Throwable {
        int maxLength = parameters.values().stream().mapToInt(s -> s.split(";", -1).length).max().orElse(0);
        List rowsToInsert = IntStream.range(0, maxLength).boxed().map(i -> parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((String)e.getValue()).split(";", -1)[i]))).collect(Collectors.toList());
        int nextRowNo = SpreadsheetDataWriter.getNextRowNo(sheet);
        IntStream.range(0, rowsToInsert.size()).forEach(idx -> SpreadsheetDataWriter.writeValuesToRow(sheet.getRow(0), sheet.createRow(nextRowNo + idx), (Map)rowsToInsert.get(idx)));
        SpreadsheetDataWriter.writeChangesToFile(workbook, pathToFile);
    }

    private static int getNextRowNo(Sheet sheet) {
        int lastRowNum;
        for (int i = lastRowNum = sheet.getLastRowNum(); i >= 0; --i) {
            Row currentRow = sheet.getRow(i);
            if (currentRow == null || currentRow.getLastCellNum() <= -1) continue;
            return i + 1;
        }
        return 0;
    }

    private static void createNewSheetsFile(String pathToFile, String sheetName, Map<String, String> parameters) {
        try (HSSFWorkbook workbook = pathToFile.endsWith(".xls") ? new HSSFWorkbook() : new XSSFWorkbook();){
            Sheet sheet = SpreadsheetDataWriter.createNewSheetInFile((Workbook)workbook, sheetName, parameters);
            SpreadsheetDataWriter.fillSheet(pathToFile, parameters, (Workbook)workbook, sheet);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static Sheet createNewSheetInFile(Workbook workbook, String sheetName, Map<String, String> parameters) {
        Sheet sheet = workbook.createSheet(sheetName);
        SpreadsheetDataWriter.createHeaderCell(sheet, parameters);
        return sheet;
    }

    private static void createHeaderCell(Sheet sheet, Map<String, String> parameters) {
        Row headers = sheet.createRow(0);
        AtomicInteger index = new AtomicInteger(0);
        parameters.keySet().forEach(header -> headers.createCell(index.getAndIncrement()).setCellValue(header));
    }

    public static void writeValuesToRow(Row headers, Row rowToWrite, Map<String, String> parameters) {
        parameters.forEach((header, cellValue) -> {
            AtomicBoolean headerFound = new AtomicBoolean(false);
            headers.forEach(cell -> {
                if (header.equals(cell.getRichStringCellValue().getString())) {
                    rowToWrite.createCell(cell.getColumnIndex()).setCellValue(cellValue);
                    headerFound.set(true);
                    return;
                }
            });
            if (!headerFound.get()) {
                Cell newHeaderCell = headers.createCell((int)headers.getLastCellNum());
                newHeaderCell.setCellValue(header);
                rowToWrite.createCell(newHeaderCell.getColumnIndex()).setCellValue(cellValue);
            }
        });
    }

    public static void writeChangesToFile(Workbook workbook, String pathToFile) throws Throwable {
        FileOutputStream fileOut = new FileOutputStream(pathToFile);
        workbook.write((OutputStream)fileOut);
        fileOut.close();
    }
}

