/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.excel.updaters;

import com.suncode.plugin.datasource.excel.common.ExcelUtils;
import com.suncode.plugin.datasource.excel.readers.SpreadsheetDataReader;
import com.suncode.plugin.datasource.excel.writers.SpreadsheetDataWriter;
import com.suncode.pwfl.translation.Translator;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpreadsheetDataUpdater {
    private static final Logger log = LoggerFactory.getLogger(SpreadsheetDataUpdater.class);

    public static void updateSheetData(String pathToFile, String sheetName, List<Map<String, String>> primaryKey, String handleNewKey, Map<String, String> parameters, Translator translator) {
        if (!ExcelUtils.doesFileExist(pathToFile)) {
            throw new RuntimeException(translator.getMessage("error.fileNotFound") + ": " + pathToFile);
        }
        try (Workbook workbook = WorkbookFactory.create((InputStream)new FileInputStream(pathToFile));){
            Sheet sheet = workbook.getSheet(sheetName);
            if (sheet == null) {
                throw new RuntimeException(translator.getMessage("error.sheetNotFound") + ": " + sheetName);
            }
            int maxLength = parameters.values().stream().mapToInt(paramValue -> paramValue.split(";", -1).length).max().orElse(0);
            List rowsToUpdate = IntStream.range(0, maxLength).boxed().map(i -> parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((String)e.getValue()).split(";", -1)[i]))).collect(Collectors.toList());
            IntStream.range(0, maxLength).forEach(i -> {
                List<Row> rowsToUpdateList = SpreadsheetDataUpdater.getRowsToUpdate(sheet, (Map)primaryKey.get(i));
                if (!rowsToUpdateList.isEmpty()) {
                    for (Row rowToUpdate : rowsToUpdateList) {
                        SpreadsheetDataWriter.writeValuesToRow(sheet.getRow(0), rowToUpdate, (Map)rowsToUpdate.get(i));
                    }
                } else {
                    if (handleNewKey.equals("block")) {
                        throw new RuntimeException(translator.getMessage("error.rowNotFound") + ": " + primaryKey);
                    }
                    if (handleNewKey.equals("pass")) {
                        log.warn("Row with following primary key '" + primaryKey + "' not found!");
                    } else {
                        ((Map)primaryKey.get(i)).forEach(parameters::put);
                        SpreadsheetDataWriter.writeValuesToRow(sheet.getRow(0), sheet.createRow(sheet.getLastRowNum() + 1), (Map)rowsToUpdate.get(i));
                    }
                }
            });
            SpreadsheetDataWriter.writeChangesToFile(workbook, pathToFile);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static List<Row> getRowsToUpdate(Sheet sheet, Map<String, String> primaryKey) {
        List headerCells = primaryKey.keySet().stream().map(s -> StreamSupport.stream(sheet.getRow(0).spliterator(), false).filter(cell -> cell.getRichStringCellValue().getString().equals(s)).findFirst().orElse(null)).collect(Collectors.toList());
        return IntStream.range(1, sheet.getLastRowNum() + 1).boxed().filter(i -> headerCells.stream().allMatch(cell -> SpreadsheetDataReader.extractCellValue(sheet.getRow(i.intValue()).getCell(cell.getColumnIndex())).equals(primaryKey.get(cell.getRichStringCellValue().getString())))).map(arg_0 -> ((Sheet)sheet).getRow(arg_0)).collect(Collectors.toList());
    }
}

