/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.excel.readers;

import com.suncode.plugin.datasource.excel.common.ExcelUtils;
import com.suncode.plugin.datasource.excel.component.OutputParameter;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.util.SpringContext;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpreadsheetDataReader {
    private static final Logger log = LoggerFactory.getLogger(SpreadsheetDataReader.class);
    private static final DataFormatter DATA_FORMATTER = new DataFormatter(Locale.ENGLISH);

    private SpreadsheetDataReader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Map<String, Object>> readSheetData(String pathToFile, String sheetName, Map<String, OutputParameter> outputParameters, Translator translator, Boolean defaultNumericFormat) {
        String resolvedPathToFile = SpreadsheetDataReader.resolveFilePathByFileId(pathToFile);
        log.info("Resolved path to file: " + resolvedPathToFile);
        if (!ExcelUtils.doesFileExist(resolvedPathToFile)) {
            throw new RuntimeException(translator.getMessage("error.fileNotFound") + ": " + resolvedPathToFile);
        }
        try (Workbook workbook = WorkbookFactory.create((InputStream)new FileInputStream(resolvedPathToFile));){
            List list = StreamSupport.stream(workbook.spliterator(), false).filter(sheet -> sheet.getSheetName().equals(sheetName)).findFirst().map(sheet -> {
                Map<String, Integer> columnPositions = SpreadsheetDataReader.getColumnsPositionMap(sheet.getRow(0), outputParameters, translator);
                return IntStream.range(1, sheet.getLastRowNum() + 1).mapToObj(rowIndex -> SpreadsheetDataReader.getRowContentAtPositions(columnPositions, sheet.getRow(rowIndex), defaultNumericFormat)).collect(Collectors.toList());
            }).orElseThrow(() -> new RuntimeException(translator.getMessage("error.sheetNotFound") + ": " + sheetName));
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static String resolveFilePathByFileId(String pathToFile) {
        if (pathToFile.startsWith("FILEID:{")) {
            FileService fileService = (FileService)SpringContext.getBean(FileService.class);
            long fileId = Long.parseLong(StringUtils.substringBetween((String)pathToFile, (String)"{", (String)"}"));
            WfFile file = fileService.getFile(Long.valueOf(fileId), new String[0]);
            return file.getFullPath();
        }
        return pathToFile;
    }

    private static Map<String, Integer> getColumnsPositionMap(Row firstRow, Map<String, OutputParameter> outputParameters, Translator translator) {
        return outputParameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, outputParameter -> StreamSupport.stream(firstRow.spliterator(), false).filter(cell -> cell.getRichStringCellValue().getString().equals(((OutputParameter)outputParameter.getValue()).getHeader())).findFirst().map(Cell::getColumnIndex).orElseThrow(() -> new RuntimeException(translator.getMessage("error.headerNotFound") + ": " + ((OutputParameter)outputParameter.getValue()).getHeader()))));
    }

    private static Map<String, Object> getRowContentAtPositions(Map<String, Integer> positions, Row row, Boolean defaultNumericFormat) {
        return positions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> SpreadsheetDataReader.extractCellValue(row.getCell(((Integer)e.getValue()).intValue()), defaultNumericFormat)));
    }

    public static Object extractCellValue(Cell cell) {
        return SpreadsheetDataReader.extractCellValue(cell, true);
    }

    public static Object extractCellValue(Cell cell, Boolean defaultNumericFormat) {
        if (cell == null) {
            return "";
        }
        Object result = SpreadsheetDataReader.getCellValue(cell, cell.getCellType(), defaultNumericFormat);
        return result == null ? "" : result;
    }

    private static Object getCellValue(Cell cell, CellType cellType, Boolean defaultNumericFormat) {
        switch (cellType) {
            case NUMERIC: {
                if (Boolean.TRUE.equals(defaultNumericFormat) || DateUtil.isCellDateFormatted((Cell)cell)) {
                    return DATA_FORMATTER.formatCellValue(cell);
                }
                return cell.getNumericCellValue();
            }
            case FORMULA: {
                return SpreadsheetDataReader.getCellValue(cell, cell.getCachedFormulaResultType(), defaultNumericFormat);
            }
            case STRING: 
            case BOOLEAN: {
                return DATA_FORMATTER.formatCellValue(cell);
            }
        }
        return "";
    }
}

