/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.excel.erasers;

import com.suncode.plugin.datasource.excel.common.ExcelUtils;
import com.suncode.plugin.datasource.excel.readers.SpreadsheetDataReader;
import com.suncode.plugin.datasource.excel.writers.SpreadsheetDataWriter;
import com.suncode.pwfl.translation.Translator;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpreadSheetDataEraser {
    private static final Logger log = LoggerFactory.getLogger(SpreadSheetDataEraser.class);

    public static void deleteSheetData(String pathToFile, String sheetName, Map<String, String> primaryKey, Translator translator) {
        if (!ExcelUtils.doesFileExist(pathToFile)) {
            throw new RuntimeException(translator.getMessage("error.fileNotFound") + ": " + pathToFile);
        }
        try (Workbook workbook = WorkbookFactory.create((InputStream)new FileInputStream(pathToFile));){
            Sheet sheet = workbook.getSheet(sheetName);
            if (sheet == null) {
                throw new RuntimeException(translator.getMessage("error.sheetNotFound") + ": " + sheetName);
            }
            int maxLength = primaryKey.values().stream().mapToInt(value -> value.split(";", -1).length).max().orElse(0);
            List<Map> listOfRowsToDelete = IntStream.range(0, maxLength).boxed().map(i -> primaryKey.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((String)e.getValue()).split(";", -1)[i]))).collect(Collectors.toList());
            listOfRowsToDelete.forEach(row -> {
                List<Integer> indexesOfRowToDelete = SpreadSheetDataEraser.getIndexesOfRowToDelete(sheet, row, translator);
                log.debug("Deleting row with following primary key " + row);
                if (indexesOfRowToDelete.isEmpty()) {
                    log.warn("Row containing following primary key " + primaryKey + " not found!");
                }
                for (int i = 0; i < indexesOfRowToDelete.size(); ++i) {
                    sheet.shiftRows(indexesOfRowToDelete.get(i) - i + 1, sheet.getLastRowNum() + 1, -1);
                }
            });
            SpreadsheetDataWriter.writeChangesToFile(workbook, pathToFile);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static List<Integer> getIndexesOfRowToDelete(Sheet sheet, Map<String, String> primaryKey, Translator translator) {
        List headerCells = primaryKey.keySet().stream().map(s -> StreamSupport.stream(sheet.getRow(0).spliterator(), false).filter(cell -> cell.getRichStringCellValue().getString().equals(s)).findFirst().orElseThrow(() -> new RuntimeException(translator.getMessage("error.primaryKeyHeaderNotFound") + ": " + s))).collect(Collectors.toList());
        return IntStream.range(1, sheet.getLastRowNum() + 1).boxed().filter(i -> headerCells.stream().allMatch(cell -> sheet.getRow(i.intValue()) == null || SpreadsheetDataReader.extractCellValue(sheet.getRow(i.intValue()).getCell(cell.getColumnIndex())).equals(primaryKey.get(cell.getRichStringCellValue().getString())))).collect(Collectors.toList());
    }
}

