/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.excel.controler;

import com.suncode.plugin.datasource.excel.util.ExcelSpringContext;
import com.suncode.plugin.datasource.excel.util.PluginInfo;
import com.suncode.plugin.googlecloudintegrator.googledrive.dto.FileInfo;
import com.suncode.plugin.googlecloudintegrator.googledrive.service.GoogleIntegratorService;
import com.suncode.pwfl.search.CountedResult;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"excel"})
public class ExcelController {
    @Autowired
    private PluginInfo pluginInfo;

    @RequestMapping(value={"/GoogleDrive/{configId}/files"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<FileInfo> getConfigurationIds(@PathVariable String configId, @RequestParam Integer start, @RequestParam Integer limit, @RequestParam String query) throws IOException {
        ExcelController excelController = this;
        excelController.pluginInfo.checkGoogleCloudLicence();
        GoogleIntegratorService googleIntegratorService = ExcelSpringContext.getBean(GoogleIntegratorService.class);
        String googleDriveQuery = "(mimeType='application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' OR mimeType='application/vnd.google-apps.spreadsheet') AND " + String.format("name contains '%s'", query);
        List fileInfos = googleIntegratorService.listFiles(configId, start.intValue(), limit.intValue(), googleDriveQuery);
        return new CountedResult((long)fileInfos.size(), fileInfos);
    }
}

